#ifndef LCC_VXW_ARCH_H
#define LCC_VXW_ARCH_H
/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lccVxwArch.h,v 1.1 2004/10/18 15:38:51 bjeram Exp $" 
*
* who       when      what
* --------  --------  ----------------------------------------------
* bgustafs  05/07/99  made it C++ compliant
* P.Duhoux   20/07/98   New
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 * System header files, necessary for common functions
 */
#include "vxWorks.h"
#include "symLib.h"
#include "sysSymTbl.h"
#include "math.h"


extern STATUS lccSymFindByName ( SYMTAB_ID    symTblId,
			         const char  *name,
			         char       **pAddr,
			         SYM_TYPE    *pType);

#define lccFindFunctionEntry(n,a) \
     lccSymFindByName(NULL,(n),(char **)(a),NULL)
#define lccFindSymbolAddress(n,a) \
     lccSymFindByName(NULL,(n),(char **)(a),NULL)

extern double lccRound         ( double x );
extern int    lccIRound        ( double x );

#define symFindByName lccSymFindByName

/*
 * redefine all not POSIX math functions so as to generate a compiler warning
 */
#define acosf     acosf_is_not_POSIX_compliant_use_acos
#define asinf     asinf_is_not_POSIX_compliant_use_asin
#define atanf     atanf_is_not_POSIX_compliant_use_atan
#define atan2f    atan2f_is_not_POSIX_compliant_use_atan2
#define ceilf     ceilf_is_not_POSIX_compliant_use_ceil
#define cosf      cosf_is_not_POSIX_compliant_use_cos
#define coshf     coshf_is_not_POSIX_compliant_use_cosh
#define expf      expf_is_not_POSIX_compliant_use_exp
#define fabsf     fabsf_is_not_POSIX_compliant_use_fabs
#define floorf    floorf_is_not_POSIX_compliant_use_floor
#define fmodf     fmodf_is_not_POSIX_compliant_use_fmod
#define logf      logf_is_not_POSIX_compliant_use_log
#define log10f    log10f_is_not_POSIX_compliant_use_log10
#define powf      powf_is_not_POSIX_compliant_use_pow
#define sinf      sinf_is_not_POSIX_compliant_use_sin
#define sinhf     sinhf_is_not_POSIX_compliant_use_sinh
#define sqrtf     sqrtf_is_not_POSIX_compliant_use_sqrt
#define tanf      tanf_is_not_POSIX_compliant_use_tan
#define tanhf     tanhf_is_not_POSIX_compliant_use_tanh

#define cbrt      cbrt_is_not_POSIX_compliant
#define hypot     hypot_is_not_POSIX_compliant
#define infinity  infinity_is_not_POSIX_compliant
#define irint     irint_is_not_POSIX_compliant
#define iround    iround_is_not_POSIX_compliant_use_lccIRound
#define log2      log2_is_not_POSIX_compliant
#define rint      rint_is_not_POSIX_compliant
#define round     round_is_not_POSIX_compliant_use_lccRound
#define sincos    sincos_is_not_POSIX_compliant
#define trunc     trunc_is_not_POSIX_compliant

#define cbrtf     cbrtf_is_not_POSIX_compliant
#define hypotf    hypotf_is_not_POSIX_compliant
#define infinityf infinityf_is_not_POSIX_compliant
#define irintf    irintf_is_not_POSIX_compliant
#define iroundf   iroundf_is_not_POSIX_compliant_use_lccIRound
#define log2f     log2f_is_not_POSIX_compliant
#define roundf    roundf_is_not_POSIX_compliant_use_lccRound
#define sincosf   sincosf_is_not_POSIX_compliant
#define truncf    truncf_is_not_POSIX_compliant

#ifdef __cplusplus
}
#endif

#endif  /* !LCC_VXW_ARCH_H */
