/*****************************************************************************
**
* E.S.O. - VLT project
*
* @(#) $ID: $
*
* who       when      what
* --------  --------  ----------------------------------------------
* mnastvog  07/03/96  Variant of x_cl.c, which uses the usno.fk5.app.dat
*                     file as input.
*                     The comparison of the computed (from mean) and reference
*                     apparent places takes place in the same way.
* mnastvog  27/06/95  created
*/
/*************************************************************************/
#include "vltPort.h"
#include "stdlib.h"

static char *rcsId="@(#) $Id: x_jp.c,v 1.2.14.1 2010/04/29 22:23:28 javarias Exp $";

/* file: x_cl.c
** sccs: @(#)x_cl.c UW-SAL 1.1 (1/2/94)
** Copyright 1992,1993 University of Wisconsin
** *******************************************************************
** Space Astronomy Laboratory
** University of Wisconsin
** 1150 University Avenue
** Madison, WI 53706 USA
** *******************************************************************
** Do not use this software without permission.
** Do not use this software without attribution.
** Do not remove or alter any of the lines above.
** *******************************************************************
*/
#ifndef lint
static char *sccs = "@(#)x_cl.c UW-SAL 1.1 (1/2/94)";
#endif

/*
** *******************************************************************
** x_cl - test the pointing machine
** *******************************************************************
*/

#define _INCLUDE_HPUX_SOURCE
/*#include "time.h"*/
/*#include "timexLib.h"*/
#undef _INCLUDE_HPUX_SOURCE
#include "stdio.h"
#include "math.h"
#include "slalib.h"
#include "slamac.h"
/*#define DEBUG*/
#undef DEBUG
#undef TIMER 
#define TIMER

double amprms[21]; /* global data array */
double aoprms[14]; /* global data array */

int parsePercival(char * fkBuffer, long * fk5Star,
             double * rm, double * dm, double * ref_rpm, double * ref_dpm,
             double * ref_parallax,double * ref_radvel, 
             double * ra, double * da)
{
    int  convertStatus;
    int fcharPtr = 1;
    double dummyDouble;

    slaIntin(fkBuffer,&fcharPtr,fk5Star,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (1): %s\n",fkBuffer);
        exit(11);
        }
    slaDfltin(fkBuffer,&fcharPtr,&dummyDouble,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (1): %s\n",fkBuffer);
        exit(11);
        }
    slaDafin(fkBuffer,&fcharPtr,rm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (2): %s\n",fkBuffer);
        exit(11);
        }
    *rm *= 15.0;
    slaDfltin(fkBuffer,&fcharPtr,ref_rpm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(4): %s\n",fkBuffer);
        exit(11);
        }
    /*
     * Note:
     * The fk5 catalogue used in the test lists the proper motions per
     * year instead of per centennium as the written catalogue does.
     * So it is correct to use values directly with slalib which expects
     * also values per year
     */
    *ref_rpm *= DAS2R  * 15.0 ; /* arcseconds per year instead of centennium */
    slaDafin(fkBuffer,&fcharPtr,dm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (3): %s\n",fkBuffer);
        exit(11);
        }
    slaDfltin(fkBuffer,&fcharPtr,ref_dpm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(5): %s\n",fkBuffer);
        exit(11);
        }
    *ref_dpm *= DAS2R;
    fcharPtr = 67;
    slaDfltin(fkBuffer,&fcharPtr,ref_parallax,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(6): %s\n",fkBuffer);
        exit(11);
        }
    slaDfltin(fkBuffer,&fcharPtr,ref_radvel,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(7): %s\n",fkBuffer);
        exit(11);
        }
    fcharPtr = 84;
    slaDafin(fkBuffer,&fcharPtr,ra,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (8): %s\n",fkBuffer);
        exit(11);
        }
    *ra *= 15.0;
    slaDafin(fkBuffer,&fcharPtr,da,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (9): %s\n",fkBuffer);
        exit(11);
        }
/*
 *  now we have the mean reference star in the form we want it  
 */
    return 0;
}
int parseFk5(char * fkBuffer, long * fk5Star,
             double * rm, double * dm, double * ref_rpm, double * ref_dpm,
             double * ref_parallax,double * ref_radvel)
{
    int  convertStatus;
    int fcharPtr = 1;
    slaIntin(fkBuffer,&fcharPtr,fk5Star,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (1): %s\n",fkBuffer);
        exit(11);
        }
    slaDafin(fkBuffer,&fcharPtr,rm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (2): %s\n",fkBuffer);
        exit(11);
        }
    slaDafin(fkBuffer,&fcharPtr,dm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: fk line not ok (3): %s\n",fkBuffer);
        exit(11);
        }
    *rm *= 15.0;
    slaDfltin(fkBuffer,&fcharPtr,ref_rpm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(4): %s\n",fkBuffer);
        exit(11);
        }
    /*
     * Note:
     * The fk5 catalogue used in the test lists the proper motions per
     * year instead of per centennium as the written catalogue does.
     * So it is correct to use values directly with slalib which expects
     * also values per year
     */
    *ref_rpm *= DAS2R  / cos(*dm); /* per year instead of centennium */
    slaDfltin(fkBuffer,&fcharPtr,ref_dpm,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(5): %s\n",fkBuffer);
        exit(11);
        }
    *ref_dpm *= DAS2R;

    slaDfltin(fkBuffer,&fcharPtr,ref_parallax,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(6): %s\n",fkBuffer);
        exit(11);
        }
    slaDfltin(fkBuffer,&fcharPtr,ref_radvel,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(7): %s\n",fkBuffer);
        exit(11);
        }
/*
 *  now we have the mean reference star in the form we want it  
 */
    return 0;
}

int parseApparent(char * stringBuffer,long * appStar, double * utc,
                  double * ref_ra, double * ref_da)
{
    int charPtr = 1;
    double doubleVal;
    int  convertStatus;

    slaIntin(stringBuffer,&charPtr,appStar,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok (n): %s\n",stringBuffer);
        exit(11);
        }
    slaDfltin(stringBuffer,&charPtr,&doubleVal,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok (1): %s\n",stringBuffer);
        exit(11);
        }
    *utc = doubleVal;
    slaDfltin(stringBuffer,&charPtr,&doubleVal,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(2): %s\n",stringBuffer);
        exit(11);
        }
    *ref_ra = doubleVal * 15.0 * DAS2R;  

    slaDfltin(stringBuffer,&charPtr,&doubleVal,&convertStatus);
    if(convertStatus > 0)
        {
        (void)fprintf(stdout, "x_cl: line not ok(3): %s\n",stringBuffer);
        exit(11);
        }

    *ref_da = doubleVal * DAS2R;
    *utc -= 2400000.5;
    return 0;
}



void

#ifdef MAKE_VXWORKS
x_cl()
#else
main()
#endif
{
#ifdef TIMER 
#ifdef MAKE_VXWORKS
    time_t tv;
    char timeBuffer[80];
#else
#endif
#endif
    char stringBuffer[150];
    char fkBuffer[150];
    int  charPtr,fcharPtr;  
    double doubleVal;
/*
 *  fk5Star and appStar are the star numbers. The program syncronizes with
 *     these variables between the two input files 
 */
    long  fk5Star = -1;
    long  appStar = 0;
    long  oldFk5Star;
/*
 *  Total number of stars processed
 */
    long  starCount = 0;
/*
 *  Input, output and summing variables
 */
    double errRaSqrSum = 0;
    double errDaSqrSum = 0;
    double ref_ra, ref_da, ref_rpm, ref_dpm, ref_parallax, ref_radvel;
    double err_r_sec, err_d_asec;
    int    err_r_group, err_d_group;
    int  convertStatus;
    FILE * inFile, *outFile, *fkFile, *appFile;
    int i;
    int s1;	/* start state */
    int s2;	/* end state */
    double utc;
    int status;
    char sign;
    int idmsf[4];
    double rm,dm,ra,da,aob,hob,zob,rob,dob;
    double delta_at = 28;
    double delta_ut = 0.5;
    double longitude = -1.5;
    double latitude = 0.8;
    double height = 359.0;
    double xpole = 0.0;
    double ypole = 0.0;
    double temperature = 273.0;
    double pressure = 960.0;
    double humidity = 0.1;
    double wavelength = 0.55;

    /************************/
    /* make files available */
    /************************/

    inFile = fopen("stars.in","r");
    fkFile = fopen("fk5.in","r");
    appFile = fopen("usno.fk5.app.dat","r");
    outFile = fopen("/tmp/stars.out","w");
    if(inFile == NULL || outFile == NULL)
        {
        (void)fprintf(stdout, "x_cl: files not ok\n");
        exit(10);
        }


    /**********************/
    /* compute the tstate */
    /**********************/
    (void)fprintf(stdout, "x_cl: Measurement of slalib accuracy\n");
    (void)fprintf(stdout, "x_cl:  ...get_tstate function\n");
for (i = 0;i < 1600;i++)
    {
    oldFk5Star = fk5Star;
    fgets(fkBuffer,140,appFile);
    parsePercival(fkBuffer, &fk5Star,
             &rm, &dm, &ref_rpm, &ref_dpm,
             &ref_parallax,&ref_radvel,&ref_ra,&ref_da);
    if (oldFk5Star == 1640)
        exit(12);
    appStar = fk5Star;
    utc = 2450136.3000 -  2400000.5;
/*
 *  Sync the apparent stars file to the starnumber we processed in the fk5 file
 */
    (void)fprintf(stdout, "x_cl: starNr: %ld\n",appStar);
    (void)fprintf(outFile, "x_cl: starNr: %ld\n",appStar);
    


/*
 *  convert into apparent places
 */
    slaMappa(2000.0, utc, amprms);
    slaAoppa ( utc, 0, -((double)longitude), latitude, height,
              0.0, 0.0, temperature, pressure,
              humidity, wavelength, 
              0.0065,aoprms);

    slaMapqk(rm,dm,ref_rpm,ref_dpm,ref_parallax,ref_radvel,amprms,&ra,&da);

    (void)fprintf(stdout, "x_cl: mean: %1.15e %1.15e,last %e\n",rm,dm,aoprms[13]);
    slaAoppat(utc,aoprms);
/* print values */
#if 0
    (void)fprintf(outFile, 
           "x_cl: fk5 r %f %s\n",ra,fmt_hms(r2hms(ra)));
    (void)fprintf(outFile, 
           "x_cl: fk5 d %f %s\n",da,fmt_dms(r2dms(da)));
    (void)fprintf(outFile, 
           "x_cl: ref r %f %s\n",ref_ra,fmt_hms(r2hms(ref_ra)));
    (void)fprintf(outFile, 
           "x_cl: ref d %f %s\n",ref_da,fmt_dms(r2dms(ref_da)));
#else
    slaDr2tf(6,ref_ra,&sign,idmsf);
    (void)fprintf(outFile, 
                  "x_cl: ref      r %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ref_ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    (void)fprintf(stdout, 
                  "x_cl: ref      r %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ref_ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2tf(6,ra,&sign,idmsf);
    (void)fprintf(outFile, 
                  "x_cl: apparent r %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    (void)fprintf(stdout, "x_cl: apparent r %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2af(6,ref_da,&sign,idmsf);
    (void)fprintf(outFile, 
                  "x_cl: ref      d %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ref_da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    (void)fprintf(stdout, 
                  "x_cl: ref      d %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ref_da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2af(6,da,&sign,idmsf);
    (void)fprintf(stdout, 
                  "x_cl: apparent d %1.14f %c%02dd %02dm %02ds.%06d\n",
                  da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    (void)fprintf(outFile, 
                  "x_cl: apparent d %1.14f %c%02dd %02dm %02ds.%06d\n",
                  da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2tf(6,rm,&sign,idmsf);
    (void)fprintf(outFile, 
                  "x_cl: FK       r %s\n",
                  fkBuffer);
    (void)fprintf(outFile, 
                  "x_cl: rm       r %1.14f %c%02dd %02dm %02ds.%06d\n",
                  ref_ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
#endif
/*
 *  and compute error between reference apparent and computed apparent
 */
    (void)fprintf(outFile, 
                  "x_cl: Error r: %e , d: %e\n",
                  (ref_ra - ra)/* * cos(da)*/,(ref_da - da));
    err_r_sec = DR2S *(ref_ra - ra) /** cos(da)*/;
    err_d_asec = DR2AS *(ref_da - da);

    (void)fprintf(outFile, 
                  "x_cl: Error r_s: %e , d_as: %e\n",
                  err_r_sec,err_d_asec);
    err_r_sec = fabs(err_r_sec);
    err_d_asec = fabs(err_d_asec);
/*
 *  Categorize errors into logarithmic groups that are extractable from the
 *     logfile later (eg. with AWK)
 */
    err_r_group = 1;
    if (err_r_sec < 0.0001) { err_r_group = 0;}
    if (err_r_sec > 0.0003) { err_r_group = 2;}
    if (err_r_sec > 0.001)  { err_r_group = 3;}
    if (err_r_sec > 0.003)  { err_r_group = 4;}
    if (err_r_sec > 0.01)   { err_r_group = 5;}
    if (err_r_sec > 0.03)   { err_r_group = 6;}
    if (err_r_sec > 0.1)    { err_r_group = 7;}
    if (err_r_sec > 0.3)    { err_r_group = 8;}
    if (err_r_sec > 1.0)    { err_r_group = 9;}
    if (err_r_sec > 3.0)    { err_r_group = 10;}

    err_d_group = 1;
    if (err_d_asec < 0.001) { err_d_group = 0;}
    if (err_d_asec > 0.003) { err_d_group = 2;}
    if (err_d_asec > 0.01)  { err_d_group = 3;}
    if (err_d_asec > 0.03)  { err_d_group = 4;}
    if (err_d_asec > 0.1)   { err_d_group = 5;}
    if (err_d_asec > 0.3)   { err_d_group = 6;}
    if (err_d_asec > 1.0)   { err_d_group = 7;}
    if (err_d_asec > 3.0)   { err_d_group = 8;}
    if (err_d_asec > 10.0)  { err_d_group = 9;}
    if (err_d_asec > 30.0)  { err_d_group = 10;}

    (void)fprintf(outFile, 
                  "x_cl: Error r_g: %02d , d_g: %02d\n",
                  err_r_group,err_d_group);
    
/*
 *  Sum up errors for RMS summary
 */
    errRaSqrSum += err_r_sec * err_r_sec;
    errDaSqrSum += err_d_asec * err_d_asec;

/*
 *  Now also compute observed places to compare absolute results with slalib 
 */
    slaAopqk(ref_ra,ref_da,aoprms,&aob,&zob,&hob,&dob,&rob);

    (void)fprintf(stdout, "x_cl: az %f,zd %f, ha %f, d %f r %f\n",
		aob,zob,hob,dob,rob);
    (void)fprintf(outFile, "x_cl: az %f,zd %f, ha %f, d %f r %f\n",
		aob,zob,hob,dob,rob);
    (void)fprintf(outFile,"--------------------------------------------\n");

    starCount++;
    }
/*
 *  Tidy up
 */
    (void)fprintf(outFile, "x_cl: ErrRaSqr %e ErrDaSqr %e\n",
		sqrt(errRaSqrSum/starCount),sqrt(errDaSqrSum/starCount));
    fclose(inFile);
    fclose(outFile);
    return(0);
}








