/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2005 
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: loadcalibrationTest.cpp,v 1.3 2008/09/22 14:01:46 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* jkern  2005-01-04  created 
*/

/************************************************************************
*   NAME
*   loadcalibrationTest
* 
*   SYNOPSIS
*   This program will executes SUID root.  This way I can load kernel modules
*   and execute the calibration routine.  
* 
*   DESCRIPTION
*   Note: In this version I have choosen to load/unload kernel modules directly
*   using the lkm library rather than using the loadLKMModule program.  This 
*   reduces the dependance on the CORRCommon module.  However for ACS-4.1 or
*   later the lkmModules will move into ACS and they could be used here.
*------------------------------------------------------------------------
*/

static char *rcsId="@(#) $Id: loadcalibrationTest.cpp,v 1.3 2008/09/22 14:01:46 bjeram Exp $"; 
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);

#include <LKM.h>

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <sys/types.h>
#include <unistd.h>

/* No arguments used */
int main(int argc, char* argv[]) {
  LKM lkm;

  /* Set the uid of the process to root as well */
  try {
    lkm.becomeRoot();
  }
  catch (LKMerror ex) {
    fprintf(stderr,"loadcalibrationTest: Error setting user ID to root\n");
    ex.printErr();
    return -1;
  }

  /* Load the kernel modules needed to run the test */
  try {
    lkm.loadMod("rtai_hal");
    lkm.loadMod("rtai_sched");
    lkm.loadMod("rtai_fifos");
  }
  catch (LKMerror ex) {
    fprintf(stderr,"Error Loading Kernel modules\n");
    ex.printErr();
    return -1;
  }

  /* The calibration program need to be run externaly build the string
   * to use in a system command
   */
  sleep(1); //wait that rtfXY are created
  std::string cmd = getenv("ALMASW_INSTDIR");
  cmd += "/rtai/calibration/calibrate -k";
  system(cmd.c_str());
}
