/*
 * TestAlarmConsoleLoginWindow.java
 *
 * Created on March 31, 2003, 1:27 PM
 */

package cern.laser.guiplatform.windows.login;

import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;

import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

import cern.laser.client.LaserConnectionException;
import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConfigurationNotFoundException;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.LaserUserNotFoundException;
import cern.laser.console.User;
import cern.laser.console.UserHandler;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.category.CategoriesPreLoader;
import cern.laser.guiplatform.category.CategoryBrowsingHandlerFactory;
import cern.laser.guiplatform.logging.TraceLogger;
import cern.laser.guiplatform.user.UserHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.AlarmStatisticInfoPanel;
import cern.laser.guiplatform.windows.InstantFaultExplorer;
import cern.laser.guiplatform.windows.WindowConstants;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;

/**
 *
 * @author  pawlowsk
 */
public class AlarmConsoleLoginWindow extends TopComponent {
    
    /** Creates new form TestAlarmConsoleLoginWindow */
    public AlarmConsoleLoginWindow() {
        initComponents();
        postInitComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        labelPanel = new javax.swing.JPanel();
        titleLabel = new javax.swing.JLabel();
        mainPanel = new javax.swing.JPanel();
        textFieldPanel = new javax.swing.JPanel();
        loginNameLabel = new javax.swing.JLabel();
        loginNameTextField = new javax.swing.JTextField();
        passwordLabel = new javax.swing.JLabel();
        passwordPasswordField = new javax.swing.JPasswordField();
        iconPanel = new javax.swing.JPanel();
        iconLabel = new javax.swing.JLabel();
        southPanel = new javax.swing.JPanel();
        butonsPanel = new javax.swing.JPanel();
        loginButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        guestButton = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        setPreferredSize(new java.awt.Dimension(415, 300));
        labelPanel.setLayout(new java.awt.BorderLayout());

        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        labelPanel.add(titleLabel, java.awt.BorderLayout.CENTER);

        add(labelPanel, java.awt.BorderLayout.NORTH);

        mainPanel.setLayout(new java.awt.BorderLayout());

        textFieldPanel.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 0, 12);
        textFieldPanel.add(loginNameLabel, gridBagConstraints);

        loginNameTextField.setPreferredSize(new java.awt.Dimension(100, 22));
        loginNameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                loginNameTextFieldKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        textFieldPanel.add(loginNameTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 14, 0, 28);
        textFieldPanel.add(passwordLabel, gridBagConstraints);

        passwordPasswordField.setPreferredSize(new java.awt.Dimension(100, 22));
        passwordPasswordField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                passwordPasswordFieldKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        textFieldPanel.add(passwordPasswordField, gridBagConstraints);

        mainPanel.add(textFieldPanel, java.awt.BorderLayout.CENTER);

        iconPanel.setLayout(new java.awt.GridBagLayout());

        iconLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cern/laser/guiplatform/images/marvmad.gif")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 25, 0, 25);
        iconPanel.add(iconLabel, gridBagConstraints);

        mainPanel.add(iconPanel, java.awt.BorderLayout.EAST);

        add(mainPanel, java.awt.BorderLayout.CENTER);

        southPanel.setLayout(new java.awt.BorderLayout());

        loginButton.setPreferredSize(new java.awt.Dimension(80, 27));
        loginButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loginButtonActionPerformed(evt);
            }
        });

        butonsPanel.add(loginButton);

        cancelButton.setPreferredSize(new java.awt.Dimension(80, 29));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        butonsPanel.add(cancelButton);

        guestButton.setText("Login as a guest");
        guestButton.setToolTipText("Guest facility. Try out a LASER!");
        guestButton.setPreferredSize(new java.awt.Dimension(137, 29));
        guestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                guestButtonActionPerformed(evt);
            }
        });

        butonsPanel.add(guestButton);

        southPanel.add(butonsPanel, java.awt.BorderLayout.CENTER);

        add(southPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents
    
    private void guestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_guestButtonActionPerformed
        loginNameTextField.setText( Constants.GUEST_USER_NAME);
        passwordPasswordField.setText( Constants.GUEST_USER_PASSWORD );
        login();
    }//GEN-LAST:event_guestButtonActionPerformed
    
    //public java.awt.Dimension getPreferredSize() {
    //    return new java.awt.Dimension(415, 300);
    //}
    
    
    private void passwordPasswordFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_passwordPasswordFieldKeyReleased
        // Add your handling code here:
        enableOrDisableLoginButton();
        
    }//GEN-LAST:event_passwordPasswordFieldKeyReleased
    
    private void loginNameTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_loginNameTextFieldKeyReleased
        // Add your handling code here:
        enableOrDisableLoginButton();
    }//GEN-LAST:event_loginNameTextFieldKeyReleased
    
    /** This method enables or disables login button */
    private void enableOrDisableLoginButton() {
        if (loginNameTextField.getText().length() > 0 && passwordPasswordField.getPassword().length > 0) {
            loginButton.setEnabled(true);
            getRootPane().setDefaultButton(loginButton);
        }   else
            loginButton.setEnabled(false);
    }
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // Add your handling code here:
        TraceLogger.log("User press cancel button !!");
        this.close();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void loginButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loginButtonActionPerformed
        login();
    }//GEN-LAST:event_loginButtonActionPerformed
    
    /**
     * This method should be invoked after <code>initComponet()</code>
     * method
     */
    private void postInitComponents() {
        
        // for topcomponent
        //setPreferredSize(new java.awt.Dimension(Constants.LOGIN_WINDOW_WIDTH,
        //                                        Constants.LOGIN_WINDOW_HEIGHT));
        
        //setBounds(Utilities.findCenterBounds(getPreferredSize()));
        //setCloseOperation(TopComponent.CLOSE_LAST);
        setCloseOperation(TopComponent.CLOSE_EACH);
        
        // not serialize
        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");
        
        
        titleLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "LOGIN_window_title"));
        loginButton.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "LOGIN_string"));
        
        loginButton.setEnabled(false);
        cancelButton.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "CANCEL_string"));
        passwordLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "PASSWORD_string"));
        loginNameLabel.setText(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "LOGIN_NAME_string"));
        
        setName(NbBundle.getMessage(AlarmConsoleLoginWindow.class,
        "LOGIN_window_name"));
        
        
        
        
        //
        // This should be moved somewhere else
        //
        
        // add windowListener to main window
        WindowManager.getDefault().getMainWindow().addWindowListener(
        new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                logger.debug(" windows is being closed " );
                
                
                // close all apropriate TopComponents
                AcWindowManager.closeAllTopComponents();
                
                try {
                    AlarmSelectionHandler jms_selectionHandler =
                    AlarmSelectionHandlerFactory.getHandler();
                    // disconnect from BL
                    
                    jms_selectionHandler.resetSelection();
                } catch (LaserException le) {
                    logger.error(le.getMessage(), le);
                    logger.error(le.getRootCause().getMessage(), le.getRootCause());
                }
                
                cern.laser.guiplatform.util.ProxyBuffer.getDefault().disable();
                cern.laser.guiplatform.util.ProxyBuffer.getDefault().close();
                
                // clear AlarmConstainer
                AlarmContainer.getDefault().clearContainer();
                logger.debug("AlarmContainer was cleared!!");
                
                // clear AppRegister
                AppRegister.getInstance().unregisterUser();
                AppRegister.getInstance().cleanRegister();
                
            }
        });
    }
    
    // methods from TopComponent
    protected void componentClosed() {
        super.componentClosed();
    }
    
    public boolean canClose(Workspace workspace, boolean last) {
        return super.canClose(workspace, last);
    }
    // methods performs all tasks needed in login time. Invoked from 'Login' and 'Login as a guest' Actions
    //
    //
    private void login() {
        // Add your handling code here:
        TraceLogger.log("User \"" + loginNameTextField.getText() +
        "\" is trying to login");
        logger.debug("User \"" + loginNameTextField.getText() +
        "\" is trying to login");
        System.out.println("user login - system out");
        
        logger.debug("marek: (logger) " + System.getProperty("log4j.configuration"));     
        TraceLogger.log("marek: (trace logger) " + System.getProperty("log4j.configuration"));
        
        String loginName = loginNameTextField.getText();
        char [] char_password = passwordPasswordField.getPassword();
        String password = new String(char_password);
        
        boolean withoutDefaultConf = false;
        boolean isTimeoutOccured = false;
        
        UserHandler userHandler = null;
        User user = null;
        Configuration defaultConf = null;
        String defaultConfName = null;
        
        // initialize the Category Loader, it will load all categories
        // later used by category tree explorer
                        
        CategoriesPreLoader.getInstance();

        try {
            userHandler = UserHandlerFactory.getHandler();
            logger.debug("after UserHandlerFactory");
            user = userHandler.getUser(loginName);
            logger.debug("after getUser");
            if ( user == null) {
            	throw new LaserConnectionException("cannot get User");
            }
            
            if ( user.getName()!= Constants.GUEST_USER_NAME && !user.getPassword().equals(password) ) {
                NotifyDescriptor errorDescriptor =
                new NotifyDescriptor.Message(
                NbBundle.getMessage(AlarmConsoleLoginWindow.class,
                "USER_PASSWORD_NOT_VALID_message",
                loginName),
                NotifyDescriptor.ERROR_MESSAGE);
                
                DialogDisplayer.getDefault().notify(errorDescriptor);
                loginNameTextField.setText("");
                passwordPasswordField.setText("");
                loginButton.setEnabled(false);
                return;
            }
            
            // clean predefined configuration, created automatically by
            // console
            try {
                if ( user.getConfiguration(Constants.DEFAULT_CONFIGURATION_NAME) != null ) {
	                user.removeConfiguration(Constants.DEFAULT_CONFIGURATION_NAME);
                }
            } catch (LaserConfigurationNotFoundException lcnf) {
                // user.removeConfiguration
                //logger.warn(lcnf, lcnf.fillInStackTrace());
                logger.warn("deleting DEFAULT_CONFIGURATION_NAME " +
                Constants.DEFAULT_CONFIGURATION_NAME);
                System.err.println("### (LaserConfigurationNotFoundException):"+"Deleting DEFAULT_CONFIGURATION_NAME " +
                Constants.DEFAULT_CONFIGURATION_NAME);
            } catch (LaserConnectionException lce) {
                // user.removeConfiguration
                //logger.warn(lcnf, lcnf.fillInStackTrace());
                logger.warn("deleting DEFAULT_CONFIGURATION_NAME " +
                Constants.DEFAULT_CONFIGURATION_NAME);
                System.err.println("### (LaserConnectionException)"+"Deleting DEFAULT_CONFIGURATION_NAME " +
                        Constants.DEFAULT_CONFIGURATION_NAME);
            }
            
            // for test only
            //throw new LaserConsoleException();
            
            defaultConf = user.getDefaultConfiguration();
            
            if ( defaultConf == null ) {
                withoutDefaultConf = true;
                
                logger.debug("user: " + user.getName() + " does not have default configuration");
                defaultConf = user.createConfiguration(
                Constants.DEFAULT_CONFIGURATION_NAME);
            }
            defaultConfName = defaultConf.getName();
        } catch (LaserUserNotFoundException lune) {
        	System.out.println("### login exception: LaserUserNotFoundException");
            close();
            logger.warn("User " + loginName + " does not exists.");
            TraceLogger.log("User " + loginNameTextField.getText() + " login failed ");
            NotifyDescriptor errorDescriptor =
            new NotifyDescriptor.Message(
            NbBundle.getMessage(AlarmConsoleLoginWindow.class,
            "USER_DOES_NOT_EXIST_message",
            loginName),
            NotifyDescriptor.ERROR_MESSAGE);
            
            DialogDisplayer.getDefault().notify(errorDescriptor);
            loginNameTextField.setText("");
            passwordPasswordField.setText("");
            loginButton.setEnabled(false);
            return;
        }
        catch (LaserConnectionException lce) {
        	System.out.println("### login exception: LaserConnectionException");
            close();
            TraceLogger.log("User " + loginNameTextField.getText() + " login failed ");
            NotifyDescriptor errorDescriptor =
            new NotifyDescriptor.Message(
            "Connection Problem",
            NotifyDescriptor.ERROR_MESSAGE);
            
            DialogDisplayer.getDefault().notify(errorDescriptor);
            loginNameTextField.setText("");
            passwordPasswordField.setText("");
            loginButton.setEnabled(false);
            return;
        }
        catch (LaserConsoleException le) {
        	System.out.println("### login exception: LaserConsoleException");
            close();
            logger.error(le.getMessage(), le);
            logger.error(le.getRootCause().getMessage(), le.getRootCause());
            /*
            NotifyDescriptor d = new NotifyDescriptor.Message(
                "Connection problem. Try later.", NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(d);
            loginNameTextField.setText("");
            passwordPasswordField.setText("");
            loginButton.setEnabled(false);
            return;
             */
            
            // ISSUE LSR-67
            
            
            try {
            	if( user != null) {
            		withoutDefaultConf = true;
                	defaultConf = user.createConfiguration(Constants.DEFAULT_CONFIGURATION_NAME);
                	defaultConfName = defaultConf.getName();
                	isTimeoutOccured = true;
            	}
            	else {
            		throw new LaserConsoleException("user is null");
            	}
            }
            catch (LaserConsoleException lex) {
                logger.error(le.getMessage(), le);
                logger.error(le.getRootCause().getMessage(), le.getRootCause());
                
                NotifyDescriptor d = new NotifyDescriptor.Message(
                "Connection problem. Try later.", NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(d);
                loginNameTextField.setText("");
                passwordPasswordField.setText("");
                loginButton.setEnabled(false);
                return;
            }
        }
        
        this.close();
        try {
            // user is successfully logged
            
            //
            // --  initialize active list inhibit list, mask list etc  --------
            //
            logger.debug("selection: ");
            logger.debug(defaultConf.getSelection());
            
            AlarmSelectionHandler jms_selectionHandler =
            AlarmSelectionHandlerFactory.getHandler();
            
            logger.debug("selecting ........... ");
            
            ProxyBuffer.getDefault().registerAlarmSelectionListener(
            AlarmContainer.getDefault());
            
            // Add all the categories
            //cern.laser.client.impl.services.selection.CategorySelectionImpl catSel = new cern.laser.client.impl.services.selection.CategorySelectionImpl();
            //catSel.addAll(CategoriesPreLoader.getInstance().getChildren(CategoryBrowsingHandlerFactory.getHandler().getCategoryTreeRoot()));
            //defaultConf.getSelection().setCategorySelection(catSel);
            
            java.util.Map activeAlarms =
            jms_selectionHandler.select(defaultConf.getSelection(),
            ProxyBuffer.getDefault() );
            
            
            logger.debug("selected " + activeAlarms.size() + " alarms ");
            //logger.debug("active alarms: ");
            //for (java.util.Iterator iter = activeAlarms.values().iterator(); iter.hasNext(); ) {
            //    logger.debug(((cern.laser.client.data.Alarm) iter.next()).getTriplet().toString());
            //}
            
            AlarmContainer.getDefault().initContainer(activeAlarms, defaultConf);
            
            //ProxyBuffer.getDefault().enable();
            
            AppRegister.getInstance().registerLoadedConfiguration(defaultConf);
            String [] columnToDisplay = AppRegister.getInstance().getBehaviour().getColumnsToDisplay();
            
            //String [] columnsToDisplayWithDataAndTime = new String [columnToDisplay.length+2];
            //columnsToDisplayWithDataAndTime[0] = "date";
            //columnsToDisplayWithDataAndTime[1] = "time";
            //for( int i=0; i<columnToDisplay.length; i++ ) {
            //    columnsToDisplayWithDataAndTime[i+2] = columnToDisplay[i];
            //}
            
            AlarmNodeManager activeListManager =
            AlarmContainer.getDefault().getAlarmNodeManager(
            Constants.ACTIVE_LISTENER_KEY);
            
            // ###
            //activeListManager.addAlarms( activeAlarms.values() );
            
            ActiveListExplorerPanel activeListExpl =
            new ActiveListExplorerPanel(
            activeListManager,
            NbBundle.getMessage(ActiveListExplorerPanel.class,
            "LBL_Active_list_component_name"),
            false, false, columnToDisplay);
            
            /* register explorer in AppRegister (used in print action)*/
            AppRegister.getInstance().registerActiveListExplorerPanel(activeListExpl);
            
            Behaviour behaviourTemp = AppRegister.getInstance().getBehaviour();
            Selection selectionTemp = AppRegister.getInstance().getSelection();
            boolean isReducedMaskSet = selectionTemp.getReducedMaskedSelection();
            
            AlarmStatisticInfoPanel statisticPanel =
            new AlarmStatisticInfoPanel(defaultConfName, behaviourTemp,
            isReducedMaskSet);
            AlarmContainer.getDefault().attach("this_key_has_to_be_changed",
            statisticPanel);
            AlarmContainer.getDefault().addAlarmSelectionOnExceptionListener(statisticPanel);
            activeListExpl.add(statisticPanel, java.awt.BorderLayout.SOUTH, -1);
            
            java.net.URL url = getClass().getClassLoader().getResource(
            "cern/laser/guiplatform/images/spider.gif");
            
            
            AcWindowManager.openTopComponent(activeListExpl,
            Constants.ALARM_LIST_MODE_NAME,
            WindowConstants.CENTER,
            WindowConstants.ALL, url);
            
            // -- open instant list explorer
            TopComponent instantList = null;
            
            
            AlarmNodeManager instantListManager =
            AlarmContainer.getDefault().getAlarmNodeManager(
            Constants.INSTANT_LISTENER_KEY);
            
            
            instantList = new InstantFaultExplorer(instantListManager, columnToDisplay);
            //instantList = new InstantFaultExplorer(null, columnToDisplay);
            AcWindowManager.openInMode(Constants.INSTANT_LIST_MODE_NAME, instantList);
            
            
            AppRegister.getInstance().registerUser(user);
            ProxyBuffer.getDefault().enable();
            withoutDefaultConf=true;
            // this is when user does not have default configuration
            if ( withoutDefaultConf ) {
                final TopComponent top = new ConsoleConfigurationWindow(user, defaultConf);
                top.open();
                
                final Runnable doLoadAllCategoriesInTreeExplorer = new Runnable() {
                    public void run() {
                        try {
                            ((ConsoleConfigurationWindow)top).loadAllCategoriesInTreeExplorer();
                        }
                        catch (IntrospectionException ie) {
                            logger.error(ie.getMessage(), ie);
                            NotifyDescriptor d = new NotifyDescriptor.Message(
                            "Unable to create configuration window", NotifyDescriptor.ERROR_MESSAGE);
                            DialogDisplayer.getDefault().notify(d);
                        } catch (CloneNotSupportedException ie) {
                            logger.error(ie.getMessage(), ie);
                            NotifyDescriptor d = new NotifyDescriptor.Message(
                            "Unable to create configuration window", NotifyDescriptor.ERROR_MESSAGE);
                            DialogDisplayer.getDefault().notify(d);
                        }
                    }
                };
                
                EventQueue.invokeLater(doLoadAllCategoriesInTreeExplorer);
                
                NotifyDescriptor d;
                if( isTimeoutOccured ) {
                    d = new NotifyDescriptor.Message(
                    "Default configuration took too long and timed out\n" +
                    "Please reduce your default selection or request an alternative, reduced config"
                    , NotifyDescriptor.INFORMATION_MESSAGE);
                }
                else {
                    if ( AppRegister.getInstance().isGuestMode() == false ) {
                        d = new NotifyDescriptor.Message(
                        "User " + loginName + " does not have default configuraiton.\n" +
                        "Please create default configuration, save it, and press Apply button"
                        , NotifyDescriptor.INFORMATION_MESSAGE);
                    }
                    else {
                        d = new NotifyDescriptor.Message(
                        "Welcome in the LASER Alarm Console. You are in a Guest mode.\n" +
                        "To check the system please load or create a configuration and press Apply button."
                        , NotifyDescriptor.INFORMATION_MESSAGE);
                    }
                    
                }
                DialogDisplayer.getDefault().notify(d);
            }
            
            
        } catch (LaserConsoleException lce) {
            // register configuration
            // conf.getSelection() -- serialVersionUID is not valid
            close();
            logger.error(lce.getMessage(), lce);
            logger.error(lce.getRootCause().getMessage(), lce.getRootCause());
            NotifyDescriptor d = new NotifyDescriptor.Message(
            "Selection problem", NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(d);
            return;
            
        } catch (LaserException le) {
            close();
            // AlarmSelectionHandlerFactory.getHandler();
            // or ConsoleConfigurationWindow()
            logger.error(le.getMessage(), le);
            logger.error(le.getRootCause().getMessage(), le.getRootCause());
            NotifyDescriptor selectErrorDescriptor =
            new NotifyDescriptor.Message(
            NbBundle.getMessage(AlarmConsoleLoginWindow.class,
            "LASER_EXCEPTION_SELECT_message"),
            NotifyDescriptor.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(selectErrorDescriptor);
            return;
        }
        
        // switch to this workspace
        AcWindowManager.activateDefaultWorkspace();
        
        //this.close();       // close login window
        TraceLogger.log("User " + loginNameTextField.getText() + " successfully logged ");
        AcWindowManager.setStatusText(
        NbBundle.getMessage(
        AlarmConsoleLoginWindow.class,
        "USER_SUCCESSFULLY_LOGGED_message",
        loginName + " ")
        );
        
        // for setting row height
        String activeListTopName = NbBundle.getMessage(
        cern.laser.guiplatform.windows.ActiveListExplorerPanel.class,
        "LBL_Active_list_component_name");
        Behaviour behaviour = AppRegister.getInstance().getBehaviour();
        AcWindowManager.setTableColumns(activeListTopName , behaviour.getColumnsToDisplay());
        
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel butonsPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton guestButton;
    private javax.swing.JLabel iconLabel;
    private javax.swing.JPanel iconPanel;
    private javax.swing.JPanel labelPanel;
    private javax.swing.JButton loginButton;
    private javax.swing.JLabel loginNameLabel;
    private javax.swing.JTextField loginNameTextField;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JLabel passwordLabel;
    private javax.swing.JPasswordField passwordPasswordField;
    private javax.swing.JPanel southPanel;
    private javax.swing.JPanel textFieldPanel;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables
    /** logger */
    private static Logger logger =
    LogFactory.getLogger(AlarmConsoleLoginWindow.class.getName());
    
}
