/*
 * AlarmStatisticInfoPanel.java
 *
 * Created on June 3, 2003, 5:36 PM
 */

package cern.laser.guiplatform.windows;

import javax.swing.JPanel;

import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.client.services.selection.LaserSelectionException;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.alarms.AlarmSelectionOnExceptionListener;
import cern.laser.guiplatform.alarms.AlarmsNumberChangeListener;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.DateTimeUtils;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;

/**
 * 
 * @author pawlowsk
 */
public class AlarmStatisticInfoPanel extends JPanel implements
		AlarmsNumberChangeListener, AlarmSelectionOnExceptionListener {

	/**
	 * Creates new form AlarmStatisticInfoPanel
	 * 
	 * @param configurationName
	 *            currently used configuration name
	 * @param behaviour,
	 *            which is displayed on this panel
	 * @param isReductionMaskeSet
	 */
	public AlarmStatisticInfoPanel(String configurationName,
			Behaviour behaviour, boolean isReductionMaskSet) {
		initComponents();

		postInitComponents(configurationName, behaviour, isReductionMaskSet);

		alarmNumbers = new long[AlarmsNumberChangeListener.ALL_LIST_NUMBER];
		for (int i = 0; i < AlarmsNumberChangeListener.ALL_LIST_NUMBER; i++)
			alarmNumbers[i] = 0;
		activeCounterLabel.setText("" + alarmNumbers[ACTIVE_ALARM_COUNTER]);
		maskedCounterLabel.setText("" + alarmNumbers[MASKED_ALARM_COUNTER]);
		inhibitedCounterLabel.setText(""
				+ alarmNumbers[INHIBITED_ALARM_COUNTER]);

		// adding counterLabels to matrix
		labels = new javax.swing.JLabel[AlarmsNumberChangeListener.ALL_LIST_NUMBER];
		labels[ACTIVE_ALARM_COUNTER] = activeCounterLabel;
		labels[INHIBITED_ALARM_COUNTER] = inhibitedCounterLabel;
		labels[MASKED_ALARM_COUNTER] = maskedCounterLabel;
		labels[HIGHLIGHTED_AND_KLAXON_ALARM_COUNTER] = null;
		labels[HIGHLIGHTED_ALARM_COUNTER] = null;
		labels[INSTANT_ALARM_COUNTER] = null;
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	private void initComponents() {//GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;

		alarmStatPanel = new javax.swing.JPanel();
		activeAlarmLabel = new javax.swing.JLabel();
		// pre creation activeCounterLabel

		activeCounterLabel = new javax.swing.JLabel();
		maskedAlarmLabel = new javax.swing.JLabel();
		maskedCounterLabel = new javax.swing.JLabel();
		inhibitedAlarmLabel = new javax.swing.JLabel();
		inhibitedCounterLabel = new javax.swing.JLabel();
		consoleInfoPanel = new javax.swing.JPanel();
		labelsPanel = new javax.swing.JPanel();
		configurationNameLabel = new javax.swing.JLabel();
		confNameValueLabel = new javax.swing.JLabel();
		distinguishNewAlarmLabel = new javax.swing.JLabel();
		distingiushAlarmValueLabel = new javax.swing.JLabel();
		autoTerminateLabel = new javax.swing.JLabel();
		autoTerminteValueLabel = new javax.swing.JLabel();
		reducedMaskedLabel = new javax.swing.JLabel();
		reducedMaskeValueLabel = new javax.swing.JLabel();
		iconPanel = new javax.swing.JPanel();
		networkIconLabel = new javax.swing.JLabel();

		setLayout(new java.awt.BorderLayout());

		alarmStatPanel.setLayout(new java.awt.GridBagLayout());

		alarmStatPanel.setBorder(new javax.swing.border.EtchedBorder());
		activeAlarmLabel.setText("Active alarms:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(6, 5, 2, 0);
		alarmStatPanel.add(activeAlarmLabel, gridBagConstraints);

		// pre init activeCounterLabel
		activeCounterLabel
				.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		activeCounterLabel.setText("      ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(6, 10, 2, 5);
		alarmStatPanel.add(activeCounterLabel, gridBagConstraints);

		maskedAlarmLabel.setText("Masked Alarms:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 5, 2, 0);
		alarmStatPanel.add(maskedAlarmLabel, gridBagConstraints);

		maskedCounterLabel
				.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		maskedCounterLabel.setText("      ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 5);
		alarmStatPanel.add(maskedCounterLabel, gridBagConstraints);

		inhibitedAlarmLabel.setText("Inhibited Alarms:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 5, 5, 0);
		alarmStatPanel.add(inhibitedAlarmLabel, gridBagConstraints);

		inhibitedCounterLabel
				.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		inhibitedCounterLabel.setText("      ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.insets = new java.awt.Insets(2, 10, 5, 5);
		alarmStatPanel.add(inhibitedCounterLabel, gridBagConstraints);

		add(alarmStatPanel, java.awt.BorderLayout.WEST);

		consoleInfoPanel.setLayout(new java.awt.BorderLayout());

		consoleInfoPanel.setBorder(new javax.swing.border.EtchedBorder());
		labelsPanel.setLayout(new java.awt.GridBagLayout());

		configurationNameLabel.setText("Currently used configuration: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 0, 3, 0);
		labelsPanel.add(configurationNameLabel, gridBagConstraints);

		confNameValueLabel.setForeground(new java.awt.Color(51, 51, 255));
		confNameValueLabel.setText("Configuration name");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 4, 3, 0);
		labelsPanel.add(confNameValueLabel, gridBagConstraints);

		distinguishNewAlarmLabel.setText("Distinguish new alarms: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 0, 3, 4);
		labelsPanel.add(distinguishNewAlarmLabel, gridBagConstraints);

		distingiushAlarmValueLabel.setText("YES");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(2, 4, 3, 0);
		labelsPanel.add(distingiushAlarmValueLabel, gridBagConstraints);

		autoTerminateLabel.setText("Auto Terminate: ");
		autoTerminateLabel.setToolTipText("");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(2, 14, 3, 4);
		labelsPanel.add(autoTerminateLabel, gridBagConstraints);

		autoTerminteValueLabel.setText("NO");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(2, 4, 3, 0);
		labelsPanel.add(autoTerminteValueLabel, gridBagConstraints);

		reducedMaskedLabel.setText("Reduced masked flag: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 4;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(2, 14, 3, 4);
		labelsPanel.add(reducedMaskedLabel, gridBagConstraints);

		reducedMaskeValueLabel.setText("YES");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 5;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(2, 0, 3, 4);
		labelsPanel.add(reducedMaskeValueLabel, gridBagConstraints);

		consoleInfoPanel.add(labelsPanel, java.awt.BorderLayout.CENTER);

		iconPanel.setLayout(new java.awt.GridBagLayout());

		networkIconLabel.setForeground(new java.awt.Color(51, 51, 255));
		networkIconLabel
				.setIcon(new javax.swing.ImageIcon(getClass().getResource(
						"/cern/laser/guiplatform/images/console-connected.png")));
		networkIconLabel.setText("Connection OK");
		networkIconLabel
				.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
		networkIconLabel
				.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
		iconPanel.add(networkIconLabel, gridBagConstraints);

		consoleInfoPanel.add(iconPanel, java.awt.BorderLayout.EAST);

		add(consoleInfoPanel, java.awt.BorderLayout.CENTER);

	}//GEN-END:initComponents

	/**
	 * @param configurationName
	 *            currently used configuration name
	 * @param behaviour,
	 *            which is displayed on this panel
	 * @param isReductionMaskeSet
	 */
	private void postInitComponents(String configurationName,
			Behaviour behaviour, boolean isReductionMaskeSet) {

		confNameValueLabel.setText(configurationName);
		if (configurationName != null
				&& (configurationName
						.equals(Constants.RECENTLY_APPLIED_CONFIGURATION) || configurationName
						.equals(Constants.DEFAULT_CONFIGURATION_NAME)))
			confNameValueLabel.setForeground(new java.awt.Color(255, 0, 0));
		else
			confNameValueLabel.setForeground(new java.awt.Color(51, 51, 255));

		distingiushAlarmValueLabel
				.setText(behaviour.isAlarmDistinguished() ? "YES" : "NO");

		autoTerminteValueLabel
				.setText(behaviour.isAlarmAutoTerminated() ? "YES" : "NO");

		reducedMaskeValueLabel.setText(isReductionMaskeSet ? "YES" : "NO");

	}

	public void updatePanel(String configurationName, Behaviour behaviour,
			boolean isReductionMaskeSet) {
		postInitComponents(configurationName, behaviour, isReductionMaskeSet);
	}

	//
	// -- AlarmsNumberChangeListener interface -----------------------
	//

	/**
	 * This method subtracts 1 from fromCounterType and adds 1 to toCounterType
	 * 
	 * @param fromCounterType
	 *            i. e. AlarmNumberChangeListener.ACTIVE_ALARM_COUNTER
	 * @param toCounterType
	 *            i. e. AlarmNumberChangeListener.ACTIVE_ALARM_COUNTER
	 */
	public/* synchronized */void moveAlarmNumber(final int fromCounterType,
			final int toCounterType) {
		if (fromCounterType > ALL_LIST_NUMBER
				|| toCounterType > ALL_LIST_NUMBER)
			throw new IllegalArgumentException("argument > "
					+ " AlarmNumberChangeListener.ALL_LIST_NUMBER");

		if (alarmNumbers[fromCounterType] > 0)
			alarmNumbers[fromCounterType]--;// -= 1;
		labels[fromCounterType].setText("" + alarmNumbers[fromCounterType]);

		alarmNumbers[toCounterType]++;
		labels[toCounterType].setText("" + alarmNumbers[toCounterType]);

	}

	/**
	 * This mehtod is used to update listener (i. e. when user wants to add this
	 * listener to AlarmContainer
	 * 
	 * @param counterType
	 *            (i. e. AlarmNumberChangeListener.ACTIVE_ALARM_COUNTER)
	 * @param alarmNo
	 *            new alarm number
	 */
	public/* synchronized */void update(final int counterType, final long alarmNo) {
		try {
			throw new Exception();
		} catch (Exception ex) {
			logger.debug("Counter updated, type=" + counterType + " number="
					+ alarmNo);
			StackTraceElement[] stack = ex.getStackTrace();
			for (int i = 0; i < stack.length; i++) {
				logger.debug("stack: " + stack[i]);
			}
		}
		switch (counterType) {
		case AlarmsNumberChangeListener.ACTIVE_ALARM_COUNTER:
			//activeAlarmNo = alarmNo;
			alarmNumbers[ACTIVE_ALARM_COUNTER] = alarmNo;
			activeCounterLabel.setText("" + alarmNumbers[ACTIVE_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.INHIBITED_ALARM_COUNTER:
			//inhibitedAlarmNo = alarmNo;
			alarmNumbers[INHIBITED_ALARM_COUNTER] = alarmNo;
			inhibitedCounterLabel.setText(""
					+ alarmNumbers[INHIBITED_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.MASKED_ALARM_COUNTER:
			//maskedAlarmNo = alarmNo;
			alarmNumbers[MASKED_ALARM_COUNTER] = alarmNo;
			maskedCounterLabel.setText("" + alarmNumbers[MASKED_ALARM_COUNTER]);
			break;

		// other counters not implemented bacouse it was not needed
		// so fat

		default:
			// do nothig, or maybe throw exception
			throw new IllegalArgumentException("Valid argument is only from"
					+ " AlarmNumberChangeListener interface");
		}
	}

	/**
	 * This method add 1 to counterType
	 * 
	 * @param counterType
	 *            (i. e. AlarmNumberChangeListener.ACTIVE_ALARM_COUNTER)
	 */
	public/* synchronized */void increaseCounter(final int counterType) {
		switch (counterType) {
		case AlarmsNumberChangeListener.ACTIVE_ALARM_COUNTER:
			//activeAlarmNo++;
			alarmNumbers[ACTIVE_ALARM_COUNTER] += 1;
			activeCounterLabel.setText("" + alarmNumbers[ACTIVE_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.INHIBITED_ALARM_COUNTER:
			//inhibitedAlarmNo++;
			alarmNumbers[INHIBITED_ALARM_COUNTER] += 1;
			inhibitedCounterLabel.setText(""
					+ alarmNumbers[INHIBITED_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.MASKED_ALARM_COUNTER:
			//maskedAlarmNo++;
			alarmNumbers[MASKED_ALARM_COUNTER] += 1;
			maskedCounterLabel.setText("" + alarmNumbers[MASKED_ALARM_COUNTER]);
			break;

		// other counters not implemented bacouse it was not needed
		// so far

		default:
			// do nothig, or maybe throw exception
			throw new IllegalArgumentException("Valid argument is only from"
					+ " AlarmNumberChangeListener interface");
		}
	}

	/**
	 * This method substracts 1 from counterType
	 * 
	 * @param counterType
	 *            (i. e. AlarmNumberChangeListener.ACTIVE_ALARM_COUNTER)
	 */
	public/* synchronized */void decreaseCounter(final int counterType) {
		switch (counterType) {
		case AlarmsNumberChangeListener.ACTIVE_ALARM_COUNTER:
			//activeAlarmNo++;
			if (alarmNumbers[ACTIVE_ALARM_COUNTER] > 0)
				alarmNumbers[ACTIVE_ALARM_COUNTER] -= 1;
			activeCounterLabel.setText("" + alarmNumbers[ACTIVE_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.INHIBITED_ALARM_COUNTER:
			//inhibitedAlarmNo++;
			if (alarmNumbers[INHIBITED_ALARM_COUNTER] > 0)
				alarmNumbers[INHIBITED_ALARM_COUNTER] -= 1;
			inhibitedCounterLabel.setText(""
					+ alarmNumbers[INHIBITED_ALARM_COUNTER]);
			break;
		case AlarmsNumberChangeListener.MASKED_ALARM_COUNTER:
			//maskedAlarmNo++;
			if (alarmNumbers[MASKED_ALARM_COUNTER] > 0)
				alarmNumbers[MASKED_ALARM_COUNTER] -= 1;
			maskedCounterLabel.setText("" + alarmNumbers[MASKED_ALARM_COUNTER]);
			break;

		// other counters not implemented bacouse it was not needed
		// so far

		default:
			// do nothig, or maybe throw exception
			throw new IllegalArgumentException("Valid argument is only from"
					+ " AlarmNumberChangeListener interface");
		}
	}

	/** */
	public void onException(java.lang.String exceptionCode) {

		logger.debug("onException(" + exceptionCode + ")");

		if (exceptionCode.equals(LaserSelectionException.CONNECTION_DROPPED)) {

			networkIconLabel.setForeground(new java.awt.Color(255, 0, 0));
			networkIconLabel
					.setIcon(new javax.swing.ImageIcon(
							getClass()
									.getResource(
											"/cern/laser/guiplatform/images/console-disconnected.png")));
			networkIconLabel.setText(CONNECTION_NOT_OK + " "
					+ DateTimeUtils.getCurrentTimestamp());

			// this can't be modal window, this window can't wait for
			// button
			//NotifyDescriptor.Message message = new NotifyDescriptor.Message(
			//                        "Connection unavailable.",
			//                        NotifyDescriptor.ERROR_MESSAGE);
			//DialogDisplayer.getDefault().notify(message);

		} else {
			if (exceptionCode
					.equals("HEARTBEAT_LOST")) { // TODO: add to bundles file

				networkIconLabel.setForeground(new java.awt.Color(255, 0, 0));
				networkIconLabel
						.setIcon(new javax.swing.ImageIcon(
								getClass()
										.getResource(
												"/cern/laser/guiplatform/images/console-disconnected.png")));
				networkIconLabel.setText(CONNECTION_NOT_OK_HB + " "
						+ DateTimeUtils.getCurrentTimestamp());

			} else {// CONNECTION_ESTABLISHED
				try {

					// update info panel
					networkIconLabel.setForeground(new java.awt.Color(51, 51,
							255));
					networkIconLabel
							.setIcon(new javax.swing.ImageIcon(
									getClass()
											.getResource(
													"/cern/laser/guiplatform/images/console-connected.png")));
					networkIconLabel.setText(CONNECTION_OK);

					// reload container

					// disconnet from bussiens tier
					AlarmSelectionHandler jms_selectionHandler = null;
					jms_selectionHandler = AlarmSelectionHandlerFactory
							.getHandler();
					jms_selectionHandler.resetSelection();

					// disable ProxyBuffer
					ProxyBuffer.getDefault().disable();

					// claen node managers and lists
					// immediately after diconnection for BL
					AlarmContainer.getDefault().clearNodeManagers();

					Selection selection = AppRegister.getInstance()
							.getSelection();
					Configuration confTemp = AppRegister.getInstance()
							.getLoadedConfiguration();

					// make new selection
					java.util.Map activeAlarms = jms_selectionHandler.select(
							selection, ProxyBuffer.getDefault());

					// reload Alarm container
					AlarmContainer.getDefault().reloadContainer(activeAlarms,
							confTemp);

					// enable ProxyBuffer
					ProxyBuffer.getDefault().enable();

					// this can't be modal window, this window can't wait for
					// button
					//NotifyDescriptor.Message message = new
					// NotifyDescriptor.Message(
					//                        "Connection established.",
					//                        NotifyDescriptor.INFORMATION_MESSAGE);
					//DialogDisplayer.getDefault().notify(message);

				} catch (LaserException le) {
					logger.error(le, le.fillInStackTrace());
					logger.error(le.getRootCause(), le.getRootCause()
							.fillInStackTrace());

					NotifyDescriptor.Message message = new NotifyDescriptor.Message(
							"Connection error. Unable to select new fault states.\n"
									+ "Please, logout and try to login again later",
							NotifyDescriptor.ERROR_MESSAGE);
					DialogDisplayer.getDefault().notify(message);

					// write that inforamtion somewhere on the console

					return;

				}
			}
		}
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel activeAlarmLabel;

	private javax.swing.JLabel activeCounterLabel;

	private javax.swing.JPanel alarmStatPanel;

	private javax.swing.JLabel autoTerminateLabel;

	private javax.swing.JLabel autoTerminteValueLabel;

	private javax.swing.JLabel confNameValueLabel;

	private javax.swing.JLabel configurationNameLabel;

	private javax.swing.JPanel consoleInfoPanel;

	private javax.swing.JLabel distingiushAlarmValueLabel;

	private javax.swing.JLabel distinguishNewAlarmLabel;

	private javax.swing.JPanel iconPanel;

	private javax.swing.JLabel inhibitedAlarmLabel;

	private javax.swing.JLabel inhibitedCounterLabel;

	private javax.swing.JPanel labelsPanel;

	private javax.swing.JLabel maskedAlarmLabel;

	private javax.swing.JLabel maskedCounterLabel;

	private javax.swing.JLabel networkIconLabel;

	private javax.swing.JLabel reducedMaskeValueLabel;

	private javax.swing.JLabel reducedMaskedLabel;

	// End of variables declaration//GEN-END:variables

	// matrix wiht alarm numbers (used for removing from one and add to other)
	private long[] alarmNumbers = null;//{0, 0, 0, 0, 0, 0};

	private static final String CONNECTION_OK = "Connection OK";

	private static final String CONNECTION_NOT_OK = "Connection unavailable";
	
	private static final String CONNECTION_NOT_OK_HB = "No heartbeat";

	/** behaviour which is displayed on this panel */
	//private Behaviour behaviour = null;

	/** */
	private javax.swing.JLabel [] labels = null;

	/** logger */
	private static Logger logger = LogFactory
			.getLogger(AlarmStatisticInfoPanel.class.getName());

}