/************************************************
 * [ Java Essence ]                             *
 * [HOME: http://os2.walkabout.org/java/]       *
 * [EMAIL: junk@bbs.darktech.org]               *
 *                                              *
 * AUTHOR: Gili Tzabari                         *
 * PLATFORMS: OS/2, eCS                         *
 *            IBM JDK 1.3.x, Sun JDK 1.4.1      *
 *                                              *
 * Used to run NetBeans 3.4+                    *
 ************************************************/


/** BEGINNING OF CONFIGURATION BLOCK **********************************/
/*                                                                    */
/* To override the default value, replace with USER_DIR="<path>"      */

USER_DIR=noslash(value("HOME",,"OS2ENVIRONMENT")) || "\netbeans"

/*                                                                    */
/** END OF CONFIGURATION BLOCK ****************************************/

/*************************************************************************************************
 ** NOTE: To insure the IDE can be updated without losing user files, do not point USER_DIR to   *
 **       same directory as netbeans                                                             *
 *************************************************************************************************/

CALL RXFUNCADD "SysLoadFuncs", "RexxUtil", "sysloadfuncs";
CALL SysLoadFuncs;

if (USER_DIR="" | GetLowerCase(USER_DIR)\=USER_DIR) then
do
  say "WARNING: Netbeans must be placed inside a lowercase path (i.e. \netbeans, "
  say "         as opposed to \NETBEANS) or it might refuse to run with "
  say "         'AccessControlException: access denied'."
  say "         See http://www.netbeans.org/issues/show_bug.cgi?id=20025 for more"
  say "         information."
  if (USER_DIR="") then
  do  
    say
    say "         To avoid seeing this message again, edit runideos2.cmd and customize"
    say "         your USER_DIR"
    exit
  end
end
USER_DIR=AddSlash(USER_DIR)

IDE_HOME=ParentDir(GetExecPath())

USER_DIR=GetLowerCase(USER_DIR) /* workaround for Java CodeSource bug */
IDE_HOME=GetLowerCase(IDE_HOME) /* workaround for Java CodeSource bug */

if SYMBOL('JAVA_PATH') = 'LIT' then         /* If JAVA_PATH is undefined */
  JAVA_PATH=ParentDir(which("java.exe"), 2)
rc = GetJavaVersion(JAVA_PATH'JRE\BIN\')
if (rc = -1) then
do
  say "JAVA.EXE cannot be found."
  return -1
end
if (rc = -2) then
  say "Unexpected response to JAVA -VERSION. Assuming newest version is being used."
else
  if (rc < 130) then
  do
    say "JDK 1.3 is required for running Netbeans however JDK "rc/100" was detected instead."
    say "Quitting..."
    exit
  end

if (Exist(IDE_HOME'lib\core.jar')=0) then signal NO_IDE

TOP:
OLD_CLASSPATH = value("CLASSPATH",,"OS2ENVIRONMENT")
CLASSPATH=""

CLASSPATH = CLASSPATH || GetPathString(IDE_HOME"lib\ext\*.jar")
CLASSPATH = CLASSPATH || GetPathString(IDE_HOME"lib\ext\*.zip")
CLASSPATH = CLASSPATH || GetPathString(IDE_HOME"lib\ext\locale\*.jar")
CLASSPATH = CLASSPATH || GetPathString(IDE_HOME"lib\ext\locale\*.zip")

CLASSPATH = CLASSPATH || JAVA_PATH"lib\tools.jar;"
CLASSPATH = CLASSPATH || value("CLASSPATH",,"OS2ENVIRONMENT")
call value "CLASSPATH", CLASSPATH, "OS2ENVIRONMENT"

if (Exist(IDE_HOME"update\download\install_later.xml")=1 & Length(GetPathString(IDE_HOME"update\download\*.nbm"))>0) then
  signal APPLY_PATCH
if (Exist(USER_DIR"update\download\install_later.xml")=1 & Length(GetPathString(USER_DIR"update\download\*.nbm"))>0) then
  signal APPLY_PATCH

ARGUMENTS = "-Djava.security.policy="IDE_HOME"bin\ide.policy -Dnetbeans.home="noslash(IDE_HOME)" -Dnetbeans.user="noslash(USER_DIR)" -Dsun.net.inetaddr.ttl=1 -Xverify:none -Xms24m -Xmx96m"
call value "JAVA_HIGH_MEMORY", "1", "OS2ENVIRONMENT"

say "Running Netbeans..."

JAVA_PATH"jre\bin\javaw "ARGUMENTS" org.netbeans.Main"
if (rc \= 0) then do
 say 'Netbeans failed with rc='rc
 'pause'
end

if (Exist(IDE_HOME"update\download\install_later.xml")=0 & Length(GetPathString(IDE_HOME"update\download\*.nbm"))>0) then
  signal APPLY_PATCH
if (Exist(USER_DIR"update\download\install_later.xml")=0 & Length(GetPathString(USER_DIR"update\download\*.nbm"))>0) then
  signal APPLY_PATCH

call value "CLASSPATH", OLD_CLASSPATH, "OS2ENVIRONMENT"
say "Exiting normally..."
signal END

APPLY_PATCH:
say "Applying Patch..."

CLASSPATH = CLASSPATH || IDE_HOME"lib\updater.jar"
call value "CLASSPATH", CLASSPATH, "OS2ENVIRONMENT"

JAVA_PATH"jre\bin\java -Djava.security.policy="IDE_HOME"bin\ide.policy -Dnetbeans.home="IDE_HOME" -Dnetbeans.user="USER_DIR" -Xmx96m org.netbeans.updater.UpdaterFrame"

if (rc \= 0) then do
 say 'Updater failed with rc='rc
 'pause'
end

call value "CLASSPATH", OLD_CLASSPATH, "OS2ENVIRONMENT"
signal TOP

NO_IDE:
say "Error: IDE_HOME detected as "IDE_HOME" which is incorrect. Please contact the author."
signal END

END:
exit




/*
 * Removes blackslash off directory name and returns the result.
 */
NoSlash: procedure

parse arg directory
directory=strip(directory, 't', '\')
return directory




/*
 * Removes blackslash off directory name and returns the result.
 */
AddSlash: procedure

parse arg directory
if (substr(directory, length(directory)-1, length(directory)) \= "\") then
  return directory"\"





/*
 * Returns the parent directory of the specified directory.
 * TIMES - the number of times to repeat operation. TIMES=2 is equivilent to ParentDir(ParentDir())
 */
ParentDir: procedure

parse arg directory, levels
if levels = '' then
  levels = 1
if levels = 0 then
  return directory
directory=FILESPEC("drive", directory) || FILESPEC("path", directory)
directory=noslash(directory)

if (lastpos("..", directory)=(length(directory)-1)) then 
do
  directory=directory'\..\' /* append to relative paths */
  return directory
end

pos = lastpos('\', directory) /* remove deepest directory, if possible */
if (pos = 0) then
  return "..\"
directory = substr(directory, 1, pos)
return ParentDir(directory, levels-1)




/*
 * Returns the current script name.
 */
GetExecPath: procedure

parse source result
return word(result, 3)





/*
 * Searchs path for first match of specified program and returns its full path.
 */
Which: procedure

parse arg name
CALL RXFUNCADD "SysLoadFuncs", "RexxUtil", "sysloadfuncs";
CALL SysLoadFuncs;
return SysSearchPath('PATH', name);




/*
 * Returns true if file exists
 */
Exist: procedure

parse arg filename
call SysFileTree filename, result
return result.0 > 0




/*
 * Returns PATH-style string containing all files matching the specified filespec
 */
GetPathString: procedure

parse arg filespec
call SysFileTree filespec, filelist, 'FO'
result=""
do i=1 to filelist.0
  result=result || filelist.i || ";"
end
return result






/*
 * Returns lowercase version of the String
 */
GetLowerCase: procedure

parse arg STRING
return Translate(STRING, "qwertyuiopasdfghjklzxcvbnm", "QWERTYUIOPASDFGHJKLZXCVBNM")





/*
 * Java version detector.
 * Assumes java -version return quoted ("") version number.
 * Written by os2bird on #netlabs
 *
 * Returns -1 on no java or failed to execute
 *         -2 on invalid java version string.
 *         version number.
 */
GetJavaVersion: procedure

parse arg java_path
cQueued = queued();

'@echo off'
if (java_path='') then
  if (which("java.exe")='') then
    return -1
  else NOP
else
  if (exist(java_path'java.exe')=0) then
    return -1

java_path'java -version 2>&1 | rxqueue /LIFO'
i = queued();
do while i > cQueued
  pull sStr
  if (pos("JAVA VERSION ", sStr) > 0) | (pos("JAVA.EXE VERSION ", sStr) > 0) then
  do
    do while(queued() > 0) 
      pull sStrIngore; /* flush input stream */
    end
    parse var sStr sStuff '"'iMajor'.'iMid'.'iMinor'_'iBuild'"'
    if (iBuild='') then
      parse var sStr sStuff '"'iMajor'.'iMid'.'iMinor'"' /* iBuild does not exist */
    if (iMinor \= '') then
      return iMajor*100 + iMid * 10 + iMinor;
    else
      return -2
    end
    i = i - 1;
  end
return -1;
