/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.util;

/**
 * A utility class determinig the runtime version current JRE
 *
 * @author Richard G Clark
 */
public final class JREVersion 
{    
    /**
     * Indicates that the current JRE is at least 1.4
     */
    public static final boolean V1_4;
    
    static 
    {
        final Class[] parameterTypes = {Throwable.class};
        boolean is1_4 = false;
        try 
        {
            Throwable.class.getMethod( "initCause", parameterTypes );
            is1_4 = true;
        } 
        catch ( final NoSuchMethodException e )
        {
            // now we know that this is a JDK older than 1.4
        }

        V1_4 = is1_4;
    }
    
    private JREVersion()
    {
    }
}

