/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.object;

import org.openorb.compiler.parser.*;

/**
 * Cette classe represente l'objet IDL Simple
 *
 * @author Jerome Daniel
 * @version $Revision: 1.5 $ $Date: 2002/08/21 08:19:22 $ 
 */

public class IdlSimple extends IdlObject implements org.openorb.compiler.idl.reflect.idlPrimitive
{
    /**
     * Identifiant du type simple
     */
    private int kind;

    /**
     * Le type simple void
     */
    public static IdlSimple void_type = new IdlSimple( Token.t_void );

    /**
     * Le type simple boolean
     */
    public static IdlSimple boolean_type = new IdlSimple( Token.t_boolean );

    /**
     * Le type simple float
     */
    public static IdlSimple float_type = new IdlSimple( Token.t_float );

    /**
     * Le type simple double
     */
    public static IdlSimple double_type = new IdlSimple( Token.t_double );

    /**
     * Le type simple longdouble
     */
    public static IdlSimple longdouble_type = new IdlSimple( Token.t_longdouble );

    /**
     * Le type simple short
     */
    public static IdlSimple short_type = new IdlSimple( Token.t_short );

    /**
     * Le type simple unsigned short
     */
    public static IdlSimple ushort_type = new IdlSimple( Token.t_ushort );

    /**
     * Le type simple long
     */
    public static IdlSimple long_type = new IdlSimple( Token.t_long );

    /**
     * Le type simple unsigned long 
     */
    public static IdlSimple ulong_type = new IdlSimple( Token.t_ulong );

    /**
     * Le type simple long long
     */
    public static IdlSimple longlong_type = new IdlSimple( Token.t_longlong );

    /**
     * Le type simple unsigned long long
     */
    public static IdlSimple ulonglong_type = new IdlSimple( Token.t_ulonglong );

    /**
     * Le type simple char
     */
    public static IdlSimple char_type = new IdlSimple( Token.t_char );

    /**
     * Le type simple wchar
     */
    public static IdlSimple wchar_type = new IdlSimple( Token.t_wchar );

    /**
     * Le type simple octet
     */
    public static IdlSimple octet_type = new IdlSimple( Token.t_octet );

    /**
     * Le type simple Object
     */
    public static IdlSimple object_type = new IdlSimple( Token.t_object );

    /**
     * Le type simple Any
     */
    public static IdlSimple any_type = new IdlSimple( Token.t_any );

    /**
     * Le type simple TypeCode
     */
    public static IdlSimple typecode_type = new IdlSimple( Token.t_typecode );

    /**
     * Le type simple ValueBase
     */
    public static IdlSimple valuebase_type = new IdlSimple( Token.t_ValueBase );

    /**
    * Cree un objet IDL Simple
    */
    public IdlSimple( int t )
    {
        super( IdlType.e_simple, null );
        kind = t;
    }

    /**
    * Retourne le type interne d'un type simple
    *
    * @return le type interne
    */
    public int internal()
    {
        return kind;
    }

    /**
    * Change prefix to my self but also to all contained objects
    */
    public void changePrefix( String prefix )
    {}

    // ------------------------------------------------------------------------------------------
    // IDL Reflection
    // ------------------------------------------------------------------------------------------



    public int primitive()
    {
        switch ( kind )
        {

        case Token.t_void :
            return VOID;

        case Token.t_boolean :
            return BOOLEAN;

        case Token.t_float :
            return FLOAT;

        case Token.t_double :
            return DOUBLE;

        case Token.t_longdouble :
            return LONGDOUBLE;

        case Token.t_short :
            return SHORT;

        case Token.t_ushort :
            return USHORT;

        case Token.t_long :
            return LONG;

        case Token.t_ulong :
            return ULONG;

        case Token.t_longlong :
            return LONGLONG;

        case Token.t_ulonglong :
            return ULONGLONG;

        case Token.t_char :
            return CHAR;

        case Token.t_wchar :
            return WCHAR;

        case Token.t_octet :
            return OCTET;

        case Token.t_object :
            return OBJECT;

        case Token.t_any :
            return ANY;

        case Token.t_typecode :
            return TYPECODE;

        case Token.t_ValueBase :
            return VALUEBASE;

        default :
            return -1;
        }
    }
}



