/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.omg.CORBA;

/**
 * This class describes available operations for BOA.
 *
 * @author Jerome Daniel
 */
abstract public class BOA
{
    /**
     * Initialize BOA
     */
    public static org.omg.CORBA.BOA init( org.omg.CORBA.ORB orb, java.lang.String [] args )
    {
        BOA boa = ( org.omg.CORBA.BOA ) 
            ( ( org.openorb.CORBA.ORB ) orb ).getFeature( "BOA" );

        if( boa == null )
            throw new org.omg.CORBA.INITIALIZE( 
                "The BOA has not been initialized properly!" );

        return boa;
    }

    /**
     * Connect an object to the BOA
     */
    abstract public void connect( org.omg.CORBA.portable.ObjectImpl obj );

    /**
     * Connect and object and provide its key
     */
    abstract public void connect( org.omg.CORBA.portable.ObjectImpl obj, String name );


    /**
     * This operation is used to forward an object.
     */
    abstract public void forward( org.omg.CORBA.portable.ObjectImpl objOld, org.omg.CORBA.portable.ObjectImpl objNew );

    /**
     * Disconnect an object.
     */
    abstract public void disconnect ( org.omg.CORBA.portable.ObjectImpl obj );

    /**
     * Run the BOA ( this operation never returns ).
     */
    abstract public void impl_is_ready();

    /**
     * Activate an object.
     */
    abstract public void obj_is_ready( org.omg.CORBA.portable.ObjectImpl obj );

    /**
     * Deactivate an object
     */
    abstract public void deactivate_obj( org.omg.CORBA.portable.ObjectImpl obj );

    /**
     * Stop the BOA
     */
    abstract public void deactivate_impl();
}
