/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.timer;

import ahc.collection.Cache;
import ahc.util.timer.LongStopWatchCycle;
import ahc.util.timer.StopWatchCycle;
import ahc.util.timer.StopWatchEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StopWatch {
    private final String _name;
    private boolean _running = false;
    private long _startTime;
    private long _stopTime;
    private final List _events = new ArrayList();
    private final NumberFormat _format = NumberFormat.getNumberInstance();
    private final boolean _arbitratyPrecisionCycles;
    private final Cache _cycleCache = new Cache(){

        protected Object createNew(Object key) {
            return StopWatchCycle.create((String)key, StopWatch.this._format, StopWatch.this._arbitratyPrecisionCycles);
        }
    };

    public StopWatch(String name, boolean arbitraryPrecisionCycles) {
        this._name = name;
        this._arbitratyPrecisionCycles = arbitraryPrecisionCycles;
        this.start();
    }

    public StopWatch(String name) {
        this(name, false);
    }

    private void start() {
        this._running = true;
        this._startTime = System.currentTimeMillis();
    }

    public long current() {
        if (this._running) {
            return System.currentTimeMillis() - this._startTime;
        }
        return this._stopTime - this._startTime;
    }

    public void stop() {
        this._running = false;
        this._stopTime = System.currentTimeMillis();
    }

    public void remember(String event) {
        if (!this._running) {
            throw new IllegalStateException("Stop watch must be running to remember an event");
        }
        this._events.add(new StopWatchEvent(event, this.current()));
    }

    public void beginCycle(String name) {
        ((StopWatchCycle)this._cycleCache.get(name)).begin();
    }

    public void endCycle(String name) {
        ((StopWatchCycle)this._cycleCache.get(name)).end();
    }

    public List getEvents() {
        return this._events;
    }

    public boolean isRunning() {
        return this._running;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        StringBuffer events = new StringBuffer();
        long timePrevEvent = 0L;
        Iterator iter = this._events.iterator();
        while (iter.hasNext()) {
            StopWatchEvent curEvent = (StopWatchEvent)iter.next();
            events.append("  " + curEvent.getName() + ": " + this._format.format(curEvent.getTime()) + "ms (" + this._format.format(curEvent.getTime() - timePrevEvent) + "ms)\n");
            timePrevEvent = curEvent.getTime();
        }
        iter = this._cycleCache.getKeys().iterator();
        while (iter.hasNext()) {
            LongStopWatchCycle curCycle = (LongStopWatchCycle)this._cycleCache.get(iter.next());
            events.append("  " + curCycle.toString() + "\n");
        }
        return "Stopwatch \"" + this._name + "\"\n" + events.toString() + "Total: " + this._format.format(this.current()) + "ms";
    }
}

