/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string.sprintf;

import ahc.util.string.sprintf.NumberHandler;

public class IntHandler
extends NumberHandler {
    private final int _maxNumDigits;

    public IntHandler() {
        this._maxNumDigits = -1;
    }

    public IntHandler(boolean hasThousandsSeparator, int maxNumDigits, boolean hasPositiveSign, boolean hasSpaceSign) {
        super(hasThousandsSeparator, 0, hasPositiveSign, hasSpaceSign);
        this._maxNumDigits = maxNumDigits;
    }

    public String handle(Object o) {
        if (this._nf == null) {
            return super.handle(o);
        }
        if (o == null) {
            return "" + o;
        }
        long num = ((Number)o).longValue();
        if (this._maxNumDigits > 0) {
            num %= this.pow10(this._maxNumDigits);
        }
        return super.handle(new Long(num));
    }

    public long pow10(int exp) {
        switch (exp) {
            case 0: {
                return 1L;
            }
            case 1: {
                return 10L;
            }
            case 2: {
                return 100L;
            }
            case 3: {
                return 1000L;
            }
            case 4: {
                return 10000L;
            }
            case 5: {
                return 100000L;
            }
            case 6: {
                return 1000000L;
            }
            case 7: {
                return 10000000L;
            }
            case 8: {
                return 100000000L;
            }
            case 9: {
                return 1000000000L;
            }
            case 10: {
                return 10000000000L;
            }
            case 11: {
                return 100000000000L;
            }
            case 12: {
                return 1000000000000L;
            }
            case 13: {
                return 10000000000000L;
            }
            case 14: {
                return 100000000000000L;
            }
            case 15: {
                return 1000000000000000L;
            }
            case 16: {
                return 10000000000000000L;
            }
            case 17: {
                return 100000000000000000L;
            }
            case 18: {
                return 1000000000000000000L;
            }
        }
        throw new IllegalArgumentException("invalid exponent: " + exp);
    }
}

