/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class AttribIterator {
    protected final boolean _filterStatic;
    protected final boolean _filterTransient;
    protected final boolean _alwaysUseToStringImpl;
    protected final boolean _collectionsAsPrimitives;
    protected final boolean _javaLangAsPrimitives;
    private final Map _cycles = new HashMap();
    private int _nextCycleNo = 1;
    private static final Object _firstOccurrence = new Object(){

        public String toString() {
            return "<once>";
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public AttribIterator(boolean filterStatic, boolean filterTransient, boolean alwaysUseToStringImpl, boolean collectionsAsPrimitives, boolean javaLangAsPrimitives) {
        this._filterStatic = filterStatic;
        this._filterTransient = filterTransient;
        this._alwaysUseToStringImpl = alwaysUseToStringImpl;
        this._collectionsAsPrimitives = collectionsAsPrimitives;
        this._javaLangAsPrimitives = javaLangAsPrimitives;
    }

    protected abstract void handlePre(Object var1);

    protected abstract void handlePreCollection(Object var1);

    protected abstract void handlePost(Object var1);

    protected abstract void handlePostCollection(Object var1);

    protected abstract void handleNode(Object var1);

    protected abstract void handleEnumSeparator();

    protected abstract void handleMapArrow();

    protected abstract void handleField(Field var1);

    protected abstract void handleCycleDef(Object var1);

    protected abstract void handleCycleRef(Object var1);

    protected abstract void handleObject(Object var1);

    public void handleGeneric(Object o, int maxDepth) {
        this.handleGeneric(o, false, maxDepth);
    }

    protected Object createKey(Object obj) {
        return new Integer(System.identityHashCode(obj));
    }

    void handleGeneric(Object o, boolean isPrimitive, int maxDepth) {
        this.handleObject(o);
        if (o == null || isPrimitive || maxDepth <= 0) {
            this.handleAsPrimitive(o);
            return;
        }
        Object key = this.createKey(o);
        Object oldValue = this._cycles.get(key);
        if (oldValue == null) {
            this._cycles.put(key, _firstOccurrence);
        } else if (oldValue == _firstOccurrence) {
            this._cycles.put(key, new Integer(this._nextCycleNo++));
        }
        if (this.isCycle(o)) {
            this.handleCycleRef(o);
            return;
        }
        this.handleCycleDef(o);
        if (o.getClass().isArray()) {
            this.handleArray(o, maxDepth);
        } else if (o instanceof Collection && this._collectionsAsPrimitives) {
            this.handleCollection((Collection)o, maxDepth);
        } else if (o instanceof Map && this._collectionsAsPrimitives) {
            this.handleMap((Map)o, maxDepth);
        } else if (this._javaLangAsPrimitives && (class$java$lang$String == null ? (class$java$lang$String = AttribIterator.class$("java.lang.String")) : class$java$lang$String).getPackage().equals(o.getClass().getPackage())) {
            this.handleAsPrimitive(o);
        } else if (this._alwaysUseToStringImpl && this.hasOwnToString(o.getClass())) {
            this.handleAsPrimitive(o);
        } else {
            this.handlePre(o);
            Field[] fields = this.getFields(o.getClass()).toArray(new Field[0]);
            for (int i = 0; i < fields.length; ++i) {
                if (i > 0) {
                    this.handleEnumSeparator();
                }
                try {
                    fields[i].setAccessible(true);
                    this.handleField(fields[i]);
                    Object curValue = fields[i].get(o);
                    this.handleGeneric(curValue, fields[i].getType().isPrimitive(), maxDepth - 1);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("illegal access for field " + fields[i]);
                }
            }
            this.handlePost(o);
        }
    }

    private void handleArray(Object o, int maxDepth) {
        this.handlePreCollection(o);
        boolean isPrimitive = o.getClass().getComponentType().isPrimitive();
        int len = Array.getLength(o);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.handleEnumSeparator();
            }
            Object element = Array.get(o, i);
            this.handleGeneric(element, isPrimitive, maxDepth);
        }
        this.handlePostCollection(o);
    }

    private void handleCollection(Collection coll, int maxDepth) {
        this.handlePreCollection(coll);
        boolean first = true;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (!first) {
                this.handleEnumSeparator();
            }
            first = false;
            this.handleGeneric(iter.next(), false, maxDepth);
        }
        this.handlePostCollection(coll);
    }

    private void handleMap(Map map, int maxDepth) {
        this.handlePreCollection(map);
        boolean first = true;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            if (!first) {
                this.handleEnumSeparator();
            }
            first = false;
            Object key = iter.next();
            this.handleGeneric(key, false, maxDepth);
            this.handleMapArrow();
            this.handleGeneric(map.get(key), false, maxDepth);
        }
        this.handlePostCollection(map);
    }

    private void handleAsPrimitive(Object o) {
        if (o == null) {
            this.handleNode(null);
        } else if (o.getClass().isArray()) {
            this.handleArray(o, 0);
        } else if (o instanceof Collection) {
            this.handleCollection((Collection)o, 0);
        } else if (o instanceof Map) {
            this.handleMap((Map)o, 0);
        } else {
            this.handleNode(o);
        }
    }

    private boolean hasOwnToString(Class cls) {
        try {
            Method mtdToString = cls.getMethod("toString", null);
            return mtdToString.getDeclaringClass().equals(cls);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private List getFields(Class cls) {
        ArrayList<Field> result = new ArrayList<Field>();
        if ((class$java$lang$Object == null ? (class$java$lang$Object = AttribIterator.class$("java.lang.Object")) : class$java$lang$Object).equals(cls)) {
            return result;
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int curModifiers = fields[i].getModifiers();
            if (this._filterStatic && Modifier.isStatic(curModifiers) || this._filterTransient && Modifier.isTransient(curModifiers)) continue;
            result.add(fields[i]);
        }
        result.addAll(this.getFields(cls.getSuperclass()));
        return result;
    }

    protected boolean isCycle(Object obj) {
        return this.getCycleNo(obj) != null && this.getCycleNo(obj) != _firstOccurrence;
    }

    protected Object getCycleNo(Object obj) {
        return this._cycles.get(this.createKey(obj));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

