/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.bytes;

import ahc.util.bytes.BitManipulator;
import ahc.util.bytes.ByteArrayHelper;

public abstract class StringEndEncoding {
    public static final StringEndEncoding END_NONE = new StringEndEncoding(){

        public byte[] addLenEncoding(byte[] raw) {
            return raw;
        }
    };
    public static final StringEndEncoding END_NULL = new StringEndEncoding(){

        public byte[] addLenEncoding(byte[] raw) {
            byte[] result = new byte[raw.length + 1];
            ByteArrayHelper.copy(raw, result, 0);
            result[raw.length] = 0;
            return result;
        }
    };
    public static final StringEndEncoding END_LEN_PREFIX_16_HILO = new StringEndEncoding(){

        public byte[] addLenEncoding(byte[] raw) {
            byte[] result = new byte[raw.length + 2];
            ByteArrayHelper.copy(raw, result, 2);
            result[0] = BitManipulator.MIDLO(raw.length);
            result[1] = BitManipulator.LO(raw.length);
            return result;
        }
    };

    public abstract byte[] addLenEncoding(byte[] var1);
}

