/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.bytes;

import ahc.util.bytes.StringEndEncoding;
import java.io.UnsupportedEncodingException;

public class StringEncoder {
    public static byte[] getBytes(String str, String encoding, StringEndEncoding end) throws UnsupportedEncodingException {
        byte[] resultRaw = str.getBytes(encoding);
        return end.addLenEncoding(resultRaw);
    }

    public static byte[] getBytesSafe(String str, String encoding, StringEndEncoding end) {
        try {
            return StringEncoder.getBytes(str, encoding, end);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Encoding '" + encoding + "' not supported.");
        }
    }

    public static byte[] getBytesUtf8(String str, StringEndEncoding end) {
        return StringEncoder.getBytesSafe(str, "UTF-8", end);
    }

    public static byte[] getBytesIso8859_1(String str, StringEndEncoding end) {
        return StringEncoder.getBytesSafe(str, "iso-8859-1", end);
    }
}

