/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic.classloader;

import ahc.generic.classloader.ConstantPool;
import ahc.generic.classloader.DefaultConstructorMethod;
import ahc.generic.classloader.MethodForClassFile;
import ahc.generic.classloader.SetterClassData;
import ahc.util.bytes.ByteArray;
import java.lang.reflect.Method;

abstract class ClassData {
    private final String METHODNAME_CTOR = "<init>";
    private final String SIGNATURE_CTOR = "()V";
    private final String ATTRIBNAME_CODE = "Code";
    private final String CLASSNAME_OBJECT = "java/lang/Object";
    private final ByteArray _data = new ByteArray();
    protected final ConstantPool _constantPool = new ConstantPool();
    private final int _indMethodCtor = this._constantPool.addMethodInfo("java/lang/Object", "<init>", "()V");
    private final int _indSuperClass = this._constantPool.addClassInfo("java/lang/Object");
    private final int _indMethodnameCtor = this._constantPool.addStringInfo("<init>");
    private final int _indSigCtor = this._constantPool.addStringInfo("()V");
    protected final int _indAttribCode = this._constantPool.addStringInfo("Code");
    private final String _clsName;
    private boolean _created = false;
    protected final MethodForClassFile _defaultConstructor = new DefaultConstructorMethod(this._indMethodnameCtor, this._indSigCtor, this._indAttribCode, this._indMethodCtor);

    public ClassData(String clsName) {
        this._clsName = clsName;
    }

    private void createData() throws NoSuchMethodException {
        this._created = true;
        int indThisClass = this._constantPool.addClassInfo(this._clsName);
        int indResolverInterface = this.getIndSuperclass();
        MethodForClassFile getMethod = this.createMethod();
        this._data.add(new int[]{202, 254, 186, 190, 0, 3, 0, 45});
        this._data.add(this._constantPool.asBytes());
        this._data.addInt16(33);
        this._data.addInt16(indThisClass);
        this._data.addInt16(this._indSuperClass);
        this._data.addInt16(1);
        this._data.addInt16(indResolverInterface);
        this._data.addInt16(0);
        this._data.addInt16(2);
        this._data.add(this._defaultConstructor.asBytes());
        this._data.add(getMethod.asBytes());
        this._data.addInt16(0);
    }

    protected abstract int getIndSuperclass();

    protected abstract MethodForClassFile createMethod() throws NoSuchMethodException;

    protected static String getClassName(Class cls) {
        return cls.getName().replace('.', '/');
    }

    public ByteArray asBytes() throws NoSuchMethodException {
        if (!this._created) {
            this.createData();
        }
        return this._data;
    }

    protected int writeGetMethod(Method curMethod) {
        String curMethodName = curMethod.getName();
        String curClassName = SetterClassData.getClassName(curMethod.getDeclaringClass());
        int indMethod = this._constantPool.addMethodInfo(curClassName, curMethodName, ClassData.getGetSignature(curMethod));
        return indMethod;
    }

    private static String getGetSignature(Method method) {
        return "()L" + SetterClassData.getClassName(method.getReturnType()) + ";";
    }
}

