/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic;

import ahc.collection.Cache;
import ahc.collection.Collection;
import ahc.collection.Iterator;
import ahc.collection.Map;
import ahc.collection.MapHelper;
import ahc.collection.Pair;
import ahc.collection.Set;
import ahc.collection.SetHelper;
import ahc.generic.BeanAttribute;
import ahc.util.string.StringHelper;
import java.lang.reflect.Method;

public class BeanMeta {
    private final Class _type;
    private final Map _attributes = MapHelper.createMap();
    private final Set _readAttributes = SetHelper.createSet();
    private final Set _writeAttributes = SetHelper.createSet();
    private final Set _readWriteAttributes = SetHelper.createSet();

    public static BeanMeta create(Class type) {
        return new BeanMeta(type);
    }

    public static BeanMeta create(Object obj) {
        return BeanMeta.create(obj.getClass());
    }

    private BeanMeta(Class type) {
        this._type = type;
        Cache attribPairs = new Cache(){

            protected Object createNew(Object key) {
                return new Pair();
            }
        };
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.addCandidate(methods[i], attribPairs, "set", false, false);
            this.addCandidate(methods[i], attribPairs, "get", true, false);
            this.addCandidate(methods[i], attribPairs, "is", true, true);
            this.addCandidate(methods[i], attribPairs, "has", true, true);
        }
        Iterator iter = attribPairs.getKeys().begin();
        while (iter.hasCurrent()) {
            Pair pair = (Pair)attribPairs.get(iter.current());
            BeanAttribute curAttrib = new BeanAttribute((String)iter.current(), (Method)pair.getFirst(), (Method)pair.getSecond());
            this._attributes.put(iter.current(), curAttrib);
            if (curAttrib.isReadable()) {
                this._readAttributes.add(curAttrib);
            }
            if (curAttrib.isWritable()) {
                this._writeAttributes.add(curAttrib);
            }
            if (curAttrib.isReadable() && curAttrib.isWritable()) {
                this._readWriteAttributes.add(curAttrib);
            }
            iter.next();
        }
    }

    private void addCandidate(Method method, Cache attribPairs, String prefix, boolean isGetter, boolean isBoolean) {
        String methodName = method.getName();
        if (!methodName.startsWith(prefix)) {
            return;
        }
        if (isGetter && method.getParameterTypes().length > 0) {
            return;
        }
        if (!isGetter && method.getParameterTypes().length != 1) {
            return;
        }
        if (!isGetter && Void.TYPE.equals(method.getReturnType())) {
            return;
        }
        if (isBoolean && !Boolean.TYPE.equals(method.getReturnType())) {
            return;
        }
        Pair pair = (Pair)attribPairs.get(StringHelper.firstLower(methodName.substring(prefix.length())));
        if (isGetter) {
            pair.setFirst(method);
        } else {
            pair.setSecond(method);
        }
    }

    public BeanAttribute getAttribute(String attributeName) {
        return (BeanAttribute)this._attributes.get(attributeName);
    }

    public Collection getAttributes() {
        return this._attributes.vals();
    }

    public Collection getReadableAttributes() {
        return this._readAttributes;
    }

    public Collection getWritableAttributes() {
        return this._writeAttributes;
    }

    public Collection getReadWriteAttributes() {
        return this._readWriteAttributes;
    }

    public Class getType() {
        return this._type;
    }
}

