/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.GenericCollection;
import ahc.collection.Set;
import ahc.collection.SynchronizedSet;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.equality.IdentityEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.DlinkedStore;
import ahc.collection.store.HashStore;
import ahc.collection.store.Store;
import java.util.Collection;
import java.util.Comparator;

public class SetHelper {
    public static final EqualityStrategy EQ_EQUALS = new EqualsEqualityStrategy();
    public static final EqualityStrategy EQ_IDENTITY = new IdentityEqualityStrategy();
    public static final AccessStrategy ACCESS_DEFAULT = GenericAccessStrategy.create(null, true);
    public static final Set EMPTY = SetHelper.createSet().immutableSetView();

    public static Set synchronizedSet(Set set) {
        return SynchronizedSet.create(set);
    }

    public static Set createSet() {
        return SetHelper.createHashSet();
    }

    public static Set createSet(Collection initValues) {
        return SetHelper.initialize(SetHelper.createHashSet(), initValues);
    }

    public static Set createSet(Object[] initValues) {
        return SetHelper.initialize(SetHelper.createHashSet(), initValues);
    }

    private static Set initialize(Set set, Collection initValues) {
        set.addAll(initValues);
        return set;
    }

    private static Set initialize(Set set, Object[] initValues) {
        if (initValues != null) {
            for (int i = 0; i < initValues.length; ++i) {
                set.add(initValues[i]);
            }
        }
        return set;
    }

    public static Set createArraySet() {
        return SetHelper.createArraySet((Comparator)null);
    }

    public static Set createArraySet(Collection initValues) {
        return SetHelper.initialize(SetHelper.createArraySet(), initValues);
    }

    public static Set createArraySet(Object[] initValues) {
        return SetHelper.initialize(SetHelper.createArraySet(), initValues);
    }

    public static Set createArraySet(int initialSize) {
        return SetHelper.createArraySet(null, initialSize);
    }

    public static Set createArraySet(Comparator comp) {
        return SetHelper.createArraySet(EQ_EQUALS, comp);
    }

    public static Set createArraySet(Comparator comp, int initialSize) {
        return SetHelper.createArraySet(EQ_EQUALS, comp, initialSize);
    }

    public static Set createArraySet(EqualityStrategy eqStrat, Comparator comp) {
        return SetHelper.createArraySet(eqStrat, GenericAccessStrategy.create(comp, true));
    }

    public static Set createArraySet(EqualityStrategy eqStrat, Comparator comp, int initialSize) {
        return SetHelper.createArraySet(eqStrat, GenericAccessStrategy.create(comp, true), initialSize);
    }

    public static Set createArraySet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return SetHelper.createSet(new ArrayStore(eqStrat), accessStrat);
    }

    public static Set createArraySet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return SetHelper.createSet(new ArrayStore(eqStrat, initialSize), accessStrat);
    }

    public static Set createDlinkedSet() {
        return SetHelper.createDlinkedSet((Comparator)null);
    }

    public static Set createDlinkedSet(Collection initValues) {
        return SetHelper.initialize(SetHelper.createDlinkedSet(), initValues);
    }

    public static Set createDlinkedSet(Object[] initValues) {
        return SetHelper.initialize(SetHelper.createDlinkedSet(), initValues);
    }

    public static Set createDlinkedSet(Comparator comp) {
        return SetHelper.createDlinkedSet(EQ_EQUALS, comp);
    }

    public static Set createDlinkedSet(EqualityStrategy eqStrat, Comparator comp) {
        return SetHelper.createDlinkedSet(eqStrat, GenericAccessStrategy.create(comp, true));
    }

    public static Set createDlinkedSet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return SetHelper.createSet(new DlinkedStore(eqStrat), accessStrat);
    }

    public static Set createHashSet() {
        return SetHelper.createHashSet(EQ_EQUALS);
    }

    public static Set createHashSet(Collection initValues) {
        return SetHelper.initialize(SetHelper.createHashSet(), initValues);
    }

    public static Set createHashSet(Object[] initValues) {
        return SetHelper.initialize(SetHelper.createHashSet(), initValues);
    }

    public static Set createHashSet(int initialSize) {
        return SetHelper.createHashSet(EQ_EQUALS, initialSize);
    }

    public static Set createHashSet(int initialSize, double loadFactor) {
        return SetHelper.createHashSet(EQ_EQUALS, initialSize, loadFactor);
    }

    public static Set createHashSet(EqualityStrategy eqStrat) {
        return SetHelper.createHashSet(eqStrat, ACCESS_DEFAULT);
    }

    public static Set createHashSet(EqualityStrategy eqStrat, int initialSize) {
        return SetHelper.createHashSet(eqStrat, ACCESS_DEFAULT, initialSize);
    }

    public static Set createHashSet(EqualityStrategy eqStrat, int initialSize, double loadFactor) {
        return SetHelper.createHashSet(eqStrat, ACCESS_DEFAULT, initialSize, loadFactor);
    }

    public static Set createHashSet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return SetHelper.createSet(new HashStore(eqStrat), accessStrat);
    }

    public static Set createHashSet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return SetHelper.createSet(new HashStore(eqStrat, initialSize), accessStrat);
    }

    public static Set createHashSet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return SetHelper.createSet(new HashStore(eqStrat, initialSize, loadFactor), accessStrat);
    }

    public static Set createSet(Store store, AccessStrategy accessStrategy) {
        return new GenericCollection(store, accessStrategy);
    }
}

