/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.EntryKeyComparator;
import ahc.collection.GenericMap;
import ahc.collection.GenericMultiSet;
import ahc.collection.Map;
import ahc.collection.MultiSet;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.equality.IdentityEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.DlinkedStore;
import ahc.collection.store.HashStore;
import ahc.collection.store.Store;
import java.util.Comparator;

public class MultiSetHelper {
    public static final EqualityStrategy EQ_EQUALS = new EqualsEqualityStrategy();
    public static final EqualityStrategy EQ_IDENTITY = new IdentityEqualityStrategy();
    private static final AccessStrategy ACCESS_UNIQUE = GenericAccessStrategy.create(null, true);

    public static MultiSet createMultiSet() {
        return MultiSetHelper.createHashMultiSet();
    }

    public static MultiSet createArrayMultiSet() {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static MultiSet createArrayMultiSet(int initialSize) {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, ACCESS_UNIQUE, initialSize);
    }

    public static MultiSet createArrayMultiSet(EqualityStrategy eqStrat) {
        return MultiSetHelper.createArrayMultiSet(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiSet createArrayMultiSet(EqualityStrategy eqStrat, int initialSize) {
        return MultiSetHelper.createArrayMultiSet(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static MultiSet createArrayMultiSet(Comparator comp) {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static MultiSet createArrayMultiSet(Comparator comp, int initialSize) {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true), initialSize);
    }

    public static MultiSet createArrayMultiSet(AccessStrategy accessStrat) {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, accessStrat);
    }

    public static MultiSet createArrayMultiSet(AccessStrategy accessStrat, int initialSize) {
        return MultiSetHelper.createArrayMultiSet(EQ_EQUALS, accessStrat, initialSize);
    }

    public static MultiSet createArrayMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiSetHelper.createMultiSet(new ArrayStore(eqStrat), accessStrat);
    }

    public static MultiSet createArrayMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MultiSetHelper.createMultiSet(new ArrayStore(eqStrat, initialSize), accessStrat);
    }

    public static MultiSet createDlinkedMultiSet() {
        return MultiSetHelper.createDlinkedMultiSet(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static MultiSet createDlinkedMultiSet(EqualityStrategy eqStrat) {
        return MultiSetHelper.createDlinkedMultiSet(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiSet createDlinkedMultiSet(Comparator comp) {
        return MultiSetHelper.createDlinkedMultiSet(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static MultiSet createDlinkedMultiSet(AccessStrategy accessStrat) {
        return MultiSetHelper.createDlinkedMultiSet(EQ_EQUALS, accessStrat);
    }

    public static MultiSet createDlinkedMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiSetHelper.createMultiSet(new DlinkedStore(eqStrat), accessStrat);
    }

    public static MultiSet createHashMultiSet() {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS);
    }

    public static MultiSet createHashMultiSet(int initialSize) {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS, initialSize);
    }

    public static MultiSet createHashMultiSet(int initialSize, double loadFactor) {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS, initialSize, loadFactor);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat) {
        return MultiSetHelper.createHashMultiSet(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat, int initialSize) {
        return MultiSetHelper.createHashMultiSet(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat, int initialSize, double loadFactor) {
        return MultiSetHelper.createHashMultiSet(eqStrat, ACCESS_UNIQUE, initialSize, loadFactor);
    }

    public static MultiSet createHashMultiSet(AccessStrategy accessStrat) {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS, accessStrat);
    }

    public static MultiSet createHashMultiSet(AccessStrategy accessStrat, int initialSize) {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS, accessStrat, initialSize);
    }

    public static MultiSet createHashMultiSet(AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MultiSetHelper.createHashMultiSet(EQ_EQUALS, accessStrat, initialSize, loadFactor);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiSetHelper.createMultiSet(new HashStore(eqStrat), accessStrat);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MultiSetHelper.createMultiSet(new HashStore(eqStrat, initialSize), accessStrat);
    }

    public static MultiSet createHashMultiSet(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MultiSetHelper.createMultiSet(new HashStore(eqStrat, initialSize, loadFactor), accessStrat);
    }

    public static MultiSet createMultiSet(Store store, AccessStrategy accessStrat) {
        return MultiSetHelper.createMultiSet(new GenericMap(store, accessStrat));
    }

    public static MultiSet createMultiSet(Map map) {
        return new GenericMultiSet(map);
    }
}

