/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.openorb.io.Scrap;

public class StorageBuffer {
    private int m_avail;
    private Scrap m_mark;
    private int m_markavail;
    private Scrap m_head;
    private Scrap m_temp_head = new Scrap();
    private Scrap m_tail;
    private boolean m_read_write_mode;

    public StorageBuffer(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || len + off > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.m_head = new Scrap();
        this.m_avail = len;
        this.m_head.fBuffer = buf;
        this.m_head.fOffset = off;
        this.m_head.fLength = len;
        this.m_head.fPosition = len;
        this.m_head.fMode = 3;
    }

    public StorageBuffer(InputStream is, int total_len) throws IOException {
        this(null, 0, 0, is, total_len);
    }

    public StorageBuffer(byte[] buf, int off, int len, InputStream is, int total_len) throws IOException {
        int alloc;
        Scrap t;
        if (buf != null && (off < 0 || len < 0 || len + off > buf.length || is != null && len > total_len)) {
            throw new IndexOutOfBoundsException();
        }
        Scrap h = t = new Scrap();
        boolean interrupt = false;
        this.m_avail = total_len;
        if (buf == null || len == 0) {
            t.fPosition = 0;
            t.fBuffer = null;
        } else {
            if (is == null) {
                t.fBuffer = new byte[len];
                t.fOffset = 0;
                t.fLength = len;
                t.fPosition = len;
                t.fMode = 0;
                System.arraycopy(buf, off, t.fBuffer, 0, len);
                this.m_head = h;
                this.m_avail = len;
                return;
            }
            alloc = total_len > 2048 ? 2048 : total_len;
            t.fBuffer = new byte[alloc];
            t.fOffset = 0;
            t.fLength = alloc;
            t.fPosition = alloc;
            t.fMode = 0;
            System.arraycopy(buf, off, t.fBuffer, 0, len);
            alloc -= len;
            total_len -= len;
            int pos = len;
            while (alloc > 0) {
                int ret;
                try {
                    ret = is.read(t.fBuffer, pos, alloc);
                }
                catch (InterruptedIOException ex) {
                    interrupt = true;
                    ret = ex.bytesTransferred;
                }
                if (ret >= 0) {
                    pos += ret;
                    alloc -= ret;
                    total_len -= ret;
                    continue;
                }
                if (interrupt) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("EOF reached when reading message");
            }
        }
        while (total_len > 0) {
            alloc = total_len > 2048 ? 2048 : total_len;
            Scrap nex = new Scrap();
            nex.fBuffer = new byte[alloc];
            nex.fOffset = 0;
            nex.fLength = alloc;
            nex.fPosition = t.fPosition + alloc;
            nex.fMode = 0;
            int pos = 0;
            while (alloc > 0) {
                int ret;
                try {
                    ret = is.read(nex.fBuffer, pos, alloc);
                }
                catch (InterruptedIOException ex) {
                    interrupt = true;
                    ret = ex.bytesTransferred;
                }
                if (ret >= 0) {
                    pos += ret;
                    alloc -= ret;
                    total_len -= ret;
                    continue;
                }
                if (interrupt) {
                    Thread.currentThread().interrupt();
                }
                throw new EOFException("error: EOF reached when reading message");
            }
            t.fNext = nex;
            t = nex;
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
        this.m_head = h.fBuffer == null ? h.fNext : h;
    }

    StorageBuffer(Scrap head, int len) {
        this.m_head = head;
        this.m_tail = null;
        this.m_avail = len;
    }

    StorageBuffer(Scrap head, Scrap tail) {
        this.m_head = head;
        this.m_tail = tail;
        this.m_avail = tail.fPosition - tail.fLength - head.fPosition + head.fLength;
    }

    public int available() {
        return this.m_avail;
    }

    /*
     * Unable to fully structure code
     */
    public void writeTo(OutputStream os) throws IOException {
        block11: {
            if (this.m_head == null) {
                throw new EOFException("Buffer is empty");
            }
            interrupt = Thread.interrupted();
            if (!this.m_read_write_mode) ** GOTO lbl34
            while (this.m_head != this.m_tail) {
                if (this.m_head.fMode == 3) {
                    tmp = new byte[this.m_head.fLength];
                    System.arraycopy(this.m_head.fBuffer, this.m_head.fOffset, tmp, 0, this.m_head.fLength);
                    this.m_head.fBuffer = tmp;
                    this.m_head.fOffset = 0;
                    this.m_head.fMode = 0;
                }
                d = 0;
                while (d < this.m_head.fLength) {
                    try {
                        os.write(this.m_head.fBuffer, this.m_head.fOffset + d, this.m_head.fLength - d);
                        break;
                    }
                    catch (InterruptedIOException ex) {
                        interrupt = true;
                        d += ex.bytesTransferred;
                    }
                }
                this.m_head = this.m_head.fNext;
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                d = 0;
                while (d < this.m_head.fLength) {
                    try {
                        os.write(this.m_head.fBuffer, this.m_head.fOffset + d, this.m_head.fLength - d);
                        break;
                    }
                    catch (InterruptedIOException ex) {
                        interrupt = true;
                        d += ex.bytesTransferred;
                    }
                }
                this.m_head = this.m_head.fNext;
lbl34:
                // 2 sources

                ** while (this.m_head != this.m_tail)
            }
        }
        this.m_head = null;
        this.m_avail = 0;
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public int next(OctetSeqHolder buf, IntHolder off, IntHolder len) {
        if (this.m_head == null) {
            buf.value = null;
            off.value = 0;
            return -1;
        }
        if (len.value < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_read_write_mode && this.m_head.fMode == 3) {
            byte[] copy = new byte[this.m_head.fLength];
            System.arraycopy(this.m_head.fBuffer, this.m_head.fOffset, copy, 0, this.m_head.fLength);
            this.m_head.fBuffer = copy;
            this.m_head.fOffset = 0;
            this.m_head.fMode = 0;
        }
        buf.value = this.m_head.fBuffer;
        off.value = this.m_head.fOffset;
        if (len.value < this.m_head.fLength) {
            int olen = len.value;
            len.value = 0;
            if (this.m_mark == null && this.m_tail == null || this.m_head == this.m_temp_head) {
                this.m_head.fOffset += olen;
                this.m_head.fLength -= olen;
            } else {
                this.m_temp_head.fBuffer = this.m_head.fBuffer;
                this.m_temp_head.fOffset = this.m_head.fOffset + olen;
                this.m_temp_head.fLength = this.m_head.fLength - olen;
                this.m_temp_head.fMode = this.m_head.fMode | 1;
                this.m_temp_head.fPosition = this.m_head.fPosition;
                this.m_temp_head.fNext = this.m_head.fNext;
                this.m_head = this.m_temp_head;
            }
            this.m_avail -= olen;
            return olen;
        }
        int olen = this.m_head.fLength;
        len.value -= olen;
        this.m_head = this.m_head.fNext;
        if (this.m_head == this.m_tail) {
            this.m_head = null;
        }
        this.m_avail -= olen;
        return olen;
    }

    public int skip(IntHolder len) {
        if (this.m_head == null) {
            return -1;
        }
        int skip = 0;
        while (this.m_head != null && len.value >= this.m_head.fLength) {
            len.value -= this.m_head.fLength;
            this.m_avail -= this.m_head.fLength;
            skip += this.m_head.fLength;
            this.m_head = this.m_head.fNext;
            if (this.m_head != this.m_tail) continue;
            this.m_head = null;
        }
        if (this.m_head != null && len.value > 0) {
            if (this.m_mark == null && this.m_tail == null || this.m_head == this.m_temp_head) {
                this.m_head.fOffset += len.value;
                this.m_head.fLength -= len.value;
            } else {
                this.m_temp_head.fBuffer = this.m_head.fBuffer;
                this.m_temp_head.fOffset = this.m_head.fOffset + len.value;
                this.m_temp_head.fLength = this.m_head.fLength - len.value;
                this.m_temp_head.fMode = this.m_head.fMode | 1;
                this.m_temp_head.fPosition = this.m_head.fPosition;
                this.m_temp_head.fNext = this.m_head.fNext;
                this.m_head = this.m_temp_head;
            }
            skip += len.value;
            this.m_avail -= len.value;
            len.value = 0;
        }
        return skip;
    }

    public byte[] linearize() {
        if (this.m_head == null) {
            return new byte[0];
        }
        if (this.m_head.fLength != this.m_head.fBuffer.length || this.m_head.fNext != this.m_tail || this.m_head.fMode != 0 || this.m_head.fOffset != 0) {
            byte[] buf = new byte[this.m_avail];
            Scrap nex = this.m_head;
            int disp = this.m_head.fPosition - this.m_head.fLength;
            while (nex != this.m_tail) {
                try {
                    System.arraycopy(nex.fBuffer, nex.fOffset, buf, disp, nex.fLength);
                }
                catch (Exception ex) {
                    return null;
                }
                disp += nex.fLength;
                nex = nex.fNext;
            }
            this.m_head.fBuffer = buf;
            this.m_head.fOffset = 0;
            this.m_head.fLength = this.m_avail;
            this.m_head.fMode = 0;
            this.m_head.fPosition = this.m_head.fPosition - this.m_head.fLength + this.m_avail;
            this.m_head.fNext = this.m_tail;
        }
        return this.m_head.fBuffer;
    }

    public boolean isReadWriteMode() {
        return this.m_read_write_mode;
    }

    public void setReadWriteMode(boolean readWriteMode) {
        this.m_read_write_mode = readWriteMode;
    }

    public boolean mark() {
        if (this.m_mark == null) {
            this.m_mark = this.m_head;
            this.m_markavail = this.m_avail;
            return true;
        }
        return false;
    }

    public boolean reset() {
        if (this.m_mark != null) {
            this.m_head = this.m_mark;
            this.m_avail = this.m_markavail;
            this.m_mark = null;
            return true;
        }
        return false;
    }
}

