/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class DataNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private DataObject obj;
    private PropL propL;
    private static boolean showFileExtensions = false;
    private static RequestProcessor.Task refreshNamesIconsTask = null;
    private static Set refreshNameNodes = null;
    private static Set refreshIconNodes = null;
    private static boolean refreshNamesIconsRunning = false;
    private static final Object refreshNameIconLock = "DataNode.refreshNameIconLock";
    static /* synthetic */ Class class$org$openide$loaders$DataNode;
    static /* synthetic */ Class class$java$lang$String;

    public DataNode(DataObject obj, Children ch) {
        super(ch);
        this.obj = obj;
        this.propL = new PropL();
        obj.addPropertyChangeListener(WeakListener.propertyChange(this.propL, obj));
        super.setName(obj.getName());
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        FileObject prim = this.obj.getPrimaryFile();
        String newDisplayName = null;
        newDisplayName = showFileExtensions || this.obj instanceof DataFolder || this.obj instanceof DefaultDataObject ? prim.getNameExt() : prim.getName();
        if (this.displayFormat != null) {
            this.setDisplayName(this.displayFormat.format(new Object[]{newDisplayName}));
        } else {
            this.setDisplayName(newDisplayName);
        }
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public void setName(String name, boolean rename) {
        try {
            if (rename) {
                this.obj.rename(name);
            }
            super.setName(name);
            if (rename) {
                this.updateDisplayName();
            }
        }
        catch (IOException ex) {
            String msg = null;
            msg = ex.getLocalizedMessage() == null || ex.getLocalizedMessage().equals(ex.getMessage()) ? NbBundle.getMessage(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = DataNode.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode, "MSG_renameError", this.getName(), name) : ex.getLocalizedMessage();
            IllegalArgumentException e = new IllegalArgumentException();
            ErrorManager.getDefault().copyAnnotation(e, ex);
            ErrorManager.getDefault().annotate(e, 256, null, msg, null, null);
            throw e;
        }
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public String getDisplayName() {
        String s = super.getDisplayName();
        try {
            s = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(s, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return s;
    }

    public Image getIcon(int type) {
        Image img = super.getIcon(type);
        try {
            img = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return img;
    }

    public Image getOpenedIcon(int type) {
        Image img = super.getOpenedIcon(type);
        try {
            img = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, this.obj.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return img;
    }

    public HelpCtx getHelpCtx() {
        return this.obj.getHelpCtx();
    }

    public boolean canRename() {
        return this.obj.isRenameAllowed();
    }

    public boolean canDestroy() {
        return this.obj.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        if (this.obj.isDeleteAllowed()) {
            this.obj.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return this.obj.isCopyAllowed();
    }

    public boolean canCut() {
        return this.obj.isMoveAllowed();
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getActions();
    }

    public SystemAction getDefaultAction() {
        if (this.obj.isTemplate()) {
            return null;
        }
        SystemAction action = super.getDefaultAction();
        if (action != null) {
            return action;
        }
        SystemAction[] arr = this.getActions();
        if (arr != null && arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    public Node.Cookie getCookie(Class cl) {
        Node.Cookie c = this.obj.getCookie(cl);
        if (c != null) {
            return c;
        }
        return super.getCookie(cl);
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        Node.Property p = DataNode.createNameProperty(this.obj);
        ss.put(p);
        if (!this.getDataObject().getPrimaryFile().isReadOnly()) {
            try {
                p = new PropertySupport.Reflection((Object)this.obj, Boolean.TYPE, "isTemplate", "setTemplate");
                p.setName("template");
                p.setDisplayName(DataObject.getString("PROP_template"));
                p.setShortDescription(DataObject.getString("HINT_template"));
                ss.put(p);
            }
            catch (Exception ex) {
                throw new InternalError();
            }
        }
        return s;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create(super.clipboardCopy());
        t.put(LoaderTransfer.transferable(this.getDataObject(), 1));
        return t;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable t = ExTransferable.create(super.clipboardCut());
        t.put(LoaderTransfer.transferable(this.getDataObject(), 4));
        return t;
    }

    static Node.Property createNameProperty(final DataObject obj) {
        PropertySupport.ReadWrite p = new PropertySupport.ReadWrite("name", class$java$lang$String == null ? (class$java$lang$String = DataNode.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_name"), DataObject.getString("HINT_name")){
            static /* synthetic */ Class class$org$openide$loaders$DataNode;

            public Object getValue() {
                return obj.getName();
            }

            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    obj.rename((String)val);
                }
                catch (IOException ex) {
                    String msg = null;
                    msg = ex.getLocalizedMessage() == null || ex.getLocalizedMessage().equals(ex.getMessage()) ? NbBundle.getMessage(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = 1.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode, "MSG_renameError", obj.getName(), val) : ex.getLocalizedMessage();
                    ErrorManager.getDefault().annotate(ex, 256, null, msg, null, null);
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean canWrite() {
                return obj.isRenameAllowed();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        return p;
    }

    void fireChange(PropertyChangeEvent ev) {
        Object newVal;
        if ("children".equals(ev.getPropertyName())) {
            return;
        }
        if ("primaryFile".equals(ev.getPropertyName())) {
            this.propL.updateStatusListener();
            this.setName(this.obj.getName(), false);
            return;
        }
        if ("name".equals(ev.getPropertyName())) {
            super.setName(this.obj.getName());
            this.updateDisplayName();
            return;
        }
        if ("cookie".equals(ev.getPropertyName())) {
            this.fireCookieChange();
        } else {
            this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }
        if ("valid".equals(ev.getPropertyName()) && (newVal = ev.getNewValue()) instanceof Boolean && !((Boolean)newVal).booleanValue()) {
            this.fireNodeDestroyed();
        }
    }

    public Node.Handle getHandle() {
        return new ObjectHandle(this.obj, this.obj.isValid() ? this != this.obj.getNodeDelegate() : true);
    }

    final void fireChangeAccess(boolean icon, boolean name) {
        if (name) {
            this.fireDisplayNameChange(null, null);
        }
        if (icon) {
            this.fireIconChange();
        }
    }

    public static boolean getShowFileExtensions() {
        return showFileExtensions;
    }

    public static void setShowFileExtensions(boolean s) {
        boolean refresh = showFileExtensions != s;
        showFileExtensions = s;
        if (refresh) {
            RequestProcessor.postRequest(new Runnable(){

                public void run() {
                    Iterator it = DataObjectPool.getPOOL().getActiveDataObjects();
                    while (it.hasNext()) {
                        DataObject obj = ((DataObjectPool.Item)it.next()).getDataObjectOrNull();
                        if (obj == null || !(obj.getNodeDelegate() instanceof DataNode)) continue;
                        ((DataNode)obj.getNodeDelegate()).updateDisplayName();
                    }
                }
            }, 300, 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectHandle
    implements Node.Handle {
        private FileObject obj;
        private boolean clone;
        static final long serialVersionUID = 6616060729084681518L;

        public ObjectHandle(DataObject obj, boolean clone) {
            this.obj = obj.getPrimaryFile();
            this.clone = clone;
        }

        public Node getNode() throws DataObjectNotFoundException {
            Node n = DataObject.find(this.obj).getNodeDelegate();
            return this.clone ? n.cloneNode() : n;
        }
    }

    private class PropL
    implements PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private FileStatusListener weakL;
        private FileSystem previous;

        public PropL() {
            this.updateStatusListener();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            DataNode.this.fireChange(ev);
        }

        private void updateStatusListener() {
            if (this.previous != null) {
                this.previous.removeFileStatusListener(this.weakL);
            }
            try {
                this.previous = DataNode.this.obj.getPrimaryFile().getFileSystem();
                if (this.weakL == null) {
                    this.weakL = WeakListener.fileStatus(this, null);
                }
                this.previous.addFileStatusListener(this.weakL);
            }
            catch (FileStateInvalidException ex) {
                this.previous = null;
            }
        }

        public void annotationChanged(FileStatusEvent ev) {
            boolean thisChanged = false;
            Iterator it = DataNode.this.obj.files().iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                if (!ev.hasChanged(fo)) continue;
                thisChanged = true;
                break;
            }
            if (thisChanged) {
                Object object = refreshNameIconLock;
                synchronized (object) {
                    boolean post = false;
                    if (ev.isNameChange()) {
                        if (refreshNameNodes == null) {
                            refreshNameNodes = new HashSet();
                        }
                        post |= refreshNameNodes.add(DataNode.this);
                    }
                    if (ev.isIconChange()) {
                        if (refreshIconNodes == null) {
                            refreshIconNodes = new HashSet();
                        }
                        post |= refreshIconNodes.add(DataNode.this);
                    }
                    if (post && !refreshNamesIconsRunning) {
                        refreshNamesIconsRunning = true;
                        if (refreshNamesIconsTask == null) {
                            refreshNamesIconsTask = RequestProcessor.postRequest(this);
                        } else {
                            refreshNamesIconsTask.schedule(0);
                        }
                    }
                }
            }
        }

        public void run() {
            DataNode[] _refreshIconNodes;
            DataNode[] _refreshNameNodes;
            Object object = refreshNameIconLock;
            synchronized (object) {
                if (refreshNameNodes != null) {
                    _refreshNameNodes = refreshNameNodes.toArray(new DataNode[refreshNameNodes.size()]);
                    refreshNameNodes.clear();
                } else {
                    _refreshNameNodes = new DataNode[]{};
                }
                if (refreshIconNodes != null) {
                    _refreshIconNodes = refreshIconNodes.toArray(new DataNode[refreshIconNodes.size()]);
                    refreshIconNodes.clear();
                } else {
                    _refreshIconNodes = new DataNode[]{};
                }
                refreshNamesIconsRunning = false;
            }
            int i = 0;
            while (i < _refreshNameNodes.length) {
                _refreshNameNodes[i].fireChangeAccess(false, true);
                ++i;
            }
            int i2 = 0;
            while (i2 < _refreshIconNodes.length) {
                _refreshIconNodes[i2].fireChangeAccess(true, false);
                ++i2;
            }
        }
    }
}

