/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool$InstanceLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public abstract class DataLoaderPool
implements Serializable {
    static final long serialVersionUID = -360141823874889956L;
    private static MultiFileLoader[] systemLoaders;
    private static MultiFileLoader[] defaultLoaders;
    private transient DataLoader[] loaderArray;
    private transient EventListenerList listeners;
    private transient DataLoader preferredLoader;
    private static final DataLoader.RecognizedFiles emptyDataLoaderRecognized;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$loaders$OperationListener;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$ShadowLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$FolderLoader;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Loader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$InstanceLoader;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool$DefaultLoader;

    protected DataLoaderPool() {
    }

    protected DataLoaderPool(DataLoader loader) {
        this.preferredLoader = loader;
    }

    protected abstract Enumeration loaders();

    public final synchronized void addChangeListener(ChangeListener chl) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, chl);
    }

    public final synchronized void removeChangeListener(ChangeListener chl) {
        if (this.listeners != null) {
            this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DataLoaderPool.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, chl);
        }
    }

    protected final void fireChangeEvent(final ChangeEvent che) {
        Object[] list;
        this.loaderArray = null;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        int i = list.length - 2;
        while (i >= 0) {
            if (list[i] == (class$javax$swing$event$ChangeListener == null ? DataLoaderPool.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                final ChangeListener l = (ChangeListener)list[i + 1];
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        l.stateChanged(che);
                    }
                });
            }
            i -= 2;
        }
    }

    public final synchronized void addOperationListener(OperationListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, l);
    }

    public final synchronized void removeOperationListener(OperationListener l) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$loaders$OperationListener == null ? (class$org$openide$loaders$OperationListener = DataLoaderPool.class$("org.openide.loaders.OperationListener")) : class$org$openide$loaders$OperationListener, l);
        }
    }

    final void fireOperationEvent(OperationEvent ev, int type) {
        Object[] list;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        int i = list.length - 2;
        while (i >= 0) {
            if (list[i] == (class$org$openide$loaders$OperationListener == null ? DataLoaderPool.class$("org.openide.loaders.OperationListener") : class$org$openide$loaders$OperationListener)) {
                OperationListener l = (OperationListener)list[i + 1];
                switch (type) {
                    case 1: {
                        l.operationCopy((OperationEvent.Copy)ev);
                        break;
                    }
                    case 2: {
                        l.operationMove((OperationEvent.Move)ev);
                        break;
                    }
                    case 3: {
                        l.operationDelete(ev);
                        break;
                    }
                    case 4: {
                        l.operationRename((OperationEvent.Rename)ev);
                        break;
                    }
                    case 5: {
                        l.operationCreateShadow((OperationEvent.Copy)ev);
                        break;
                    }
                    case 6: {
                        l.operationCreateFromTemplate((OperationEvent.Copy)ev);
                        break;
                    }
                    case 7: {
                        l.operationPostCreate(ev);
                    }
                }
            }
            i -= 2;
        }
    }

    public final Enumeration allLoaders() {
        if (this.preferredLoader == null) {
            return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
        }
        return new SequenceEnumeration(new ArrayEnumeration(new Enumeration[]{new SingletonEnumeration(this.preferredLoader), new ArrayEnumeration(DataLoaderPool.getSystemLoaders()), this.loaders(), new ArrayEnumeration(DataLoaderPool.getDefaultLoaders())}));
    }

    public DataLoader[] toArray() {
        DataLoader[] localArray = this.loaderArray;
        if (localArray != null) {
            return localArray;
        }
        ArrayList loaders = new ArrayList();
        Enumeration en = this.loaders();
        while (en.hasMoreElements()) {
            loaders.add(en.nextElement());
        }
        localArray = new DataLoader[loaders.size()];
        localArray = loaders.toArray(localArray);
        this.loaderArray = localArray;
        return localArray;
    }

    public final DataLoader firstProducerOf(Class clazz) {
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader dl = (DataLoader)en.nextElement();
            if (!dl.getRepresentationClass().isAssignableFrom(clazz)) continue;
            return dl;
        }
        return null;
    }

    public final Enumeration producersOf(final Class clazz) {
        return new FilterEnumeration(this.allLoaders()){

            public boolean accept(Object o) {
                DataLoader dl = (DataLoader)o;
                return clazz.isAssignableFrom(dl.getRepresentationClass());
            }
        };
    }

    public DataObject findDataObject(FileObject fo) throws IOException {
        return this.findDataObject(fo, emptyDataLoaderRecognized);
    }

    public DataObject findDataObject(FileObject fo, DataLoader.RecognizedFiles r) throws IOException {
        DataObject obj;
        DataLoader pref = DataLoaderPool.getPreferredLoader(fo);
        if (pref != null && (obj = pref.findDataObject(fo, r)) != null) {
            DataObjectPool.getPOOL().notifyCreation(obj);
            return obj;
        }
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader l = (DataLoader)en.nextElement();
            DataObject obj2 = l.findDataObject(fo, r);
            if (obj2 == null) continue;
            DataObjectPool.getPOOL().notifyCreation(obj2);
            return obj2;
        }
        return null;
    }

    public static void setPreferredLoader(FileObject fo, DataLoader loader) throws IOException {
        DataLoader prev = DataLoaderPool.getPreferredLoader(fo);
        if (prev == loader) {
            return;
        }
        if (loader == null) {
            fo.setAttribute("NetBeansAttrAssignedLoader", null);
        } else {
            Class<?> c = loader.getClass();
            Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
            String modulename = null;
            while (modules.hasNext()) {
                ModuleInfo module = (ModuleInfo)modules.next();
                if (!module.owns(c)) continue;
                modulename = module.getCodeNameBase();
                break;
            }
            fo.setAttribute("NetBeansAttrAssignedLoader", c.getName());
            fo.setAttribute("NetBeansAttrAssignedLoaderModule", modulename);
        }
        DataObject d = DataObjectPool.getPOOL().find(fo);
        if (d != null && d.getLoader() != loader) {
            try {
                d.setValid(false);
            }
            catch (PropertyVetoException e) {
                ErrorManager.getDefault().notify(1, e);
            }
        }
    }

    public static DataLoader getPreferredLoader(FileObject fo) {
        String assignedLoaderName = (String)fo.getAttribute("NetBeansAttrAssignedLoader");
        if (assignedLoaderName != null) {
            String modulename = (String)fo.getAttribute("NetBeansAttrAssignedLoaderModule");
            if (modulename != null) {
                Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = DataLoaderPool.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
                boolean ok = false;
                while (modules.hasNext()) {
                    ModuleInfo module = (ModuleInfo)modules.next();
                    if (!module.getCodeNameBase().equals(modulename)) continue;
                    if (module.isEnabled()) {
                        ok = true;
                        break;
                    }
                    return null;
                }
                if (!ok) {
                    return null;
                }
            }
            try {
                Class<?> loaderClass = Class.forName(assignedLoaderName, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DataLoaderPool.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
                return DataLoader.getLoader(loaderClass);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }
        return null;
    }

    private static MultiFileLoader[] getSystemLoaders() {
        if (systemLoaders == null) {
            systemLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$ShadowLoader == null ? (class$org$openide$loaders$DataLoaderPool$ShadowLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$ShadowLoader")) : class$org$openide$loaders$DataLoaderPool$ShadowLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoaderSystem")) : class$org$openide$loaders$DataLoaderPool$InstanceLoaderSystem)};
        }
        return systemLoaders;
    }

    private static MultiFileLoader[] getDefaultLoaders() {
        if (defaultLoaders == null) {
            defaultLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$FolderLoader == null ? (class$org$openide$loaders$DataLoaderPool$FolderLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$FolderLoader")) : class$org$openide$loaders$DataLoaderPool$FolderLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$XMLDataObject$Loader == null ? (class$org$openide$loaders$XMLDataObject$Loader = DataLoaderPool.class$("org.openide.loaders.XMLDataObject$Loader")) : class$org$openide$loaders$XMLDataObject$Loader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$InstanceLoader == null ? (class$org$openide$loaders$DataLoaderPool$InstanceLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$InstanceLoader")) : class$org$openide$loaders$DataLoaderPool$InstanceLoader), (MultiFileLoader)DataLoader.getLoader(class$org$openide$loaders$DataLoaderPool$DefaultLoader == null ? (class$org$openide$loaders$DataLoaderPool$DefaultLoader = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool$DefaultLoader")) : class$org$openide$loaders$DataLoaderPool$DefaultLoader)};
        }
        return defaultLoaders;
    }

    static MultiFileLoader getDefaultFileLoader() {
        return DataLoaderPool.getDefaultLoaders()[3];
    }

    static MultiFileLoader getFolderLoader() {
        return DataLoaderPool.getDefaultLoaders()[0];
    }

    static MultiFileLoader getShadowLoader() {
        return DataLoaderPool.getSystemLoaders()[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        emptyDataLoaderRecognized = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fo) {
            }
        };
    }

    private static class InstanceLoaderSystem
    extends DataLoaderPool$InstanceLoader {
        private static final long serialVersionUID = -935749906623354837L;

        protected FileObject findPrimaryFile(FileObject fo) {
            FileSystem fs = null;
            try {
                fs = fo.getFileSystem();
            }
            catch (FileStateInvalidException e) {
                return null;
            }
            if (fs != Repository.getDefault().getDefaultFileSystem()) {
                return null;
            }
            return super.findPrimaryFile(fo);
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "settings"};
        }
    }
}

