/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc.rtf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openorb.compiler.doc.IdlDoc;
import org.openorb.compiler.doc.html.content;
import org.openorb.compiler.doc.rtf.model;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;

public class IdlToRTF {
    private IdlObject _root;
    private int nb_color_entry = 1;
    private model title_model;
    private model header_model;
    private model footer_model;
    private model section_title_model;
    private model section_id_model;
    private model section_hierarchy_model;
    private model section_desc_model;
    private model summary_title_model;
    private model summary_entry_name_model;
    private model summary_entry_desc_model;
    private model summary_inher_title_model;
    private model summary_inher_desc_model;
    private model summary_inher_list_model;
    private model detail_title_model;
    private model detail_id_model;
    private model detail_java_model;
    private model detail_desc_model;
    private model detail_comment_model;
    private model detail_highlight_model;

    private String convertTextAttribute(String attr) {
        String s = "";
        String token = null;
        StringTokenizer str = new StringTokenizer(attr, ",");
        while (str.hasMoreTokens()) {
            token = str.nextToken();
            if (token.equalsIgnoreCase("italic")) {
                s = s + "\\i";
                continue;
            }
            if (token.equalsIgnoreCase("bold")) {
                s = s + "\\b";
                continue;
            }
            if (token.equalsIgnoreCase("underline")) {
                s = s + "\\ul";
                continue;
            }
            if (token.equalsIgnoreCase("uppercase")) {
                s = s + "\\caps";
                continue;
            }
            if (token.equalsIgnoreCase("left")) {
                s = s + "\\ql";
                continue;
            }
            if (token.equalsIgnoreCase("right")) {
                s = s + "\\qr";
                continue;
            }
            if (token.equalsIgnoreCase("center")) {
                s = s + "\\qc";
                continue;
            }
            if (!token.equalsIgnoreCase("justified")) continue;
            s = s + "\\qj";
        }
        return s;
    }

    private String convertBorderAttribute(String attr, boolean table) {
        String s = "";
        String style = "";
        String extra = "";
        boolean bottom = false;
        boolean top = false;
        boolean left = false;
        boolean right = false;
        String token = null;
        StringTokenizer str = new StringTokenizer(attr, ",");
        while (str.hasMoreTokens()) {
            token = str.nextToken();
            if (token.equalsIgnoreCase("box")) {
                bottom = true;
                top = true;
                left = true;
                right = true;
                continue;
            }
            if (token.equalsIgnoreCase("bottom")) {
                bottom = true;
                continue;
            }
            if (token.equalsIgnoreCase("top")) {
                top = true;
                continue;
            }
            if (token.equalsIgnoreCase("left")) {
                left = true;
                continue;
            }
            if (token.equalsIgnoreCase("right")) {
                right = true;
                continue;
            }
            if (token.equalsIgnoreCase("double")) {
                style = "\\brdrdb";
                continue;
            }
            if (token.equalsIgnoreCase("simple")) {
                style = "\\brdrs";
                continue;
            }
            if (token.equalsIgnoreCase("dotted")) {
                style = "\\brdrdot";
                continue;
            }
            if (!token.equalsIgnoreCase("shadowed")) continue;
            extra = "\\brdrsh";
        }
        if (bottom) {
            s = table ? s + "\\clbrdrb" + style + extra + "\\brsp10" + " " : s + "\\brdrb" + style + extra + "\\brsp10" + " ";
        }
        if (top) {
            s = table ? s + "\\clbrdrt" + style + extra + "\\brsp10" + " " : s + "\\brdrt" + style + extra + "\\brsp10" + " ";
        }
        if (left) {
            s = table ? s + "\\clbrdrl" + style + extra + "\\brsp10" + " " : s + "\\brdrl" + style + extra + "\\brsp10" + " ";
        }
        if (right) {
            s = table ? s + "\\clbrdrr" + style + extra + "\\brsp10" + " " : s + "\\brdrr" + style + extra + "\\brsp10" + " ";
        }
        return s;
    }

    private void loadModel(Properties p, model model2, String type, boolean table) {
        String s = null;
        model2.fontName = p.getProperty(type + ".font");
        model2.fontFamily = p.getProperty(type + ".family");
        model2.color = p.getProperty(type + ".color");
        model2.backcolor = p.getProperty(type + ".background");
        s = p.getProperty(type + ".size");
        model2.fontSize = "" + new Integer(s) * 2;
        s = p.getProperty(type + ".attributes");
        if (s != null) {
            model2.attribute = this.convertTextAttribute(s);
        }
        if ((s = p.getProperty(type + ".border")) != null) {
            model2.border = this.convertBorderAttribute(s, table);
        }
    }

    private void loadStyleSheet() {
        Properties stylesheet = new Properties();
        InputStream input = null;
        if (input != null) {
            try {
                stylesheet.load(input);
                input.close();
            }
            catch (IOException ex) {}
        } else {
            System.out.println("IDL to RTF fatal error : Unable to open style sheet model ( rtf.cs )");
            System.exit(0);
        }
        this.title_model = new model();
        this.header_model = new model();
        this.footer_model = new model();
        this.section_title_model = new model();
        this.section_id_model = new model();
        this.section_hierarchy_model = new model();
        this.section_desc_model = new model();
        this.summary_title_model = new model();
        this.summary_entry_name_model = new model();
        this.summary_entry_desc_model = new model();
        this.summary_inher_title_model = new model();
        this.summary_inher_list_model = new model();
        this.summary_inher_desc_model = new model();
        this.detail_title_model = new model();
        this.detail_id_model = new model();
        this.detail_java_model = new model();
        this.detail_desc_model = new model();
        this.detail_comment_model = new model();
        this.detail_highlight_model = new model();
        this.loadModel(stylesheet, this.title_model, "title", false);
        this.loadModel(stylesheet, this.header_model, "header", false);
        this.loadModel(stylesheet, this.footer_model, "footer", false);
        this.loadModel(stylesheet, this.section_title_model, "section.title", false);
        this.loadModel(stylesheet, this.section_id_model, "section.id", false);
        this.loadModel(stylesheet, this.section_hierarchy_model, "section.hierarchy", false);
        this.loadModel(stylesheet, this.section_desc_model, "section.description", false);
        this.loadModel(stylesheet, this.summary_title_model, "summary.title", true);
        this.loadModel(stylesheet, this.summary_entry_name_model, "summary.entry_name", true);
        this.loadModel(stylesheet, this.summary_entry_desc_model, "summary.entry_description", true);
        this.loadModel(stylesheet, this.summary_inher_title_model, "summary.inheritance_title", true);
        this.loadModel(stylesheet, this.summary_inher_desc_model, "summary.inheritance_description", true);
        this.loadModel(stylesheet, this.summary_inher_list_model, "summary.inheritance_list", true);
        this.loadModel(stylesheet, this.detail_title_model, "detail.title", true);
        this.loadModel(stylesheet, this.detail_id_model, "detail.id", true);
        this.loadModel(stylesheet, this.detail_java_model, "detail.java", true);
        this.loadModel(stylesheet, this.detail_desc_model, "detail.description", true);
        this.loadModel(stylesheet, this.detail_comment_model, "detail.comment", true);
        this.loadModel(stylesheet, this.detail_highlight_model, "detail.highlight", true);
    }

    private String getModel(model model2) {
        String desc = "";
        desc = desc + "\\plain ";
        desc = desc + "\\f" + model2.fontNumber;
        desc = desc + "\\fs" + model2.fontSize;
        desc = desc + "\\cf" + model2.colorNumber;
        if (model2.backcolor != null) {
            desc = desc + "\\cbpat" + model2.backgroundNumber;
        }
        if (model2.border != null) {
            desc = desc + model2.border;
        }
        if (model2.attribute != null) {
            desc = desc + model2.attribute;
        }
        desc = desc + " ";
        return desc;
    }

    private void write_model(model model2, PrintWriter rtf) {
        rtf.print("\\plain ");
        rtf.print("\\f" + model2.fontNumber);
        rtf.print("\\fs" + model2.fontSize);
        rtf.print("\\cf" + model2.colorNumber);
        if (model2.backcolor != null) {
            rtf.print("\\cbpat" + model2.backgroundNumber);
        }
        if (model2.border != null) {
            rtf.print(model2.border);
        }
        if (model2.attribute != null) {
            rtf.print(model2.attribute + " ");
        }
    }

    private void write_cell_model(model model2, PrintWriter rtf) {
        rtf.print("\\f" + model2.fontNumber);
        rtf.print("\\fs" + model2.fontSize);
        rtf.print("\\cf" + model2.colorNumber);
        if (model2.attribute != null) {
            rtf.print(model2.attribute);
        }
        rtf.print(" ");
    }

    private void write_cell_border(model model2, PrintWriter rtf) {
        if (model2.border != null) {
            rtf.print(model2.border);
        }
    }

    private void write_cell_color(model model2, PrintWriter rtf) {
        if (model2.backcolor != null) {
            rtf.print("\\clcbpat" + model2.backgroundNumber);
        }
    }

    private void createFontEntry(model model2, PrintWriter rtf) {
        rtf.print("{\\f" + model2.fontNumber + "\\f");
        rtf.print(model2.fontFamily + " ");
        rtf.print(model2.fontName + "}");
    }

    private void createColorEntry(model model2, PrintWriter rtf) {
        ++this.nb_color_entry;
        if (model2.color.equalsIgnoreCase("black")) {
            rtf.print("\\red0\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("green")) {
            rtf.print("\\red0\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("red")) {
            rtf.print("\\red128\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("blue")) {
            rtf.print("\\red0\\green0\\blue128;");
        } else if (model2.color.equalsIgnoreCase("yellow")) {
            rtf.print("\\red128\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("lightyellow")) {
            rtf.print("\\red255\\green255\\blue0;");
        } else if (model2.color.equalsIgnoreCase("cyan")) {
            rtf.print("\\red0\\green255\\blue255;");
        } else if (model2.color.equalsIgnoreCase("brown")) {
            rtf.print("\\red128\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("grey")) {
            rtf.print("\\red128\\green128\\blue128;");
        } else if (model2.color.equalsIgnoreCase("purple")) {
            rtf.print("\\red128\\green0\\blue128;");
        } else if (model2.color.equalsIgnoreCase("lightgrey")) {
            rtf.print("\\red192\\green192\\blue192;");
        } else if (model2.color.equalsIgnoreCase("lightpurple")) {
            rtf.print("\\red255\\green0\\blue255;");
        } else if (model2.color.equalsIgnoreCase("lightblue")) {
            rtf.print("\\red0\\green0\\blue255;");
        } else if (model2.color.equalsIgnoreCase("lightred")) {
            rtf.print("\\red255\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("lightgreen")) {
            rtf.print("\\red0\\green255\\blue0;");
        } else if (model2.color.equalsIgnoreCase("white")) {
            rtf.print("\\red255\\green255\\blue255;");
        } else {
            StringTokenizer str = new StringTokenizer(model2.color, ",");
            while (str.hasMoreTokens()) {
                rtf.print("\\" + str.nextToken());
            }
            rtf.print(";");
        }
    }

    private void createBackColorEntry(model model2, PrintWriter rtf) {
        if (model2.backcolor == null) {
            return;
        }
        ++this.nb_color_entry;
        if (model2.backcolor.equalsIgnoreCase("black")) {
            rtf.print("\\red0\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("green")) {
            rtf.print("\\red0\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("red")) {
            rtf.print("\\red128\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("blue")) {
            rtf.print("\\red0\\green0\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("yellow")) {
            rtf.print("\\red128\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("lightyellow")) {
            rtf.print("\\red255\\green255\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("cyan")) {
            rtf.print("\\red0\\green255\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("brown")) {
            rtf.print("\\red128\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("grey")) {
            rtf.print("\\red128\\green128\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("purple")) {
            rtf.print("\\red128\\green0\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("lightgrey")) {
            rtf.print("\\red192\\green192\\blue192;");
        } else if (model2.backcolor.equalsIgnoreCase("lightpurple")) {
            rtf.print("\\red255\\green0\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("lightblue")) {
            rtf.print("\\red0\\green0\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("lightred")) {
            rtf.print("\\red255\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("lightgreen")) {
            rtf.print("\\red0\\green255\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("white")) {
            rtf.print("\\red255\\green255\\blue255;");
        } else {
            StringTokenizer str = new StringTokenizer(model2.backcolor, ",");
            while (str.hasMoreTokens()) {
                rtf.print("\\" + str.nextToken());
            }
            rtf.print(";");
        }
    }

    private void createRTFHeader(PrintWriter rtf) {
        rtf.print("{");
        rtf.print("\\rtf1");
        rtf.print("\\ainsi");
        rtf.print("\\deff0");
        rtf.print("{");
        rtf.print("\\fonttbl");
        this.section_title_model.fontNumber = "0";
        this.createFontEntry(this.section_title_model, rtf);
        this.section_id_model.fontNumber = "1";
        this.createFontEntry(this.section_id_model, rtf);
        this.summary_title_model.fontNumber = "2";
        this.createFontEntry(this.summary_title_model, rtf);
        this.summary_entry_name_model.fontNumber = "3";
        this.createFontEntry(this.summary_entry_name_model, rtf);
        this.summary_entry_desc_model.fontNumber = "4";
        this.createFontEntry(this.summary_entry_desc_model, rtf);
        this.section_hierarchy_model.fontNumber = "5";
        this.createFontEntry(this.section_hierarchy_model, rtf);
        this.section_desc_model.fontNumber = "6";
        this.createFontEntry(this.section_desc_model, rtf);
        this.detail_title_model.fontNumber = "7";
        this.createFontEntry(this.detail_title_model, rtf);
        this.detail_desc_model.fontNumber = "8";
        this.createFontEntry(this.detail_desc_model, rtf);
        this.detail_comment_model.fontNumber = "9";
        this.createFontEntry(this.detail_comment_model, rtf);
        this.detail_id_model.fontNumber = "10";
        this.createFontEntry(this.detail_id_model, rtf);
        this.detail_java_model.fontNumber = "11";
        this.createFontEntry(this.detail_java_model, rtf);
        this.detail_highlight_model.fontNumber = "12";
        this.createFontEntry(this.detail_highlight_model, rtf);
        this.summary_inher_title_model.fontNumber = "13";
        this.createFontEntry(this.summary_inher_title_model, rtf);
        this.summary_inher_desc_model.fontNumber = "14";
        this.createFontEntry(this.summary_inher_desc_model, rtf);
        this.summary_inher_list_model.fontNumber = "15";
        this.createFontEntry(this.summary_inher_list_model, rtf);
        this.header_model.fontNumber = "16";
        this.createFontEntry(this.header_model, rtf);
        this.footer_model.fontNumber = "17";
        this.createFontEntry(this.footer_model, rtf);
        this.footer_model.fontNumber = "18";
        this.createFontEntry(this.title_model, rtf);
        rtf.print("}");
        rtf.print("{");
        rtf.print("\\colortbl;");
        this.section_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_title_model, rtf);
        this.section_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_title_model, rtf);
        this.section_id_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_id_model, rtf);
        this.section_id_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_id_model, rtf);
        this.section_hierarchy_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_hierarchy_model, rtf);
        this.section_hierarchy_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_hierarchy_model, rtf);
        this.section_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_desc_model, rtf);
        this.section_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_desc_model, rtf);
        this.summary_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_title_model, rtf);
        this.summary_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_title_model, rtf);
        this.summary_entry_name_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_entry_name_model, rtf);
        this.summary_entry_name_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_entry_name_model, rtf);
        this.summary_entry_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_entry_desc_model, rtf);
        this.summary_entry_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_entry_desc_model, rtf);
        this.summary_inher_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_title_model, rtf);
        this.summary_inher_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_title_model, rtf);
        this.summary_inher_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_desc_model, rtf);
        this.summary_inher_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_desc_model, rtf);
        this.summary_inher_list_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_list_model, rtf);
        this.summary_inher_list_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_list_model, rtf);
        this.detail_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_title_model, rtf);
        this.detail_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_title_model, rtf);
        this.detail_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_desc_model, rtf);
        this.detail_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_desc_model, rtf);
        this.detail_comment_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_comment_model, rtf);
        this.detail_comment_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_comment_model, rtf);
        this.detail_id_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_id_model, rtf);
        this.detail_id_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_id_model, rtf);
        this.detail_java_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_java_model, rtf);
        this.detail_java_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_java_model, rtf);
        this.detail_highlight_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_highlight_model, rtf);
        this.detail_highlight_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_highlight_model, rtf);
        this.header_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.header_model, rtf);
        this.header_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.header_model, rtf);
        this.footer_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.footer_model, rtf);
        this.footer_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.footer_model, rtf);
        this.title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.title_model, rtf);
        this.title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.title_model, rtf);
        rtf.print("}");
    }

    private String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    private String fullname(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            v.addElement(obj2.name());
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (IdlDoc.usePrefix && obj.getPrefix() != null) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + this.inversedPrefix(obj.getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String translateType(IdlObject obj, String desc, String name, boolean write, IdlObject current) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        desc = desc + "void";
                        break;
                    }
                    case 34: {
                        desc = desc + "float";
                        break;
                    }
                    case 30: {
                        desc = desc + "double";
                        break;
                    }
                    case 47: {
                        desc = desc + "short";
                        break;
                    }
                    case 66: {
                        desc = desc + "unsigned short";
                        break;
                    }
                    case 38: {
                        desc = desc + "long";
                        break;
                    }
                    case 65: {
                        desc = desc + "unsigned long";
                        break;
                    }
                    case 73: {
                        desc = desc + "long long";
                        break;
                    }
                    case 74: {
                        desc = desc + "unsigned long long";
                        break;
                    }
                    case 26: {
                        desc = desc + "char";
                        break;
                    }
                    case 71: {
                        desc = desc + "wchar";
                        break;
                    }
                    case 24: {
                        desc = desc + "boolean";
                        break;
                    }
                    case 41: {
                        desc = desc + "octet";
                        break;
                    }
                    case 22: {
                        desc = desc + "any";
                        break;
                    }
                    case 70: {
                        desc = desc + "CORBA::TypeCode";
                        break;
                    }
                    case 40: {
                        desc = desc + "Object";
                        break;
                    }
                    case 88: {
                        desc = desc + "valuebase";
                    }
                }
                break;
            }
            case 26: {
                desc = desc + "fixed";
                break;
            }
            case 5: {
                desc = desc + "string";
                break;
            }
            case 6: {
                desc = desc + "wstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 28: 
            case 33: {
                desc = desc + "{" + this.getModel(this.detail_highlight_model) + this.fullname(obj) + "}";
                break;
            }
            case 13: {
                obj.reset();
                this.translateType(obj.current(), desc, name, write, current);
                break;
            }
            case 9: {
                desc = desc + "sequence<";
                desc = this.translateType(obj.current(), desc, name, false, current);
                desc = desc + ">";
                break;
            }
            case 24: {
                desc = this.translateType(obj.current(), desc, name + "[" + ((IdlArray)obj).getDimension() + "]", false, current);
                if (obj.current().kind() != 24) {
                    desc = desc + " " + name;
                    desc = desc + "[" + ((IdlArray)obj).getDimension() + "]";
                }
                return desc;
            }
            case 10: {
                if (((IdlIdent)obj).internalObject().name().equals("TypeCode")) {
                    desc = desc + "CORBA::TypeCode";
                    break;
                }
                desc = desc + "{" + this.getModel(this.detail_highlight_model) + this.fullname(((IdlIdent)obj).internalObject()) + "}";
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    desc = desc + this.fullname(obj);
                    break;
                }
                obj.reset();
                desc = this.translateType(obj.current(), desc, name, write, current);
            }
        }
        if (write) {
            desc = desc + " " + name;
        }
        return desc;
    }

    private String translateParameter(IdlObject obj, String desc) {
        IdlParam p = (IdlParam)obj;
        p.reset();
        switch (p.param_attr()) {
            case 0: {
                desc = desc + "in ";
                break;
            }
            case 1: {
                desc = desc + "out ";
                break;
            }
            case 2: {
                desc = desc + "inout ";
            }
        }
        return this.translateType(p.current(), desc, p.name(), true, obj);
    }

    private String getJavaName(IdlObject obj) {
        String desc = "";
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        desc = "void";
                        break;
                    }
                    case 34: {
                        desc = "float";
                        break;
                    }
                    case 30: {
                        desc = "double";
                        break;
                    }
                    case 47: {
                        desc = "short";
                        break;
                    }
                    case 66: {
                        desc = "short";
                        break;
                    }
                    case 38: {
                        desc = "int";
                        break;
                    }
                    case 65: {
                        desc = "int";
                        break;
                    }
                    case 73: {
                        desc = "long";
                        break;
                    }
                    case 74: {
                        desc = "long";
                        break;
                    }
                    case 26: {
                        desc = "char";
                        break;
                    }
                    case 71: {
                        desc = "char";
                        break;
                    }
                    case 24: {
                        desc = "boolean";
                        break;
                    }
                    case 41: {
                        desc = "byte";
                        break;
                    }
                    case 22: {
                        desc = "org.omg.CORBA.Any";
                        break;
                    }
                    case 70: {
                        desc = "org.omg.CORBA.TypeCode";
                        break;
                    }
                    case 40: {
                        desc = "org.omg.CORBA.Object";
                        break;
                    }
                    case 88: {
                        desc = "org.omg.CORBA.ValueBase";
                    }
                }
                break;
            }
            case 26: {
                desc = "java.lang.BidDecimal";
                break;
            }
            case 5: {
                desc = "java.lang.String";
                break;
            }
            case 6: {
                desc = "java.lang.String";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 28: 
            case 29: {
                desc = this.fullname(obj);
                break;
            }
            case 13: {
                obj.reset();
                desc = this.getJavaName(obj.current());
                break;
            }
            case 9: 
            case 24: {
                desc = this.getJavaName(obj.current());
                desc = desc + "[]";
                break;
            }
            case 7: {
                desc = this.fullname(obj) + ".value";
                break;
            }
            case 10: {
                if (((IdlIdent)obj).internalObject().name().equals("TypeCode")) {
                    desc = "org.omg.CORBA.TypeCode";
                    break;
                }
                desc = this.getJavaName(((IdlIdent)obj).internalObject());
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    desc = this.fullname(obj);
                    break;
                }
                obj.reset();
                desc = this.getJavaName(obj.current());
            }
        }
        return desc;
    }

    private void createRTFFooter(PrintWriter rtf) {
        rtf.print("}");
    }

    private void write_index_entry(String entry, String sub, String see, PrintWriter rtf) {
        rtf.print("{\\xe {\\v " + entry + "}");
        if (sub != null) {
            rtf.print("{\\rxe " + sub + "}");
        }
        if (see != null) {
            rtf.print("{\\txe see " + see + "}");
        }
        rtf.print("}");
    }

    private void write_section_title(String title, IdlObject obj, PrintWriter rtf) {
        rtf.print("{");
        this.write_model(this.section_title_model, rtf);
        rtf.println(title);
        rtf.println("\\par }");
        this.write_index_entry(this.fullname(obj), null, null, rtf);
        rtf.println("{\\pard}");
        rtf.print("{");
        this.write_model(this.section_id_model, rtf);
        rtf.println("\\par");
        rtf.println("CORBA ID = " + obj.getId());
        rtf.println("\\par }");
        rtf.println("{\\par\\pard}");
    }

    private boolean is_deprecated(IdlObject obj) {
        IdlComment comment = obj.getComment();
        if (comment != null) {
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                if (sections[i].kind().value() == 6) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void write_detail_title(String title, IdlObject obj, PrintWriter rtf) {
        rtf.print("{\\li567");
        this.write_model(this.detail_title_model, rtf);
        rtf.println(title);
        rtf.println("\\par }");
        this.write_index_entry(obj.name(), null, this.fullname(obj.upper()), rtf);
        rtf.println("{\\pard}");
        rtf.print("{");
        this.write_model(this.detail_id_model, rtf);
        rtf.println("CORBA ID = " + obj.getId());
        rtf.println("\\par }");
        rtf.println("{\\pard}");
        rtf.print("{");
        this.write_model(this.detail_java_model, rtf);
        rtf.println("JAVA NAME = " + this.getJavaName(obj));
        rtf.println("\\par }");
        rtf.println("{\\par}\\pard");
    }

    private void write_smalldetail_title(String title, IdlObject obj, PrintWriter rtf) {
        rtf.print("{\\li567");
        this.write_model(this.detail_title_model, rtf);
        rtf.println(title);
        rtf.println("\\par }");
        if (obj.upper().upper() != null) {
            this.write_index_entry(obj.name(), null, this.fullname(obj.upper()), rtf);
        }
        rtf.println("{\\pard}");
        rtf.print("{");
        this.write_model(this.detail_id_model, rtf);
        rtf.println("DETAILS AT = " + this.fullname(obj));
        rtf.println("\\par }");
        rtf.println("{\\par}\\pard");
    }

    private IdlObject[] sort_description_by_name(Vector list) {
        Vector<IdlObject> sortedLabels = new Vector<IdlObject>();
        int j = 0;
        while (j < list.size()) {
            IdlObject obj = (IdlObject)list.elementAt(j);
            boolean inserted = false;
            int i = 0;
            while (i < sortedLabels.size()) {
                if (this.fullname(obj).toLowerCase().compareTo(this.fullname((IdlObject)sortedLabels.elementAt(i)).toLowerCase()) < 0) {
                    sortedLabels.insertElementAt(obj, i);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                sortedLabels.addElement(obj);
            }
            ++j;
        }
        IdlObject[] ret = new IdlObject[sortedLabels.size()];
        int i = 0;
        while (i < sortedLabels.size()) {
            ret[i] = (IdlObject)sortedLabels.elementAt(i);
            ++i;
        }
        return ret;
    }

    private void sort_type_content(IdlObject obj, content c, boolean limit) {
        if (c == null) {
            c = new content();
        }
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        c._module.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 15: {
                        c._interface.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 28: {
                        c._valuetype.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 27: {
                        c._valuebox.addElement(obj.current());
                        break;
                    }
                    case 14: {
                        c._exception.addElement(obj.current());
                        break;
                    }
                    case 3: {
                        c._struct.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 4: {
                        c._union.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 2: {
                        c._enum.addElement(obj.current());
                        break;
                    }
                    case 13: {
                        c._typedef.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 7: {
                        c._const.addElement(obj.current());
                        break;
                    }
                    case 25: {
                        c._native.addElement(obj.current());
                        break;
                    }
                    case 16: {
                        c._operation.addElement(obj.current());
                        break;
                    }
                    case 17: {
                        c._attribute.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 29: {
                        c._member.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 30: {
                        c._factory.addElement(obj.current());
                    }
                }
            }
            obj.next();
        }
    }

    private content get_sorted_content(IdlObject obj, boolean limit) {
        content ret = new content();
        this.sort_type_content(obj, ret, limit);
        ret._sorted_module = ret._module.size() != 0 ? this.sort_description_by_name(ret._module) : new IdlObject[0];
        ret._sorted_interface = ret._interface.size() != 0 ? this.sort_description_by_name(ret._interface) : new IdlObject[0];
        ret._sorted_valuetype = ret._valuetype.size() != 0 ? this.sort_description_by_name(ret._valuetype) : new IdlObject[0];
        ret._sorted_valuebox = ret._valuebox.size() != 0 ? this.sort_description_by_name(ret._valuebox) : new IdlObject[0];
        ret._sorted_exception = ret._exception.size() != 0 ? this.sort_description_by_name(ret._exception) : new IdlObject[0];
        ret._sorted_struct = ret._struct.size() != 0 ? this.sort_description_by_name(ret._struct) : new IdlObject[0];
        ret._sorted_union = ret._union.size() != 0 ? this.sort_description_by_name(ret._union) : new IdlObject[0];
        ret._sorted_enum = ret._enum.size() != 0 ? this.sort_description_by_name(ret._enum) : new IdlObject[0];
        ret._sorted_typedef = ret._typedef.size() != 0 ? this.sort_description_by_name(ret._typedef) : new IdlObject[0];
        ret._sorted_const = ret._const.size() != 0 ? this.sort_description_by_name(ret._const) : new IdlObject[0];
        ret._sorted_native = ret._native.size() != 0 ? this.sort_description_by_name(ret._native) : new IdlObject[0];
        ret._sorted_operation = ret._operation.size() != 0 ? this.sort_description_by_name(ret._operation) : new IdlObject[0];
        ret._sorted_attribute = ret._attribute.size() != 0 ? this.sort_description_by_name(ret._attribute) : new IdlObject[0];
        ret._sorted_member = ret._member.size() != 0 ? this.sort_description_by_name(ret._member) : new IdlObject[0];
        ret._sorted_factory = ret._factory.size() != 0 ? this.sort_description_by_name(ret._factory) : new IdlObject[0];
        return ret;
    }

    private String get_summary_description(IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null && (description = comment.get_description()) != null) {
            if (description.indexOf(".") != -1) {
                return description.substring(0, description.indexOf(".") + 1);
            }
            if (description.indexOf("\n\n") != -1) {
                return description.substring(0, description.indexOf("\n\n") + 1);
            }
            return description;
        }
        return "";
    }

    private void write_begin_table(String caption, PrintWriter rtf) {
        rtf.print("\\li709 ");
        rtf.print("\\trowd ");
        rtf.print("\\trgaph70\\trrh296\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_title_model, rtf);
        this.write_cell_color(this.summary_title_model, rtf);
        rtf.print("\\cellx9498\\pard \\intbl");
        rtf.print("{");
        this.write_cell_model(this.summary_title_model, rtf);
        rtf.print(caption);
        rtf.print("\\cell}");
        rtf.print("{\\row}");
    }

    private void write_begin_table_inheritance(String caption, PrintWriter rtf) {
        rtf.print("\\li709 ");
        rtf.print("\\trowd ");
        rtf.print("\\trgaph70\\trrh296\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_inher_title_model, rtf);
        this.write_cell_color(this.summary_inher_title_model, rtf);
        rtf.print("\\cellx9498\\pard \\intbl");
        rtf.print("{");
        this.write_cell_model(this.summary_inher_title_model, rtf);
        rtf.print(caption);
        rtf.print("\\cell}");
        rtf.print("{\\row}");
    }

    private void write_table_entry(String entry, String desc, PrintWriter rtf) {
        rtf.print("\\li709 ");
        rtf.print("\\trowd ");
        rtf.print("\\trgaph70\\trrh286\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_entry_name_model, rtf);
        this.write_cell_color(this.summary_entry_name_model, rtf);
        rtf.print(" \\cellx2693\\clvertalt ");
        this.write_cell_border(this.summary_entry_desc_model, rtf);
        this.write_cell_color(this.summary_entry_desc_model, rtf);
        rtf.print("\\cellx9498\\pard \\fi-72\\li72\\intbl");
        rtf.print("{");
        this.write_cell_model(this.summary_entry_name_model, rtf);
        rtf.print(entry);
        rtf.print("\\cell} ");
        rtf.print("\\fi-72\\li72\\intbl {");
        this.write_cell_model(this.summary_entry_desc_model, rtf);
        rtf.print(desc);
        rtf.print("\\cell}");
        rtf.print("{\\row}");
    }

    private void write_one_cell(String desc, PrintWriter rtf) {
        rtf.print("\\li709 ");
        rtf.print("\\trowd ");
        rtf.print("\\trgaph70\\trrh286\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_inher_list_model, rtf);
        this.write_cell_color(this.summary_inher_list_model, rtf);
        rtf.print("\\cellx9498\\pard \\intbl");
        rtf.print("{");
        this.write_cell_model(this.summary_inher_list_model, rtf);
        rtf.print(desc);
        rtf.print("\\cell}");
        rtf.print("{\\row}");
    }

    private void write_end_table(PrintWriter rtf) {
        rtf.println("\\pard \\plain { \\par \\pard }");
    }

    private void translateSubTypeDetails(IdlObject ref, IdlObject[] list, PrintWriter output, String name) {
        this.write_begin_table(name, output);
        this.write_end_table(output);
        int i = 0;
        while (i < list.length) {
            switch (list[i].kind()) {
                case 27: {
                    this.translateValueBox(list[i], output);
                    break;
                }
                case 14: {
                    this.translateException(list[i], output);
                    break;
                }
                case 3: {
                    this.translateStruct(list[i], output);
                    break;
                }
                case 4: {
                    this.translateUnion(list[i], output);
                    break;
                }
                case 2: {
                    this.translateEnum(list[i], output);
                    break;
                }
                case 13: {
                    this.translateTypeDef(list[i], output);
                    break;
                }
                case 7: {
                    this.translateConstant(list[i], output);
                    break;
                }
                case 25: {
                    this.translateNative(list[i], output);
                    break;
                }
                case 16: {
                    this.translateOperation(list[i], output);
                    break;
                }
                case 17: {
                    this.translateAttribute(list[i], output);
                    break;
                }
                case 29: {
                    this.translateStateMember(list[i], output);
                    break;
                }
                case 30: {
                    this.translateFactory(list[i], output);
                    break;
                }
                case 15: {
                    this.translateInterfaceDetail(list[i], output);
                    break;
                }
                case 1: {
                    this.translateModuleDetail(list[i], output);
                    break;
                }
                case 28: {
                    this.translateValueDetail(list[i], output);
                }
            }
            ++i;
        }
    }

    private void translateSubTypeSummary(IdlObject ref, IdlObject[] list, PrintWriter rtf, String name) {
        this.write_begin_table(name, rtf);
        int i = 0;
        while (i < list.length) {
            String desc = this.get_summary_description(list[i]);
            if (this.is_deprecated(list[i])) {
                desc = "{\b deprecated} - " + desc;
            }
            this.write_table_entry(list[i].name(), desc, rtf);
            ++i;
        }
        this.write_end_table(rtf);
    }

    public void translateContentTable(IdlObject obj, PrintWriter output, int type) {
        content c = this.get_sorted_content(obj, true);
        if (type == 1 || type == 3) {
            if (c._sorted_module.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_module, output, "Module Summary");
            }
            if (c._sorted_interface.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_interface, output, "Interface Summary");
            }
            if (c._sorted_valuetype.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_valuetype, output, "ValueType Summary");
            }
            if (c._sorted_valuebox.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_valuebox, output, "ValueBox Summary");
            }
            if (c._sorted_exception.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_exception, output, "Exception Summary");
            }
            if (c._sorted_struct.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_struct, output, "Struct Summary");
            }
            if (c._sorted_union.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_union, output, "Union Summary");
            }
            if (c._sorted_enum.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_enum, output, "Enum Summary");
            }
            if (c._sorted_typedef.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_typedef, output, "TypeDef Summary");
            }
            if (c._sorted_const.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_const, output, "Const Summary");
            }
            if (c._sorted_native.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_native, output, "Native Summary");
            }
            if (c._sorted_operation.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_operation, output, "Operation Summary");
            }
            if (c._sorted_attribute.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_attribute, output, "Attribute Summary");
            }
            if (c._sorted_member.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_member, output, "Member Summary");
            }
            if (c._sorted_factory.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_factory, output, "Factory Summary");
            }
        }
        if (type == 2 || type == 3) {
            if (c._sorted_module.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_module, output, "Module Details");
            }
            if (c._sorted_interface.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_interface, output, "Interface Details");
            }
            if (c._sorted_valuetype.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_valuetype, output, "ValueType Details");
            }
            if (c._sorted_valuebox.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_valuebox, output, "ValueBox Details");
            }
            if (c._sorted_exception.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_exception, output, "Exception Details");
            }
            if (c._sorted_struct.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_struct, output, "Struct Details");
            }
            if (c._sorted_union.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_union, output, "Union Details");
            }
            if (c._sorted_enum.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_enum, output, "Enum Details");
            }
            if (c._sorted_typedef.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_typedef, output, "TypeDef Details");
            }
            if (c._sorted_const.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_const, output, "Const Details");
            }
            if (c._sorted_native.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_native, output, "Native Details");
            }
            if (c._sorted_operation.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_operation, output, "Operation Details");
            }
            if (c._sorted_attribute.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_attribute, output, "Attribute Details");
            }
            if (c._sorted_member.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_member, output, "Member Details");
            }
            if (c._sorted_factory.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_factory, output, "Factory Details");
            }
        }
    }

    private String get_description(IdlObject obj) {
        IdlComment comment = obj.getComment();
        if (comment != null && comment.get_description() != null) {
            return comment.get_description();
        }
        return "";
    }

    private IdlCommentSection[] get_sections(IdlCommentSection[] src, int section_type) {
        Vector<IdlCommentSection> list = new Vector<IdlCommentSection>();
        int i = 0;
        while (i < src.length) {
            if (src[i].kind().value() == section_type) {
                list.addElement(src[i]);
            }
            ++i;
        }
        IdlCommentSection[] ret = new IdlCommentSection[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            ret[i2] = (IdlCommentSection)list.elementAt(i2);
            ++i2;
        }
        return ret;
    }

    private void translateHierarchy(IdlObject obj, PrintWriter rtf) {
        Vector<IdlObject> v = new Vector<IdlObject>();
        IdlObject obj2 = obj;
        while (obj2 != null) {
            switch (obj2.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    v.addElement(obj2);
                }
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
        }
        rtf.print("{\\li709 ");
        this.write_model(this.section_hierarchy_model, rtf);
        if (v.size() > 1) {
            String dec = "";
            int i = v.size() - 1;
            while (i >= 0) {
                dec = dec + "   ";
                if (i == 0) {
                    rtf.println("{\\b " + this.fullname((IdlObject)v.elementAt(i)) + "}\\par");
                } else {
                    rtf.println(this.fullname((IdlObject)v.elementAt(i)) + "\\par");
                }
                if (i != 0) {
                    rtf.println(dec + "|\\par");
                    rtf.print(dec + "+--");
                }
                --i;
            }
            rtf.print("\\par");
        }
        rtf.println("} \\pard\\plain ");
    }

    private String removeTab(String str) {
        byte[] b = new byte[str.length()];
        int j = 0;
        int i = 0;
        while (i < b.length) {
            if (str.charAt(i) != '\t') {
                b[j++] = (byte)str.charAt(i);
            }
            ++i;
        }
        return new String(b, 0, j);
    }

    private void write_section(IdlCommentSection[] sections, int section_type, String section_title, PrintWriter output, boolean highlight_first) {
        IdlCommentSection[] section = this.get_sections(sections, section_type);
        String desc = "";
        String first = "";
        if (section.length != 0) {
            output.println("\\li800 {\\b " + section_title + "\\par}");
            output.println("\\li1000 {");
            int i = 0;
            while (i < section.length) {
                desc = section[i].get_description().trim();
                if (highlight_first) {
                    output.print("{");
                    this.write_model(this.detail_highlight_model, output);
                    int idx = desc.indexOf(" ");
                    int idx2 = desc.indexOf("\t");
                    if (idx == -1 && idx2 != -1) {
                        idx = idx2;
                    } else if (idx2 != -1 && idx2 < idx) {
                        idx = idx2;
                    }
                    if (idx != -1) {
                        first = desc.substring(0, idx);
                        desc = desc.substring(idx + 1);
                        output.print(first);
                    }
                    output.print("} - ");
                }
                output.println(this.removeTab(desc) + "\\par");
                ++i;
            }
            output.println("}{\\par}\\pard");
        }
    }

    private void write_description(IdlObject obj, PrintWriter output, model model2) {
        IdlComment comment = obj.getComment();
        output.print("{\\li567");
        this.write_model(model2, output);
        output.println(this.get_description(obj).trim() + "\\par\\par");
        if (comment != null) {
            IdlCommentSection[] sections = comment.get_sections();
            this.write_section(sections, 3, "Parameter", output, true);
            this.write_section(sections, 4, "Return", output, false);
            this.write_section(sections, 1, "Exception", output, true);
            this.write_section(sections, 5, "See", output, true);
            this.write_section(sections, 6, "Deprecated", output, false);
        }
        output.println("\\par} \\pard\\plain");
    }

    private void translateEnum(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        IdlEnumMember member = null;
        output.print("enum " + obj.name() + "\\par");
        output.print("\\{\\par");
        output.println("{\\li800");
        obj.reset();
        while (!obj.end()) {
            member = (IdlEnumMember)obj.current();
            output.print(member.name());
            obj.next();
            if (!obj.end()) {
                output.print(",");
            }
            output.println("\\par");
        }
        output.print("}");
        output.print("\\}\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateStruct(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        IdlStructMember member = null;
        output.print("struct " + obj.name() + "\\par");
        output.print("\\{\\par");
        output.println("{\\li800");
        obj.reset();
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            member.reset();
            output.print(this.translateType(member.current(), "", member.name(), true, obj));
            obj.next();
            output.print(";");
            output.println("\\par");
        }
        output.print("}");
        output.print("\\}\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateException(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        IdlStructMember member = null;
        output.print("exception " + obj.name() + "\\par");
        output.print("\\{\\par");
        output.println("{\\li800");
        obj.reset();
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            member.reset();
            output.print(this.translateType(member.current(), "", member.name(), true, obj));
            obj.next();
            output.print(";");
            output.println("\\par");
        }
        output.print("}");
        output.print("\\}\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateUnion(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        IdlUnionMember member = null;
        obj.reset();
        member = (IdlUnionMember)obj.current();
        member.reset();
        output.print("union " + obj.name() + " switch ( " + this.translateType(member.current(), "", member.name(), false, obj) + " )" + "\\par");
        output.print("\\{\\par");
        int default_index = ((IdlUnion)obj).index();
        int index = 0;
        obj.next();
        while (!obj.end()) {
            member = (IdlUnionMember)obj.current();
            output.print("\\li800");
            output.print("{");
            member.reset();
            if (index == default_index) {
                output.print("default : \\par }");
            } else {
                output.print("case " + this.adaptExpression(member.getExpression()) + ": \\par }");
            }
            output.println("\\li1200 {");
            output.print(this.translateType(member.current(), "", member.name(), true, obj));
            obj.next();
            output.print(";");
            output.print("\\par }");
            ++index;
        }
        output.print("\\li567 \\}\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private String correctIdentifier(String expr) {
        String correct_identifier = "";
        int index = 0;
        int last_index = 0;
        Vector<String> list = new Vector<String>();
        int i = 0;
        String item = null;
        while ((index = expr.indexOf(".", last_index)) != last_index) {
            if (index == -1) {
                item = expr.substring(last_index, expr.length());
                list.addElement(item);
                break;
            }
            item = expr.substring(last_index, index);
            list.addElement(item);
            last_index = index + 1;
        }
        i = 0;
        while (i < list.size()) {
            item = (String)list.elementAt(i);
            if (this._root.isDefined(item, false)) break;
            ++i;
        }
        int j = i;
        while (j < list.size()) {
            correct_identifier = correct_identifier + (String)list.elementAt(j);
            if (j + 1 < list.size()) {
                correct_identifier = correct_identifier + "::";
            }
            ++j;
        }
        return correct_identifier;
    }

    /*
     * Unable to fully structure code
     */
    private String adaptExpression(String expr) {
        tmp = new char[500];
        adapt_expr = "";
        index = 0;
        tmp_index = 0;
        while (index != expr.length()) {
            block7: {
                block8: {
                    if (!Character.isDigit(expr.charAt(index))) break block7;
                    if (expr.charAt(index) != '0' || index + 1 >= expr.length() || expr.charAt(index + 1) != 'X' && expr.charAt(index + 1) != 'x') ** GOTO lbl15
                    tmp[tmp_index++] = expr.charAt(index++);
                    tmp[tmp_index++] = expr.charAt(index++);
                    while (index < expr.length() && (Character.isDigit(expr.charAt(index)) || expr.charAt(index) >= 'A' && expr.charAt(index) <= 'F' || expr.charAt(index) >= 'a' && expr.charAt(index) <= 'f')) {
                        tmp[tmp_index++] = expr.charAt(index++);
                    }
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        tmp[tmp_index++] = expr.charAt(index++);
lbl15:
                        // 2 sources

                        ** while (index < expr.length() && (Character.isDigit((char)expr.charAt((int)index)) || expr.charAt((int)index) == '.'))
                    }
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + new String(tmp, 0, tmp_index);
                tmp_index = 0;
                continue;
            }
            if (Character.isLetter(expr.charAt(index))) {
                while (index < expr.length() && (Character.isLetterOrDigit(expr.charAt(index)) || expr.charAt(index) == '.' || expr.charAt(index) == '_')) {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + this.correctIdentifier(new String(tmp, 0, tmp_index));
                tmp_index = 0;
                continue;
            }
            if (expr.charAt(index) == '\"') {
                ++index;
                while (expr.charAt(index) != '\"') {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + "\"" + new String(tmp, 0, tmp_index) + "\"";
                tmp_index = 0;
                ++index;
                continue;
            }
            tmp[0] = expr.charAt(index++);
            tmp[1] = '\u0000';
            adapt_expr = adapt_expr + new String(tmp, 0, 1);
        }
        return adapt_expr;
    }

    public void translateFactory(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("factory " + obj.name() + "(");
        obj.reset();
        while (!obj.end()) {
            output.print("in ");
            obj.current().reset();
            output.print(this.translateType(obj.current().current(), "", obj.current().name(), true, obj));
            obj.next();
            if (obj.end()) continue;
            output.print(", ");
        }
        output.print(");");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    public void translateStateMember(IdlObject obj, PrintWriter output) {
        IdlStateMember member = null;
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        member = (IdlStateMember)obj;
        member.reset();
        if (member.public_member()) {
            output.print("public ");
        } else {
            output.print("private ");
        }
        output.print(this.translateType(member.current(), "", member.name(), true, obj));
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateConstant(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("Const ");
        obj.reset();
        String desc = this.translateType(obj.current(), "", obj.name(), false, obj);
        output.print(desc + " " + obj.name() + " = " + this.adaptExpression(((IdlConst)obj).expression()) + ";\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateTypeDef(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("typedef ");
        obj.reset();
        String desc = this.translateType(obj.current(), "", obj.name(), true, obj);
        output.print(desc + ";\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateValueBox(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("valuetype " + obj.name());
        obj.reset();
        String desc = this.translateType(obj.current(), "", obj.name(), false, obj);
        output.print(" " + desc + ";\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateNative(IdlObject obj, PrintWriter output) {
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("native " + obj.name() + "\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateInterfaceDetail(IdlObject obj, PrintWriter rtf) {
        IdlInterface itf = (IdlInterface)obj;
        this.write_smalldetail_title(obj.name(), obj, rtf);
        rtf.print("{\\li567");
        this.write_model(this.detail_desc_model, rtf);
        if (itf.abstract_interface()) {
            rtf.print("abstract ");
        }
        rtf.println("interface " + obj.name());
        Vector inheritance = itf.getInheritance();
        if (inheritance.size() != 0) {
            rtf.print(" :\\par");
            int i = 0;
            while (i < inheritance.size()) {
                rtf.print("\\li800 { " + this.fullname((IdlInterface)inheritance.elementAt(i)));
                if (i + 1 < inheritance.size()) {
                    rtf.print(",");
                }
                rtf.println("\\par}");
                ++i;
            }
        } else {
            rtf.print("\\par");
        }
        rtf.println("}{\\par} \\pard");
        this.write_description(obj, rtf, this.detail_comment_model);
    }

    private void translateModuleDetail(IdlObject obj, PrintWriter output) {
        this.write_smalldetail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        output.print("module " + obj.name() + "\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateValueDetail(IdlObject obj, PrintWriter rtf) {
        IdlValue itf = (IdlValue)obj;
        this.write_smalldetail_title(obj.name(), obj, rtf);
        rtf.print("{\\li567");
        this.write_model(this.detail_desc_model, rtf);
        if (itf.abstract_value()) {
            rtf.print("abstract ");
        }
        if (itf.custom_value()) {
            rtf.print("abstract ");
        }
        rtf.println("valuetype " + obj.name());
        Vector inheritance = itf.getInheritanceList();
        if (inheritance.size() != 0) {
            rtf.print(" :\\par");
            int i = 0;
            while (i < inheritance.size()) {
                rtf.print("\\li800 { ");
                if (((IdlValueInheritance)inheritance.elementAt(i)).truncatable_member()) {
                    rtf.print("truncatable ");
                }
                rtf.print(this.fullname((IdlInterface)inheritance.elementAt(i)));
                if (i + 1 < inheritance.size()) {
                    rtf.print(",");
                }
                rtf.println("\\par}");
                ++i;
            }
        } else {
            rtf.print("\\par");
        }
        rtf.println("}{\\par} \\pard");
        this.write_description(obj, rtf, this.detail_comment_model);
    }

    public void translateAttribute(IdlObject obj, PrintWriter output) {
        IdlAttribute attr = (IdlAttribute)obj;
        attr.reset();
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        if (attr.readOnly()) {
            output.print("readonly ");
        }
        output.print("attribute ");
        output.println(this.translateType(attr.current(), "", attr.name(), true, obj) + "\\par");
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    public void translateOperation(IdlObject obj, PrintWriter output) {
        IdlOp op = (IdlOp)obj;
        this.write_detail_title(obj.name(), obj, output);
        output.print("{\\li567");
        this.write_model(this.detail_desc_model, output);
        if (op.oneway()) {
            output.print("oneway ");
        }
        op.reset();
        output.print(this.translateType(op.current(), "", op.name(), false, obj));
        op.next();
        output.print(" " + op.name() + "(");
        while (!op.end()) {
            if (op.current().kind() != 19) break;
            output.print("\\par");
            output.print("\\li1000" + this.translateParameter(op.current(), ""));
            op.next();
            if (op.end() || op.current().kind() != 19) continue;
            output.print(", ");
        }
        output.print(")\\par");
        if (!op.end() && op.current().kind() == 20) {
            output.print("\\li800{raises (\\par}");
            IdlRaises raises = (IdlRaises)op.current();
            raises.reset();
            while (!raises.end()) {
                output.print("\\li1000 {" + this.fullname(raises.current()));
                raises.next();
                if (!raises.end()) {
                    output.print(", \\par}");
                    continue;
                }
                output.print(")\\par}");
            }
            op.next();
        }
        if (!op.end() && op.current().kind() == 21) {
            output.print("\\li800{");
            output.print("context (");
            IdlContext ctx = (IdlContext)op.current();
            Vector list = ctx.getValues();
            int index = 0;
            while (index < list.size()) {
                output.print("\"" + (String)list.elementAt(index) + "\"");
                if (index + 1 < list.size()) {
                    output.print(", ");
                }
                ++index;
            }
            output.print(")\\par}");
        }
        output.print("\\par } \\pard");
        this.write_description(obj, output, this.detail_comment_model);
    }

    private void translateModule(IdlObject obj, PrintWriter rtf) {
        this.write_section_title("Module " + this.fullname(obj), obj, rtf);
        this.translateHierarchy(obj, rtf);
        this.write_description(obj, rtf, this.section_desc_model);
        this.translateContentTable(obj, rtf, 3);
        rtf.println("{\\par} \\pard");
        this.translateDescription(obj, rtf);
    }

    public void translateSummary(String title, PrintWriter rtf) {
        rtf.print("{");
        this.write_model(this.title_model, rtf);
        rtf.print(title);
        rtf.print("\\par}{\\par\\par\\par}\\pard");
        this.translateContentTable(this._root, rtf, 3);
        rtf.print("{\\par\\par}\\pard");
    }

    private void translateInfo(PrintWriter rtf) {
        rtf.print("{");
        rtf.print("\\author IDL to RTF");
        rtf.println("}");
    }

    private void translateHeader(String header, PrintWriter rtf) {
        rtf.print("{\\header ");
        this.write_model(this.header_model, rtf);
        rtf.println("{" + header + "}{\\par } }");
    }

    private void translateFooter(String footer, PrintWriter rtf) {
        rtf.print("{\\footer");
        this.write_model(this.footer_model, rtf);
        rtf.println("{" + footer + "}{\\par } }");
    }

    private void translateInterface(IdlObject obj, PrintWriter rtf) {
        String desc = null;
        IdlInterface itf = (IdlInterface)obj;
        this.write_section_title("Interface " + this.fullname(obj), obj, rtf);
        this.translateHierarchy(obj, rtf);
        this.write_description(obj, rtf, this.section_desc_model);
        rtf.print("{\\li567");
        this.write_model(this.summary_inher_desc_model, rtf);
        if (itf.abstract_interface()) {
            rtf.print("abstract ");
        }
        rtf.println("interface " + obj.name());
        Vector inheritance = itf.getInheritance();
        if (inheritance.size() != 0) {
            rtf.print(" :\\par");
            int i = 0;
            while (i < inheritance.size()) {
                rtf.print("\\li800 { " + this.fullname((IdlInterface)inheritance.elementAt(i)));
                if (i + 1 < inheritance.size()) {
                    rtf.print(",");
                }
                rtf.println("\\par}");
                ++i;
            }
        } else {
            rtf.print("\\par");
        }
        rtf.println("}{\\par} \\pard");
        this.translateContentTable(obj, rtf, 1);
        IdlInterface inherit = null;
        if (inheritance.size() != 0) {
            int i = 0;
            while (i < inheritance.size()) {
                inherit = (IdlInterface)inheritance.elementAt(i);
                if (!inherit.included()) {
                    this.write_begin_table_inheritance("Attributes and operations inherited from " + this.fullname(inherit), rtf);
                    desc = "";
                    inherit.reset();
                    while (!inherit.end()) {
                        switch (inherit.current().kind()) {
                            case 16: 
                            case 17: {
                                if (!desc.equals("")) {
                                    desc = desc + ", ";
                                }
                                desc = desc + inherit.current().name();
                            }
                        }
                        inherit.next();
                    }
                    this.write_one_cell(desc, rtf);
                    this.write_end_table(rtf);
                }
                ++i;
            }
        }
        this.translateContentTable(obj, rtf, 2);
        rtf.println("{\\par} \\pard");
        this.translateDescription(obj, rtf);
    }

    private void translateValueType(IdlObject obj, PrintWriter rtf) {
        String desc = null;
        IdlValue itf = (IdlValue)obj;
        this.write_section_title("Valuetype " + this.fullname(obj), obj, rtf);
        this.translateHierarchy(obj, rtf);
        this.write_description(obj, rtf, this.section_desc_model);
        rtf.print("{\\li567");
        this.write_model(this.summary_inher_desc_model, rtf);
        if (itf.abstract_value()) {
            rtf.print("abstract ");
        }
        if (itf.custom_value()) {
            rtf.print("abstract ");
        }
        rtf.println("valuetype " + obj.name());
        Vector inheritance = itf.getInheritanceList();
        if (inheritance.size() != 0) {
            rtf.print(" :\\par");
            int i = 0;
            while (i < inheritance.size()) {
                rtf.print("\\li800 { ");
                if (((IdlValueInheritance)inheritance.elementAt(i)).truncatable_member()) {
                    rtf.print("truncatable ");
                }
                rtf.print(this.fullname((IdlInterface)inheritance.elementAt(i)));
                if (i + 1 < inheritance.size()) {
                    rtf.print(",");
                }
                rtf.println("\\par}");
                ++i;
            }
        } else {
            rtf.print("\\par");
        }
        rtf.println("}{\\par} \\pard");
        this.translateContentTable(obj, rtf, 1);
        IdlValue inherit = null;
        if (inheritance.size() != 0) {
            int i = 0;
            while (i < inheritance.size()) {
                inherit = ((IdlValueInheritance)inheritance.elementAt(i)).getValue();
                if (!inherit.included()) {
                    this.write_begin_table_inheritance("Members, attributes and operations inherited from " + this.fullname(inherit), rtf);
                    desc = "";
                    inherit.reset();
                    while (!inherit.end()) {
                        switch (inherit.current().kind()) {
                            case 16: 
                            case 17: 
                            case 29: {
                                if (!desc.equals("")) {
                                    desc = desc + ", ";
                                }
                                desc = desc + inherit.current().name();
                            }
                        }
                        inherit.next();
                    }
                    this.write_one_cell(desc, rtf);
                    this.write_end_table(rtf);
                }
                ++i;
            }
        }
        this.translateContentTable(obj, rtf, 2);
        rtf.println("{\\par} \\pard");
        this.translateDescription(obj, rtf);
    }

    private void translateDescription(IdlObject obj, PrintWriter rtf) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translateModule(obj.current(), rtf);
                        break;
                    }
                    case 28: {
                        this.translateValueType(obj.current(), rtf);
                        break;
                    }
                    case 15: {
                        this.translateInterface(obj.current(), rtf);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateToRTF(IdlObject obj, String fileName, String title, String header, String footer) {
        File file = null;
        this._root = obj;
        file = IdlDoc.outdir != null ? new File(IdlDoc.outdir + File.separatorChar + fileName) : new File(fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (IOException ex) {
            System.out.println("Error : Unable to create " + file.getAbsolutePath());
            System.exit(0);
        }
        PrintWriter rtfFile = new PrintWriter(out, true);
        this.loadStyleSheet();
        this.createRTFHeader(rtfFile);
        this.translateInfo(rtfFile);
        this.translateHeader(header, rtfFile);
        this.translateFooter(footer, rtfFile);
        this.translateSummary(title, rtfFile);
        this.translateDescription(obj, rtfFile);
        this.createRTFFooter(rtfFile);
        try {
            rtfFile.close();
            out.close();
        }
        catch (IOException ex) {}
    }
}

