/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.NbProblemDisplayer;
import org.netbeans.core.ui.ModuleEnableDisablePanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListener;

public final class ModuleBean
implements Runnable,
PropertyChangeListener {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.ui.ModuleBean");
    private final Module module;
    private String codeName;
    private String codeNameBase;
    private String specVers;
    private String implVers;
    private String[] provides;
    private File jar;
    private boolean enabled;
    private boolean reloadable;
    private boolean autoscan;
    private boolean autoload;
    private boolean eager;
    private boolean problematic;
    private String[] problemDescriptions;
    private String displayName;
    private String shortDescription;
    private String longDescription;
    private String category;
    private String classpath;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    private ModuleBean(Module m) {
        this.module = m;
        this.loadProps();
        this.module.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)((Object)this.module)));
    }

    public Module getModule() {
        return this.module;
    }

    private void loadProps() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("loadProps: module=" + (Object)((Object)this.module));
        if (!this.module.isValid()) {
            err.log("invalid, forget it...");
            return;
        }
        this.codeName = this.module.getCodeName();
        this.codeNameBase = this.module.getCodeNameBase();
        SpecificationVersion sv = this.module.getSpecificationVersion();
        this.specVers = sv == null ? null : sv.toString();
        this.implVers = (String)this.module.getAttribute("OpenIDE-Module-Implementation-Version");
        this.provides = this.module.getProvides();
        this.jar = this.module.getJarFile();
        this.enabled = this.module.isEnabled();
        this.reloadable = this.module.isReloadable();
        this.autoload = this.module.isAutoload();
        this.eager = this.module.isEager();
        Object history = this.module.getHistory();
        this.autoscan = history instanceof ModuleHistory ? ((ModuleHistory)history).isAutoscan() : false;
        Set problems = this.module.getProblems();
        boolean bl = this.problematic = !problems.isEmpty();
        if (this.problematic) {
            this.problemDescriptions = new String[problems.size()];
            Iterator it = problems.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.problemDescriptions[i++] = NbProblemDisplayer.messageForProblem(this.module, it.next());
            }
        } else {
            this.problemDescriptions = null;
        }
        this.displayName = this.module.getDisplayName();
        this.shortDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Short-Description");
        this.longDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        this.category = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
        this.classpath = NbTopManager.getUninitialized().getModuleSystem().getEffectiveClasspath(this.module);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getSpecificationVersion() {
        return this.specVers;
    }

    public String getImplementationVersion() {
        return this.implVers;
    }

    public String[] getProvides() {
        return this.provides;
    }

    public File getJar() {
        return this.jar;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        if (this.enabled == e) {
            return;
        }
        if (this.jar == null || this.autoload || this.eager || this.problematic) {
            throw new IllegalStateException();
        }
        err.log("setEnabled: module=" + (Object)((Object)this.module) + " enabled=" + e);
        this.enabled = e;
        this.supp.firePropertyChange("enabled", null, null);
        Update u = new Update(e ? "enable" : "disable", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean r) {
        if (this.reloadable == r) {
            return;
        }
        err.log("setReloadable: module=" + (Object)((Object)this.module) + " reloadable=" + r);
        this.reloadable = r;
        this.supp.firePropertyChange("reloadable", null, null);
        Update u = new Update(r ? "makeReloadable" : "makeUnreloadable", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public void delete() {
        if (this.jar == null || this.autoscan) {
            throw new IllegalStateException();
        }
        err.log("delete: module=" + (Object)((Object)this.module));
        Update u = new Update("delete", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public boolean isAutoscan() {
        return this.autoscan;
    }

    public boolean isProblematic() {
        return this.problematic;
    }

    public String[] getProblemDescriptions() {
        return this.problemDescriptions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEffectiveClasspath() {
        return this.classpath;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
        this.supp.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("got changes: module=" + (Object)((Object)this.module) + " evt=" + evt);
        if (evt != null && "classLoader".equals(evt.getPropertyName())) {
            err.log("ignoring PROP_CLASS_LOADER");
            return;
        }
        this.loadProps();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("firing changes: module=" + (Object)((Object)this.module));
        this.supp.firePropertyChange(null, null, null);
    }

    public boolean equals(Object o) {
        return o instanceof ModuleBean && this.codeNameBase.equals(((ModuleBean)o).codeNameBase);
    }

    public int hashCode() {
        return 0x21FB6CE ^ this.codeNameBase.hashCode();
    }

    public String toString() {
        return "ModuleBean[" + this.codeNameBase + "]";
    }

    private static final class Update {
        public final String command;
        public final Object arg;

        public Update(String command, Object arg) {
            this.command = command;
            this.arg = arg;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Update)) {
                return false;
            }
            Update u = (Update)o;
            return this.command.equals(u.command) && this.arg.equals(u.arg);
        }

        public int hashCode() {
            return this.command.hashCode() ^ this.arg.hashCode();
        }

        public String toString() {
            return "Update[" + this.command + "," + this.arg + "]";
        }
    }

    public static final class AllModulesBean
    implements Runnable,
    PropertyChangeListener,
    Comparator {
        private static AllModulesBean deflt = null;
        private final ModuleManager mgr = NbTopManager.getUninitialized().getModuleSystem().getManager();
        private final Events ev = NbTopManager.getUninitialized().getModuleSystem().getEvents();
        private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
        private ModuleBean[] modules = null;
        private Task recalcTask = null;
        private final List updates = new LinkedList();
        private boolean paused = false;
        private Runnable updater = new Updater();
        static /* synthetic */ Class class$org$netbeans$core$ui$ModuleBean;

        public static synchronized AllModulesBean getDefault() {
            if (deflt == null) {
                deflt = new AllModulesBean();
            }
            return deflt;
        }

        private AllModulesBean() {
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.supp.removePropertyChangeListener(l);
            this.supp.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.supp.removePropertyChangeListener(l);
        }

        public synchronized ModuleBean[] getModules() {
            err.log("getModules: modules count=" + (this.modules == null ? "null" : String.valueOf(this.modules.length)));
            if (this.modules == null) {
                this.recalcTask = RequestProcessor.getDefault().post((Runnable)new Reader());
                this.modules = new ModuleBean[0];
                return this.modules;
            }
            return this.modules;
        }

        public synchronized Task waitForModules() {
            this.getModules();
            if (this.recalcTask != null) {
                return this.recalcTask;
            }
            return Task.EMPTY;
        }

        public void create(File jar, boolean reloadable) {
            err.log("create: jar=" + jar);
            Update u = new Update(reloadable ? "createReloadable" : "create", jar);
            this.update(u);
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("in event thread, will fire changes");
            this.supp.firePropertyChange(null, null, null);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("got changes: evt=" + evt);
            if ("modules".equals(evt.getPropertyName())) {
                HashMap<Module, ModuleBean> modules2Beans = new HashMap<Module, ModuleBean>(this.modules.length * 4 / 3 + 1);
                int i = 0;
                while (i < this.modules.length) {
                    modules2Beans.put(this.modules[i].getModule(), this.modules[i]);
                    ++i;
                }
                Set modulesSet = this.mgr.getModules();
                ModuleBean[] themodules = new ModuleBean[modulesSet.size()];
                Iterator it = modulesSet.iterator();
                int i2 = 0;
                while (it.hasNext()) {
                    Module m = (Module)((Object)it.next());
                    ModuleBean existing = (ModuleBean)modules2Beans.get((Object)m);
                    if (existing == null) {
                        existing = new ModuleBean(m);
                    }
                    themodules[i2++] = existing;
                }
                AllModulesBean allModulesBean = this;
                synchronized (allModulesBean) {
                    this.modules = themodules;
                }
                SwingUtilities.invokeLater(this);
            }
        }

        public void pause() {
            err.log("pause");
            this.paused = true;
        }

        public void resume() {
            err.log("resume");
            this.paused = false;
            RequestProcessor.getDefault().post(this.updater);
        }

        public void cancel() {
            err.log("cancel");
            List list = this.updates;
            synchronized (list) {
                this.updates.clear();
            }
            this.paused = false;
            this.supp.firePropertyChange("pending", null, null);
        }

        public boolean isPending() {
            List list = this.updates;
            synchronized (list) {
                boolean bl = !this.updates.isEmpty();
                return bl;
            }
        }

        void update(Update u) {
            List list = this.updates;
            synchronized (list) {
                boolean runme = this.updates.isEmpty();
                this.updates.add(u);
                err.log("pending updates: " + this.updates);
                if (runme) {
                    RequestProcessor.getDefault().post(this.updater);
                }
            }
            this.supp.firePropertyChange("pending", null, null);
        }

        private void doDelete(Set modules) {
            if (modules.isEmpty()) {
                return;
            }
            err.log("doDelete: " + modules);
            this.doDisable(modules);
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isFixed()) continue;
                this.mgr.delete(m);
            }
        }

        public int compare(Object o1, Object o2) {
            Module m1 = (Module)((Object)o1);
            Module m2 = (Module)((Object)o2);
            int i = m1.getDisplayName().compareTo(m2.getDisplayName());
            if (i != 0) {
                return i;
            }
            return m1.getCodeNameBase().compareTo(m2.getCodeNameBase());
        }

        private void doDisable(Set modules) {
            if (modules.isEmpty()) {
                return;
            }
            err.log("doDisable: " + modules);
            TreeSet realModules = new TreeSet(this);
            realModules.addAll(modules);
            Iterator it = realModules.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isEnabled() && !m.isAutoload() && !m.isEager() && !m.isFixed()) continue;
                it.remove();
            }
            List toDisable = this.mgr.simulateDisable(realModules);
            it = toDisable.iterator();
            TreeSet<Module> others = new TreeSet<Module>(this);
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isAutoload() || m.isEager() || realModules.contains((Object)m)) continue;
                others.add(m);
            }
            if (!others.isEmpty()) {
                ModuleEnableDisablePanel c = new ModuleEnableDisablePanel(false, realModules.toArray(new Module[realModules.size()]), others.toArray(new Module[others.size()]));
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_disabling"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                    ModuleBean[] _modules = this.modules;
                    if (_modules != null) {
                        int i = 0;
                        while (i < _modules.length) {
                            if (realModules.contains((Object)_modules[i].module)) {
                                _modules[i].propertyChange(null);
                            }
                            ++i;
                        }
                    }
                    return;
                }
                realModules.addAll(others);
            }
            this.mgr.disable(realModules);
        }

        /*
         * Unable to fully structure code
         */
        private void doEnable(Set modules) {
            block19: {
                block20: {
                    if (modules.isEmpty()) {
                        return;
                    }
                    ModuleBean.access$000().log("doEnable: " + modules);
                    realModules = new TreeSet<E>(this);
                    realModules.addAll(modules);
                    it = realModules.iterator();
                    while (it.hasNext()) {
                        m = (Module)it.next();
                        if (!m.isEnabled() && !m.isAutoload() && !m.isEager() && !m.isFixed() && m.getProblems().isEmpty()) continue;
                        it.remove();
                    }
                    toEnable = this.mgr.simulateEnable(realModules);
                    it = toEnable.iterator();
                    others = new TreeSet<Module>(this);
                    while (it.hasNext()) {
                        m = (Module)it.next();
                        if (m.isAutoload() || m.isEager() || realModules.contains((Object)m)) continue;
                        others.add(m);
                    }
                    if (!others.isEmpty()) {
                        c = new ModuleEnableDisablePanel(true, realModules.toArray(new Module[realModules.size()]), others.toArray(new Module[others.size()]));
                        d = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage((Class)(AllModulesBean.class$org$netbeans$core$ui$ModuleBean == null ? (AllModulesBean.class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : AllModulesBean.class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_enabling"), 2);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                            _modules = this.modules;
                            if (_modules != null) {
                                i = 0;
                                while (i < _modules.length) {
                                    if (realModules.contains((Object)ModuleBean.access$1100(_modules[i]))) {
                                        _modules[i].propertyChange(null);
                                    }
                                    ++i;
                                }
                            }
                            return;
                        }
                        realModules.addAll(others);
                    }
                    it = toEnable.iterator();
                    while (it.hasNext()) {
                        block18: {
                            m = (Module)it.next();
                            if (!m.isReloadable()) continue;
                            try {
                                this.mgr.reload(m);
                                continue;
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify((Throwable)ioe);
                                _modules = this.modules;
                                if (_modules == null) break block18;
                                i = 0;
                                ** while (i < _modules.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (realModules.contains((Object)ModuleBean.access$1100(_modules[i]))) {
                                    _modules[i].propertyChange(null);
                                }
                                ++i;
                                continue;
                            }
                        }
                        return;
                    }
                    try {
                        this.mgr.enable(realModules);
                        break block19;
                    }
                    catch (InvalidException ie) {
                        ModuleBean.access$000().notify(1, (Throwable)ie);
                        bad = ie.getModule();
                        if (bad == null) {
                            throw new IllegalStateException();
                        }
                        this.ev.log("failedInstallNewUnexpected", (Object)bad, ie);
                        _modules = this.modules;
                        if (_modules == null) break block20;
                        i = 0;
                        ** while (i < _modules.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (ModuleBean.access$1100(_modules[i]) == bad) {
                            _modules[i].propertyChange(null);
                        }
                        ++i;
                        continue;
                    }
                }
                realModules.remove((Object)ie.getModule());
                this.doEnable(realModules);
            }
        }

        private void doCreate(Set files, boolean reloadable) {
            if (files.isEmpty()) {
                return;
            }
            err.log("doCreate: " + files + " reloadable=" + reloadable);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Module nue;
                File jar = (File)it.next();
                try {
                    nue = this.mgr.create(jar, new ModuleHistory(), reloadable, false, false);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(256, (Throwable)ioe);
                    continue;
                }
                catch (DuplicateException dupe) {
                    Module old = dupe.getOldModule();
                    if (old.isFixed()) continue;
                    if (old.isEnabled()) {
                        if (old.isAutoload() || old.isEager()) continue;
                        this.doDisable(Collections.singleton(old));
                        if (old.isEnabled()) continue;
                    }
                    this.mgr.delete(old);
                    try {
                        nue = this.mgr.create(jar, new ModuleHistory(), reloadable, false, false);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(256, (Throwable)ioe);
                        continue;
                    }
                    catch (DuplicateException dupe2) {
                        ErrorManager.getDefault().notify((Throwable)dupe2);
                        continue;
                    }
                }
                if (nue.getProblems().isEmpty()) {
                    this.doEnable(Collections.singleton(nue));
                    continue;
                }
                this.ev.log("failedInstallNew", Collections.singleton(nue));
            }
        }

        static /* synthetic */ ModuleBean[] access$302(AllModulesBean x0, ModuleBean[] x1) {
            x0.modules = x1;
            return x1;
        }

        static /* synthetic */ boolean access$500(AllModulesBean x0) {
            return x0.paused;
        }

        static /* synthetic */ List access$600(AllModulesBean x0) {
            return x0.updates;
        }

        static /* synthetic */ void access$700(AllModulesBean x0, Set x1) {
            x0.doDelete(x1);
        }

        static /* synthetic */ void access$800(AllModulesBean x0, Set x1) {
            x0.doDisable(x1);
        }

        static /* synthetic */ void access$900(AllModulesBean x0, Set x1) {
            x0.doEnable(x1);
        }

        static /* synthetic */ void access$1000(AllModulesBean x0, Set x1, boolean x2) {
            x0.doCreate(x1, x2);
        }

        static /* synthetic */ ModuleBean[] access$300(AllModulesBean x0) {
            return x0.modules;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class Updater
        implements Runnable {
            private boolean theother = false;

            Updater() {
            }

            /*
             * Unable to fully structure code
             */
            public void run() {
                block24: {
                    if (SwingUtilities.isEventDispatchThread()) {
                        throw new IllegalStateException();
                    }
                    if (!this.theother) {
                        ModuleBean.access$000().log("will run updates in write mutex...");
                        u = new Updater();
                        u.theother = true;
                        AllModulesBean.access$100(AllModulesBean.this).mutex().writeAccess((Runnable)u);
                        return;
                    }
                    try {
                        if (AllModulesBean.access$500(AllModulesBean.this)) {
                            ModuleBean.access$000().log("run updates, but paused");
                            return;
                        }
                        toEnable = new HashSet<Object>();
                        toDisable = new HashSet<Object>();
                        toMakeReloadable = new HashSet<Object>();
                        toMakeUnreloadable = new HashSet<Object>();
                        toDelete = new HashSet<Object>();
                        toCreate = new HashSet<Object>();
                        toCreateReloable = new HashSet<Object>();
                        var9_12 = AllModulesBean.access$600(AllModulesBean.this);
                        synchronized (var9_12) {
                            if (AllModulesBean.access$600(AllModulesBean.this).isEmpty()) {
                                ModuleBean.access$000().log("run updates, but empty");
                                return;
                            }
                            ModuleBean.access$000().log("run updates: " + AllModulesBean.access$600(AllModulesBean.this));
                            it = new LinkedList<E>(AllModulesBean.access$600(AllModulesBean.this)).iterator();
                            AllModulesBean.access$600(AllModulesBean.this).clear();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl30 : MonitorExitStatement: MONITOREXIT : var9_12
                            if (true) ** GOTO lbl92
                        }
                        do {
                            u = (Update)it.next();
                            if (u.command.equals("enable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toDisable.remove(u.arg);
                                toEnable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("disable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toEnable.remove(u.arg);
                                toDisable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("makeReloadable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toMakeUnreloadable.remove(u.arg);
                                toMakeReloadable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("makeUnreloadable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toMakeReloadable.remove(u.arg);
                                toMakeUnreloadable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("delete")) {
                                toEnable.remove(u.arg);
                                toDisable.remove(u.arg);
                                toMakeReloadable.remove(u.arg);
                                toMakeUnreloadable.remove(u.arg);
                                toDelete.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("create")) {
                                toCreateReloable.remove(u.arg);
                                toCreate.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("createReloadable")) {
                                toCreate.remove(u.arg);
                                toCreateReloable.add(u.arg);
                                continue;
                            }
                            throw new IllegalStateException();
lbl92:
                            // 8 sources

                        } while (it.hasNext());
                        AllModulesBean.access$700(AllModulesBean.this, toDelete);
                        AllModulesBean.access$800(AllModulesBean.this, toDisable);
                        it = toMakeReloadable.iterator();
                        while (it.hasNext()) {
                            m = (Module)it.next();
                            m.setReloadable(true);
                        }
                        it = toMakeUnreloadable.iterator();
                        while (it.hasNext()) {
                            m = (Module)it.next();
                            m.setReloadable(false);
                        }
                        AllModulesBean.access$900(AllModulesBean.this, toEnable);
                        AllModulesBean.access$1000(AllModulesBean.this, toCreate, false);
                        AllModulesBean.access$1000(AllModulesBean.this, toCreateReloable, true);
                        break block24;
                    }
                    catch (RuntimeException re) {
                        ModuleBean.access$000().notify((Throwable)re);
                        _modules = AllModulesBean.access$300(AllModulesBean.this);
                        if (_modules == null) break block24;
                        i = 0;
                        ** while (i < _modules.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        _modules[i].propertyChange(null);
                        ++i;
                        continue;
                    }
                }
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }

        private class Reader
        implements Runnable {
            private boolean theother = false;

            Reader() {
            }

            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                if (!this.theother) {
                    err.log("will load modules in read mutex...");
                    Reader r = new Reader();
                    r.theother = true;
                    AllModulesBean.this.mgr.mutex().readAccess((Runnable)r);
                    return;
                }
                err.log("first time, finding module list");
                Set modulesSet = AllModulesBean.this.mgr.getModules();
                ModuleBean[] _modules = new ModuleBean[modulesSet.size()];
                Iterator it = modulesSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Module m = (Module)((Object)it.next());
                    _modules[i++] = new ModuleBean(m);
                }
                AllModulesBean allModulesBean = AllModulesBean.this;
                synchronized (allModulesBean) {
                    AllModulesBean.access$302(AllModulesBean.this, _modules);
                    AllModulesBean.this.recalcTask = null;
                }
                AllModulesBean.this.mgr.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)AllModulesBean.this, (Object)AllModulesBean.this.mgr));
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }
    }
}

