/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.ui.ProductInformationPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class Splash
implements SwingConstants {
    static Reference splashRef;
    static Reference aboutRef;
    private static StatusDisplayer status;
    static /* synthetic */ Class class$org$netbeans$core$Splash;

    private static String getMainWindowTitle() {
        String buildNumber = System.getProperty("netbeans.buildnumber");
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_MainWindow_Title"), buildNumber);
    }

    public static void showSplashDialog() {
        SplashDialog splashDialog = new SplashDialog();
        splashDialog.show();
    }

    public static SplashOutput showSplash() {
        final Window splashWindow = Splash.createW();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Splash.center(splashWindow);
                splashWindow.show();
                splashWindow.toFront();
            }
        });
        status = StatusDisplayer.getDefault();
        status.addChangeListener((ChangeListener)((Object)splashWindow));
        return (SplashOutput)((Object)splashWindow);
    }

    public static void hideSplash(SplashOutput xsplashWindow) {
        final Window splashWindow = (Window)((Object)xsplashWindow);
        status.removeChangeListener((ChangeListener)((Object)splashWindow));
        status = null;
        ((SplashOutputInternal)((Object)xsplashWindow)).hideRequested();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)splashWindow).setVisible(false);
                splashWindow.dispose();
            }
        });
    }

    public static boolean isVisible(SplashOutput xsplashWindow) {
        return !((SplashOutputInternal)((Object)xsplashWindow)).isHideRequested();
    }

    private static Window createW() {
        boolean window = false;
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 1024) {
            window = true;
        }
        if (Utilities.getOperatingSystem() == 16) {
            if (System.getProperty("env-kde_display") == null && System.getProperty("env-kdedir") == null) {
                window = true;
            } else if (!System.getProperty("java.vm.vendor", "").startsWith("Sun")) {
                window = true;
            } else if (!System.getProperty("java.vm.version", "").startsWith("1.3")) {
                window = true;
            }
        }
        return window ? new SplashWindow() : new SplashFrame();
    }

    public static final void center(Window c) {
        c.pack();
        ((Component)c).setBounds(Utilities.findCenterBounds((Dimension)c.getSize()));
    }

    static Image getSplash() {
        Image ret;
        if (splashRef == null || (ret = (Image)splashRef.get()) == null) {
            ret = Splash.loadSplash();
            splashRef = new WeakReference<Image>(ret);
        }
        return ret;
    }

    static Image getAbout() {
        Image ret;
        if (aboutRef == null || (ret = (Image)aboutRef.get()) == null) {
            ret = Splash.loadAbout();
            aboutRef = new WeakReference<Image>(ret);
        }
        return ret;
    }

    private static Image loadSplash() {
        URL u = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.splash", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
        return Toolkit.getDefaultToolkit().getImage(u);
    }

    private static Image loadAbout() {
        try {
            URL u = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.about", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            return Toolkit.getDefaultToolkit().getImage(u);
        }
        catch (MissingResourceException exception) {
            return Splash.loadSplash();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SplashDialog
    extends JDialog
    implements SplashOutput,
    SplashOutputInternal,
    ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new AboutComponent();
        private boolean hideRequested = false;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashDialog() {
            super(WindowManager.getDefault().getMainWindow(), true);
            JPanel splashPanel = new JPanel();
            JTabbedPane tabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_About_Title"));
            splashPanel.setLayout(new GridBagLayout());
            splashPanel.add(this.splashComponent);
            tabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Title"), splashPanel);
            ProductInformationPanel infoPanel = new ProductInformationPanel();
            tabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Detail"), infoPanel);
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSN_AboutTabs"));
            tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashDialog.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutDialog"));
            Splash.center(this);
        }

        public void print(String x) {
            this.splashComponent.setText(x);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void actionPerformed(ActionEvent e) {
            ((Component)this).setVisible(false);
            this.dispose();
        }

        public void increment(int steps) {
        }

        public void setMaxSteps(int maxSteps) {
        }

        public void addToMaxSteps(int steps) {
        }

        public void addAndSetMaxSteps(int steps) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SplashFrame
    extends JFrame
    implements SplashOutput,
    SplashOutputInternal,
    ChangeListener {
        static final long serialVersionUID = 3200319077899134000L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;

        public SplashFrame() {
            super(Splash.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(this.splashComponent);
        }

        public void print(String x) {
            this.splashComponent.setText(x);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void increment(int steps) {
            this.splashComponent.increment(steps);
        }

        public void setMaxSteps(int maxSteps) {
            this.splashComponent.setMaxSteps(maxSteps);
        }

        public void addToMaxSteps(int steps) {
            this.splashComponent.addToMaxSteps(steps);
        }

        public void addAndSetMaxSteps(int steps) {
            this.splashComponent.addAndSetMaxSteps(steps);
        }

        public void stateChanged(ChangeEvent e) {
            this.print(status.getStatusText());
        }
    }

    private static class SplashWindow
    extends Window
    implements SplashOutput,
    SplashOutputInternal,
    ChangeListener {
        static final long serialVersionUID = 4838519880359397841L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)this.splashComponent, "Center");
        }

        public Dimension getPreferredSize() {
            int width = 520;
            int height = 316;
            width = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashWindow.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_WIDTH"));
            height = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashWindow.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_HEIGHT"));
            return new Dimension(width, height);
        }

        public void print(String x) {
            this.splashComponent.setText(x);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void increment(int steps) {
            this.splashComponent.increment(steps);
        }

        public void setMaxSteps(int maxSteps) {
            this.splashComponent.setMaxSteps(maxSteps);
        }

        public void addToMaxSteps(int steps) {
            this.splashComponent.addToMaxSteps(steps);
        }

        public void addAndSetMaxSteps(int steps) {
            this.splashComponent.addAndSetMaxSteps(steps);
        }

        public void stateChanged(ChangeEvent e) {
            this.print(status.getStatusText());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class AboutComponent
    extends SplashComponent {
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public AboutComponent() {
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = AboutComponent.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            this.image = new ImageIcon(Splash.getAbout()).getImage();
            StringTokenizer st = new StringTokenizer(bundle.getString("AboutTextBounds"), " ,");
            SplashComponent.view = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            Integer rgb = Integer.decode(bundle.getString("AboutTextColor"));
            SplashComponent.color_text = new Color(rgb);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = -1162806313274828742L;
        private FontMetrics fm;
        static Rectangle view;
        static Color color_text;
        static Color color_bar;
        static Color color_edge;
        static Color color_corner;
        static boolean draw_bar;
        protected Image image;
        private Rectangle dirty = new Rectangle();
        private String text;
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int tmpSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        static /* synthetic */ Class class$org$netbeans$core$Splash;

        public SplashComponent() {
            this.image = new ImageIcon(Splash.getSplash()).getImage();
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = SplashComponent.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            StringTokenizer st = new StringTokenizer(bundle.getString("SplashRunningTextBounds"), " ,");
            view = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            draw_bar = true;
            try {
                draw_bar = bundle.getString("SplashShowProgressBar").equals("true");
                st = new StringTokenizer(bundle.getString("SplashProgressBarBounds"), " ,");
                this.bar = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                this.maxSteps = this.bar.width;
                Integer rgb = Integer.decode(bundle.getString("SplashRunningTextColor"));
                color_text = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarColor"));
                color_bar = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarEdgeColor"));
                color_edge = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarCornerColor"));
                color_corner = new Color(rgb);
            }
            catch (MissingResourceException ex) {
                draw_bar = false;
            }
            int size = 12;
            try {
                String sizeStr = bundle.getString("SplashRunningTextFontSize");
                size = Integer.parseInt(sizeStr);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            Font font = new Font("Dialog", 0, size);
            this.setFont(font);
            this.fm = ((Component)this).getFontMetrics(font);
        }

        public void setText(String text) {
            EventQueue.invokeLater(new Runnable(this, text){
                private final /* synthetic */ String val$text;
                private final /* synthetic */ SplashComponent this$0;
                {
                    this.this$0 = this$0;
                    this.val$text = val$text;
                }

                public void run() {
                    if (this.val$text == null) {
                        this.this$0.repaint(SplashComponent.access$000(this.this$0));
                        return;
                    }
                    if (SplashComponent.access$100(this.this$0) == null) {
                        return;
                    }
                    SplashComponent.access$200(this.this$0, this.val$text);
                    SwingUtilities.layoutCompoundLabel(SplashComponent.access$100(this.this$0), this.val$text, null, 3, 2, 3, 2, SplashComponent.view, new Rectangle(), SplashComponent.access$300(this.this$0), 0);
                    SplashComponent.access$002(this.this$0, SplashComponent.access$000(this.this$0).union(SplashComponent.access$300(this.this$0)));
                    this.this$0.repaint(SplashComponent.access$000(this.this$0));
                    SplashComponent.access$002(this.this$0, new Rectangle(SplashComponent.access$300(this.this$0)));
                }
            });
        }

        public void setMaxSteps(int maxSteps) {
            this.maxSteps = maxSteps;
        }

        public void addToMaxSteps(int steps) {
            this.tmpSteps += steps;
        }

        public void addAndSetMaxSteps(int steps) {
            this.tmpSteps += steps;
            this.maxSteps = this.tmpSteps;
        }

        public void increment(int steps) {
            if (draw_bar) {
                int bl;
                this.progress += steps;
                if (this.progress > this.maxSteps) {
                    this.progress = this.maxSteps;
                } else if (this.maxSteps > 0 && ((bl = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                    this.barLength = bl;
                    this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                    this.repaint(this.bar_inc);
                }
            }
        }

        private void adjustText(String text) {
            String newText = null;
            if (text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int width = this.fm.stringWidth(text);
            if (width > SplashComponent.view.width) {
                StringTokenizer st = new StringTokenizer(text);
                while (st.hasMoreTokens()) {
                    String element = st.nextToken();
                    String newString = newText == null ? element : newText + " " + element;
                    if (this.fm.stringWidth(newString + "...") > SplashComponent.view.width) {
                        this.text = newText + "...";
                        break;
                    }
                    newText = newString;
                }
            } else {
                this.text = text;
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(color_text);
            graphics.drawImage(this.image, 0, 0, null);
            if (this.text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, view, new Rectangle(), this.rect, 0);
            graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            if (draw_bar && !Boolean.getBoolean("netbeans.splash.nobar") && this.maxSteps > 0) {
                graphics.setColor(color_bar);
                graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                graphics.setColor(color_corner);
                graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                graphics.setColor(color_edge);
                graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }

        public boolean isOpaque() {
            return true;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ Rectangle access$000(SplashComponent x0) {
            return x0.dirty;
        }

        static /* synthetic */ FontMetrics access$100(SplashComponent x0) {
            return x0.fm;
        }

        static /* synthetic */ void access$200(SplashComponent x0, String x1) {
            x0.adjustText(x1);
        }

        static /* synthetic */ Rectangle access$300(SplashComponent x0) {
            return x0.rect;
        }

        static /* synthetic */ Rectangle access$002(SplashComponent x0, Rectangle x1) {
            x0.dirty = x1;
            return x0.dirty;
        }
    }

    private static interface SplashOutputInternal {
        public void hideRequested();

        public boolean isHideRequested();
    }

    public static interface SplashOutput {
        public void print(String var1);

        public void setMaxSteps(int var1);

        public void addToMaxSteps(int var1);

        public void addAndSetMaxSteps(int var1);

        public void increment(int var1);
    }
}

