/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class StringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setAsText(String s) {
        if ("null".equals(s) && this.getValue() == null) {
            return;
        }
        this.setValue(s);
    }

    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        return "\"" + StringEditor.toAscii(s) + "\"";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        String s = "";
        if (val != null) {
            s = val.toString();
        }
        return new StringCustomEditor(s, this.isEditable());
    }

    private static String toAscii(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 6);
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\f': {
                    buf.append("\\f");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        buf.append(c);
                        break;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    int j = 0;
                    while (j < 4 - hex.length()) {
                        buf.append('0');
                        ++j;
                    }
                    buf.append(hex);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
        }
    }
}

