/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUtil2 {
    private static final Log log = LogFactory.getLog(EcoreUtil2.class);

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
    }

    public static final EPackage getEPackage(String pathToEcoreFile) {
        EPackage topLevelPackage = null;
        URI fileURI = EcoreUtil2.getURI(pathToEcoreFile);
        if (fileURI == null) {
            throw new RuntimeException("cannot resolve EPackage for " + pathToEcoreFile + ". Probably cannot find the .ecore file.");
        }
        try {
            Resource res = new ResourceSetImpl().createResource(fileURI);
            if (res == null) {
                throw new ConfigurationException("No ecore model file '" + pathToEcoreFile + "' found! (" + fileURI.toString() + ")");
            }
            res.load(new HashMap());
            topLevelPackage = (EPackage)res.getContents().get(0);
            EcoreUtil2.registerPackage(topLevelPackage, fileURI);
            EcoreUtil2.registerSubPackages(topLevelPackage, fileURI);
            EPackage ePackage = topLevelPackage;
            return ePackage;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            EcoreUtil2.logPackages();
        }
    }

    private static void registerSubPackages(EPackage ePackage, URI fileURI) {
        if (ePackage == null || fileURI == null) {
            throw new IllegalArgumentException();
        }
        TreeIterator it = ePackage.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof EPackage)) continue;
            EPackage p = (EPackage)obj;
            EcoreUtil2.registerPackage(p, fileURI);
        }
    }

    private static void registerPackage(EPackage ePackage, URI fileURI) {
        if (ePackage != null && fileURI != null && ePackage.getNsURI() != null && !EPackage.Registry.INSTANCE.containsKey((Object)ePackage.getNsURI())) {
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            URIConverter.URI_MAP.put(URI.createURI((String)ePackage.getNsURI()), fileURI);
        }
    }

    private static void logPackages() {
    }

    public static Set<EObject> findAllByType(Iterator iter, Class type) {
        HashSet<EObject> result = new HashSet<EObject>();
        while (iter.hasNext()) {
            EObject curr = (EObject)iter.next();
            if (!type.isInstance(curr)) continue;
            result.add(curr);
        }
        return result;
    }

    public static List clone(EList list) {
        if (list == null) {
            return null;
        }
        ArrayList res = new ArrayList();
        res.addAll(list);
        return res;
    }

    public static EPackage getEPackageByClassName(String ePackage) throws ConfigurationException {
        try {
            Class clazz = ResourceLoaderFactory.createResourceLoader().loadClass(ePackage);
            if (clazz == null) {
                throw new ConfigurationException("Couldn't find class " + ePackage);
            }
            Field f = clazz.getField("eINSTANCE");
            EPackage result = (EPackage)f.get(null);
            EPackage.Registry.INSTANCE.put((Object)result.getNsURI(), (Object)result);
            EPackage ePackage2 = result;
            return ePackage2;
        }
        catch (SecurityException e) {
            log.error((Object)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            return null;
        }
        finally {
            EcoreUtil2.logPackages();
        }
    }

    public static EPackage getEPackageByDescriptorClassName(String ePackageDescriptor) {
        try {
            Class clazz = ResourceLoaderFactory.createResourceLoader().loadClass(ePackageDescriptor);
            EPackage.Descriptor descriptor = (EPackage.Descriptor)clazz.newInstance();
            Field f = clazz.getField("eNS_URI");
            String uri = (String)f.get(null);
            EPackage.Registry.INSTANCE.put((Object)uri, (Object)descriptor);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
            return ePackage;
        }
        catch (Exception e) {
            log.error((Object)("Couldn't load ePackage '" + ePackageDescriptor), (Throwable)e);
            return null;
        }
        finally {
            EcoreUtil2.logPackages();
        }
    }

    public static URI getURI(String file) {
        URI uri;
        URL url = ResourceLoaderFactory.createResourceLoader().getResource(file);
        try {
            uri = url == null ? URI.createURI((String)file) : URI.createURI((String)url.toExternalForm());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            uri = URI.createFileURI((String)url.getFile());
        }
        return uri;
    }

    public static Collection<EObject> allContents(EObject modelElement) {
        ArrayList<EObject> all = new ArrayList<EObject>();
        TreeIterator iterator = modelElement.eAllContents();
        while (iterator.hasNext()) {
            all.add((EObject)iterator.next());
        }
        return all;
    }
}

