/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.typecode;

import java.util.HashMap;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodeFactory;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.openorb.CORBA.typecode.TypeCodeAlias;
import org.openorb.CORBA.typecode.TypeCodeArray;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.CORBA.typecode.TypeCodeEnum;
import org.openorb.CORBA.typecode.TypeCodeFixed;
import org.openorb.CORBA.typecode.TypeCodeObject;
import org.openorb.CORBA.typecode.TypeCodePrimitive;
import org.openorb.CORBA.typecode.TypeCodeRecursive;
import org.openorb.CORBA.typecode.TypeCodeString;
import org.openorb.CORBA.typecode.TypeCodeStruct;
import org.openorb.CORBA.typecode.TypeCodeUnion;
import org.openorb.CORBA.typecode.TypeCodeValue;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;

public class TypeCodeFactoryImpl
extends LocalObject
implements TypeCodeFactory {
    private static TypeCodeFactoryImpl s_instance = null;

    private TypeCodeFactoryImpl() {
    }

    public static TypeCodeFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new TypeCodeFactoryImpl();
        }
        return s_instance;
    }

    private TypeCode fix_recursive(TypeCodeBase tc) {
        tc._fix_recursive(new HashMap());
        return tc;
    }

    public TypeCode create_struct_tc(String id, String name, StructMember[] members) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeStruct(TCKind.tk_struct, id, name, members));
    }

    public TypeCode create_union_tc(String id, String name, TypeCode discriminator_type, UnionMember[] members) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCode base = discriminator_type;
        try {
            while (base.kind() == TCKind.tk_alias) {
                base = base.content_type();
            }
        }
        catch (BadKind ex) {
            throw ExceptionTool.initCause(new BAD_PARAM("Unexpected BadKind exception", 1330446356, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex);
        }
        switch (base.kind().value()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            default: {
                throw new BAD_PARAM(1330446356, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean hasDefault = false;
        int i = 0;
        while (i < members.length) {
            if (!members[i].label.type().equivalent(discriminator_type)) {
                if (!hasDefault && members[i].label.type().equal(TypeCodePrimitive.TC_OCTET) && members[i].label.extract_octet() == 0) {
                    hasDefault = true;
                } else {
                    throw new BAD_PARAM(1330446355, CompletionStatus.COMPLETED_MAYBE);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < members.length) {
            int j = i2 + 1;
            while (j < members.length) {
                if (members[i2].label.equal(members[j].label)) {
                    throw new BAD_PARAM(1330446354, CompletionStatus.COMPLETED_MAYBE);
                }
                ++j;
            }
            ++i2;
        }
        return this.fix_recursive(new TypeCodeUnion(id, name, discriminator_type, members));
    }

    public TypeCode create_enum_tc(String id, String name, String[] members) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeEnum(id, name, members);
    }

    public TypeCode create_alias_tc(String id, String name, TypeCode original_type) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeAlias(TCKind.tk_alias, id, name, original_type));
    }

    public TypeCode create_exception_tc(String id, String name, StructMember[] members) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeStruct(TCKind.tk_except, id, name, members));
    }

    public TypeCode create_interface_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_objref, id, name);
    }

    public TypeCode create_native_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_native, id, name);
    }

    public TypeCode create_string_tc(int bound) {
        if (bound == 0) {
            return TypeCodeString.TC_STRING_0;
        }
        return new TypeCodeString(TCKind.tk_string, bound);
    }

    public TypeCode create_wstring_tc(int bound) {
        if (bound == 0) {
            return TypeCodeString.TC_WSTRING_0;
        }
        return new TypeCodeString(TCKind.tk_wstring, bound);
    }

    public TypeCode create_sequence_tc(int bound, TypeCode element_type) {
        return this.fix_recursive(new TypeCodeArray(TCKind.tk_sequence, bound, element_type));
    }

    public TypeCode create_recursive_sequence_tc(int bound, int offset) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_recursive_tc(String id) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeRecursive(id);
    }

    public TypeCode create_array_tc(int length, TypeCode element_type) {
        return this.fix_recursive(new TypeCodeArray(TCKind.tk_array, length, element_type));
    }

    public TypeCode create_fixed_tc(short digits, short scale) {
        return new TypeCodeFixed(digits, scale);
    }

    public TypeCode create_value_tc(String id, String name, short type_modifier, TypeCode concrete_base, ValueMember[] members) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        if (concrete_base == null) {
            concrete_base = TypeCodePrimitive.TC_NULL;
        }
        return this.fix_recursive(new TypeCodeValue(id, name, type_modifier, concrete_base, members));
    }

    public TypeCode create_value_box_tc(String id, String name, TypeCode boxed_type) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeAlias(TCKind.tk_value_box, id, name, boxed_type));
    }

    public TypeCode create_abstract_interface_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_abstract_interface, id, name);
    }

    public TypeCode create_local_interface_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_objref, id, name);
    }

    public TypeCode create_home_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_component_tc(String id, String name) {
        if (!RepoIDHelper.checkID(id)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (id.startsWith("IDL:") && name.length() != 0 && !RepoIDHelper.checkIdentifier(name)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        throw new NO_IMPLEMENT();
    }

    public TypeCode get_primitive_tc(TCKind tcKind) {
        switch (tcKind.value()) {
            case 0: {
                return TypeCodePrimitive.TC_NULL;
            }
            case 1: {
                return TypeCodePrimitive.TC_VOID;
            }
            case 2: {
                return TypeCodePrimitive.TC_SHORT;
            }
            case 3: {
                return TypeCodePrimitive.TC_LONG;
            }
            case 4: {
                return TypeCodePrimitive.TC_USHORT;
            }
            case 5: {
                return TypeCodePrimitive.TC_ULONG;
            }
            case 6: {
                return TypeCodePrimitive.TC_FLOAT;
            }
            case 7: {
                return TypeCodePrimitive.TC_DOUBLE;
            }
            case 8: {
                return TypeCodePrimitive.TC_BOOLEAN;
            }
            case 9: {
                return TypeCodePrimitive.TC_CHAR;
            }
            case 10: {
                return TypeCodePrimitive.TC_OCTET;
            }
            case 11: {
                return TypeCodePrimitive.TC_ANY;
            }
            case 12: {
                return TypeCodePrimitive.TC_TYPECODE;
            }
            case 13: {
                return TypeCodePrimitive.TC_PRINCIPAL;
            }
            case 23: {
                return TypeCodePrimitive.TC_LONGLONG;
            }
            case 24: {
                return TypeCodePrimitive.TC_ULONGLONG;
            }
            case 25: {
                return TypeCodePrimitive.TC_LONGDOUBLE;
            }
            case 26: {
                return TypeCodePrimitive.TC_WCHAR;
            }
            case 18: {
                return TypeCodeString.TC_STRING_0;
            }
            case 27: {
                return TypeCodeString.TC_WSTRING_0;
            }
            case 14: {
                return TypeCodeObject.TC_OBJECT;
            }
            case 32: {
                return TypeCodeObject.TC_ABSTRACT_INTERFACE;
            }
            case 29: {
                return TypeCodeValue.TC_VALUEBASE;
            }
        }
        throw new BAD_PARAM("Illegal kind for primative typecode", 1146056717, CompletionStatus.COMPLETED_MAYBE);
    }
}

