/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class JTreeMouseEventData
extends AbstractMouseEventData {
    private JTree m_tree;
    private String m_nodeValue;
    private TreePath m_treePath;

    public JTreeMouseEventData() {
        this.setValid(false);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks) {
        this(testCase, tree, treePath, numberOfClicks, 300L);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks) {
        this(testCase, tree, nodeValue, numberOfClicks, 300L);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, long sleepTime) {
        this(testCase, tree, treePath, numberOfClicks, false, sleepTime);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, long sleepTime) {
        this(testCase, tree, nodeValue, numberOfClicks, false, sleepTime);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, tree, treePath, numberOfClicks, isPopupTrigger, 300L);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, tree, nodeValue, numberOfClicks, isPopupTrigger, 300L);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tree, treePath, numberOfClicks, JTreeMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tree, nodeValue, numberOfClicks, JTreeMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tree, treePath, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tree, nodeValue, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, tree, treePath, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, tree, nodeValue, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, tree, treePath, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, tree, nodeValue, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, TreePath treePath, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(tree);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setTreePath(treePath);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public JTreeMouseEventData(JFCTestCase testCase, JTree tree, String nodeValue, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(tree);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setNodeValue(nodeValue);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setNodeValue(String nodeValue) {
        this.m_nodeValue = nodeValue;
    }

    public final String getNodeValue() {
        return this.m_nodeValue;
    }

    public final void setSource(JTree tree) {
        this.m_tree = tree;
    }

    public final JTree getSource() {
        return this.m_tree;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public final void setTreePath(TreePath treePath) {
        this.m_treePath = treePath;
    }

    public final TreePath getTreePath() {
        return this.m_treePath;
    }

    public boolean canConsume(AWTEvent ae) {
        if (!(ae.getSource() instanceof JTree && super.canConsume(ae) && this.sameSource(ae))) {
            return false;
        }
        if (this.isValid()) {
            int row = ((JTree)ae.getSource()).getRowForLocation(((MouseEvent)ae).getX(), ((MouseEvent)ae).getY());
            TreePath path = ((JTree)ae.getSource()).getPathForRow(row);
            if (path != null && !path.equals(this.getTreePath())) {
                return false;
            }
        }
        return true;
    }

    public boolean consume(AWTEvent ae) {
        int row;
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JTree source = (JTree)me.getSource();
        TreePath path = source.getPathForRow(row = source.getRowForLocation(me.getX(), me.getY()));
        if (path == null) {
            return true;
        }
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        this.setSleepTime(this.getDefaultSleepTime());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setTreePath(path);
        this.setNodeValue(path.getLastPathComponent().toString());
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JTreeMouseEventData)) {
            return false;
        }
        JTreeMouseEventData data = (JTreeMouseEventData)o;
        if (!super.equals(o)) {
            return false;
        }
        TreePath path = this.getTreePath();
        TreePath dataPath = data.getTreePath();
        if (path != null && dataPath != null && !data.equals(this.m_treePath)) {
            return false;
        }
        return this.getNodeValue() == null || data.getNodeValue() == null || this.getNodeValue().equals(data.getNodeValue());
    }

    public int hashCode() {
        int nodeHash = 0;
        if (this.m_nodeValue != null) {
            nodeHash = this.m_nodeValue.hashCode();
        }
        return super.hashCode() + nodeHash;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JTreeMouseEventData");
        e.setAttribute("node", this.getNodeValue());
    }

    public boolean prepareComponent() {
        TreePath path;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.m_tree.updateUI();
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        if ((path = this.getTreePath()) == null) {
            path = new TreePath(this.buildPath(this.getNode(this.m_tree, this.getNodeValue())));
        }
        if (path == null) {
            return false;
        }
        this.m_tree.setSelectionPath(path);
        if (testCase != null) {
            testCase.flushAWT();
        }
        Rectangle cellRect = this.m_tree.getPathBounds(path);
        if (testCase != null) {
            testCase.flushAWT();
        }
        Point p = this.calculatePoint(cellRect);
        if (!this.m_tree.getVisibleRect().contains(p)) {
            Rectangle vis = this.m_tree.getVisibleRect();
            Rectangle newView = new Rectangle(p.x - vis.width / 2, p.y - vis.height / 2, vis.width, vis.height);
            this.m_tree.scrollRectToVisible(newView);
        }
        Point screen = this.m_tree.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" nodeValue: " + this.getNodeValue());
        buf.append(" treePath: " + this.getTreePath());
        return buf.toString();
    }

    private TreeNode getNode(JTree tree, String userObj) {
        if (userObj == null) {
            return null;
        }
        TreeModel model = tree.getModel();
        TreeNode root = (TreeNode)model.getRoot();
        if (this.checkNodesUserObject(root, userObj)) {
            return root;
        }
        List nodeList = this.findNodeList(root, new ArrayList());
        TreeNode node = null;
        Iterator iter = nodeList.iterator();
        while (iter.hasNext()) {
            node = (TreeNode)iter.next();
            if (!this.checkNodesUserObject(node, userObj)) continue;
            return node;
        }
        return null;
    }

    private Object[] buildPath(TreeNode node) {
        ArrayList<TreeNode> retVal = new ArrayList<TreeNode>();
        if (node != null) {
            retVal.add(0, node);
            for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                retVal.add(0, parent);
            }
        }
        retVal.trimToSize();
        return retVal.toArray();
    }

    private boolean checkNodesUserObject(TreeNode node, String userObj) {
        if (node == null) {
            return false;
        }
        return node.toString() != null && node.toString().equals(userObj);
    }

    private List findNodeList(TreeNode parent, List outList) {
        for (int idx = 0; idx < parent.getChildCount(); ++idx) {
            TreeNode node = parent.getChildAt(idx);
            outList.add(node);
            this.findNodeList(node, outList);
        }
        return outList;
    }
}

