/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.ecore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.ecore.AbstractEcoreGeneratorFragment;
import org.eclipse.xtext.resource.XtextResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelReferenceEcoreGeneratorFragment
extends AbstractEcoreGeneratorFragment {
    private static Logger log = Logger.getLogger(GenModelReferenceEcoreGeneratorFragment.class);
    private String referencedGenModel;
    private boolean skipGenerate = false;

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        List list = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
        List packs = EcoreUtil2.collect((Collection)list, (int)0, EPackage.class);
        if (!packs.isEmpty()) {
            XtextResourceSet rs = new XtextResourceSet();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            this.copyGeneratedMetamodelsTo((List<Grammar>)grammar.getUsedGrammars(), (ResourceSet)rs, copier);
            ArrayList<EPackage> copies = new ArrayList<EPackage>(packs.size());
            for (EPackage pack : packs) {
                copies.add((EPackage)copier.copy((EObject)pack));
            }
            copier.copyReferences();
            String xmiPath = this.getXmiModelDirectory() == null || "".equals(this.getXmiModelDirectory()) ? String.valueOf(ctx.getOutput().getOutlet("SRC_GEN").getPath()) + "/" + grammar.getName().substring(0, grammar.getName().lastIndexOf(46)).replace('.', '/') : this.getXmiModelDirectory();
            this.generateEcoreJavaClasses((ResourceSet)rs, copies, this.getBasePackage(grammar), xmiPath, grammar);
        }
    }

    public String getReferencedGenModel() {
        return this.referencedGenModel;
    }

    public void setReferencedGenModel(String referencedGenModel) {
        if ("".equals(referencedGenModel)) {
            return;
        }
        this.referencedGenModel = referencedGenModel;
    }

    public void generateEcoreJavaClasses(ResourceSet rs, Collection<? extends EPackage> packs, String basePackage, String xmiPath, Grammar grammar) throws ConfigurationException {
        Resource genModelResource = null;
        String modelName = grammar.getName().substring(grammar.getName().lastIndexOf(46) + 1);
        try {
            String prefix = String.valueOf(new File(xmiPath).getCanonicalPath()) + "/" + modelName;
            URI ecoreResourceURI = URI.createFileURI((String)(String.valueOf(prefix) + ".ecore"));
            Resource ecoreResource = rs.createResource(ecoreResourceURI, "");
            ecoreResource.getContents().addAll(packs);
            ecoreResource.save(null);
            if (this.getReferencedGenModel() != null) {
                URI genModelURI = URI.createURI((String)this.getReferencedGenModel());
                genModelResource = rs.getResource(genModelURI, true);
                if (genModelURI.isPlatform()) {
                    genModelURI = EcorePlugin.resolvePlatformResourcePath((String)genModelURI.toPlatformString(true));
                    ecoreResourceURI = ecoreResourceURI.deresolve(genModelURI, true, true, true);
                    rs.getURIConverter().getURIMap().put(ecoreResourceURI.resolve(genModelResource.getURI()), ecoreResourceURI);
                    ecoreResource.setURI(ecoreResourceURI);
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't compute canonical path for " + new File(xmiPath).getAbsolutePath());
        }
        if (genModelResource == null) {
            return;
        }
        GenModel genModel = (GenModel)genModelResource.getContents().get(0);
        genModel.initialize(packs);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            if (!packs.contains(genPackage.getEcorePackage())) continue;
            genPackage.setBasePackage(basePackage);
        }
        try {
            genModelResource.save(null);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!this.skipGenerate) {
            genModel.setCanGenerate(true);
            genModel.setFacadeHelperClass(null);
            genModel.reconcile();
            this.doGenerate(genModel);
        }
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public boolean isSkipGenerate() {
        return this.skipGenerate;
    }
}

