/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.DefaultScopeProvider;
import org.eclipse.xtext.xtend.AbstractXtendService;
import org.eclipse.xtext.xtend.NoSuchExtensionException;

public class XtendScopeProvider
extends AbstractXtendService
implements IScopeProvider {
    public static final String EXTENSION_FILE = "ScopeExtensions";
    private final String extensionFile;
    private final DefaultScopeProvider defaultScopeProvider;
    private static Logger log = Logger.getLogger(XtendScopeProvider.class);
    private static final String SCOPE_EXTENSION_PREFIX = "scope_";

    @Inject
    public XtendScopeProvider(@Named(value="ScopeExtensions") String name, DefaultScopeProvider defaultScopeProvider) {
        this.extensionFile = name;
        this.defaultScopeProvider = defaultScopeProvider;
    }

    public IScope getScope(EObject context, EReference reference) {
        try {
            while (true) {
                Object result = null;
                try {
                    String extensionName = this.extensionName(context, reference);
                    result = this.invokeExtension(extensionName, Lists.newArrayList((Object[])new EObject[]{context, reference}));
                }
                catch (NoSuchExtensionException noSuchExtensionException) {}
                if (result != null) {
                    return result;
                }
                if (context.eContainer() != null) {
                    return this.getScope(context.eContainer(), reference);
                }
                this.computeDefaultScope(context, reference);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error invoking scope extension", e);
            return null;
        }
    }

    public IScope getScope(EObject context, EClass type) {
        try {
            while (true) {
                Object result = null;
                try {
                    String extensionName = this.extensionName(context, type);
                    result = this.invokeExtension(extensionName, Lists.newArrayList((Object[])new EObject[]{context, type}));
                }
                catch (NoSuchExtensionException noSuchExtensionException) {}
                if (result != null) {
                    return result;
                }
                if (context.eContainer() != null) {
                    return this.getScope(context.eContainer(), type);
                }
                this.computeDefaultScope(context, type);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error invoking scope extension", e);
            return null;
        }
    }

    protected IScope computeDefaultScope(EObject ctx, EReference reference) {
        return this.defaultScopeProvider.getScope(ctx, reference);
    }

    protected IScope computeDefaultScope(EObject ctx, EClass type) {
        return this.defaultScopeProvider.getScope(ctx, type);
    }

    private String extensionName(EObject context, EReference reference) {
        return this.extensionName(context, reference.getEReferenceType());
    }

    private String extensionName(EObject context, EClass type) {
        return SCOPE_EXTENSION_PREFIX + type.getName();
    }

    protected String getMasterXtendFileName() {
        return this.extensionFile;
    }
}

