/*
 *    ALMA - Atacama Large Millimiter Array
 *    (c) European Southern Observatory, 2002
 *    Copyright by ESO (in the framework of the ALMA collaboration),
 *    All rights reserved
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *    MA 02111-1307  USA
 *
 */
package alma.userrepository.addressbook.acs;

import java.util.ArrayList;
import java.util.List;

import alma.userrepository.addressbook.ldap.beans.LdapUser;
import alma.userrepository.roledirectory.Role;
import alma.userrepository.roledirectory.RoleDirectory;
import alma.xmljbind.userrepository.user.UserRoleStruct;

;

public class AcsUser extends alma.xmljbind.userrepository.user.User implements
        alma.userrepository.domainmodel.User {
    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public AcsUser(alma.xmljbind.userrepository.user.User user) {
        this.setFirstName(user.getFirstName());
        this.setFullName(user.getFullName());
        this.setNotes(user.getNotes());
        this.setSurname(user.getSurname());
        this.setUid(user.getUid());
        this.setModifiedTimestamp(user.getModifiedTimestamp());
        this.setRolesArray(user.getRolesArray());
    }

    public AcsUser(alma.userrepository.domainmodel.User user) {
        this.setFirstName(user.getFirstName());
        this.setFullName(user.getFullName());
        this.setNotes(user.getNotes());
        this.setSurname(user.getSurname());
        this.setUid(user.getUid());

        setRoles(user.getRoles());

        // LDAP beans have modification timestamp to import
        if (user instanceof LdapUser) {
            this.setModifiedTimestamp(((LdapUser) user).getModifiedTimestamp());
        }
    }

    public alma.xmljbind.userrepository.user.User getCastor() {
        alma.xmljbind.userrepository.user.User user = new alma.xmljbind.userrepository.user.User();

        user.setFirstName(getFirstName());
        user.setFullName(getFullName());
        user.setNotes(getNotes());
        user.setSurname(getSurname());
        user.setUid(getUid());
        user.setModifiedTimestamp(getModifiedTimestamp());

        user.setRolesArray(getRolesArray());

        return user;
    }

    public alma.userrepository.addressbook.ldap.beans.LdapUser getLdapUser() {
        alma.userrepository.addressbook.ldap.beans.LdapUser user = new alma.userrepository.addressbook.ldap.beans.LdapUser();

        user.setFirstName(getFirstName());
        user.setFullName(getFullName());
        user.setNotes(getNotes());
        user.setSurname(getSurname());
        user.setUid(getUid());
        user.setModifiedTimestamp(getModifiedTimestamp());

        user.setRoles(getRoles());

        return user;
    }

    public RoleDirectory getRoles() {
        RoleDirectory outDirectory = new RoleDirectory(getUid());
        for (UserRoleStruct roleStruct : getRolesArray()) {
            String appName = roleStruct.getApplicationName();
            for (String role : roleStruct.getRolesArray()) {
                outDirectory.add(new Role(appName, role));
            }
        }
        return outDirectory;
    }

    public void setRoles(RoleDirectory inDirectory) {
        List<UserRoleStruct> structList = new ArrayList<UserRoleStruct>();
        for (String appName : inDirectory.getApplicationNames()) {
            List<String> roleList = new ArrayList<String>();
            for (Role role : inDirectory.getRoles(appName)) {
                roleList.add(role.getRoleName());
            }
            UserRoleStruct struct = new UserRoleStruct();
            structList.add(struct);
            struct.setApplicationName(appName);
            struct.setRolesArray(roleList.toArray(new String[0]));
        }
        this.setRolesArray(structList.toArray(new UserRoleStruct[0]));
    }

    @Override
    public boolean hasRole(Role inRole) {
        boolean outValue = false;
        if (getRoles() != null) {
            outValue = getRoles().hasRole(inRole);
        }
        return outValue;
    }
}
