/**
 * This is pojo class that models the MonitorPoint Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version $Id: MonitorPoint.java,v 1.1.2.1 2010/04/28 20:45:19 rtobar Exp $
 * @since May2009
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;

@Entity
@NamedQueries({
@NamedQuery(
  name="findMonitorPointIdByAssemblyIdANDBACIPropertyIdANDIndex",
  query="SELECT m FROM MonitorPoint m WHERE m.assemblyId = :assemblyId AND m.baciPropertyId = :baciPropertyId AND m.index= :index"
  ),
@NamedQuery(
  name="findMonitorPointIdByAssemblyIdANDBACIPropertyId",
  query="SELECT m FROM MonitorPoint m WHERE m.assemblyId = :assemblyId AND m.baciPropertyId = :baciPropertyId "
  ),
@NamedQuery(
  name="findMonitorPointByAssemblyId",
  query="SELECT m FROM MonitorPoint m WHERE m.assemblyId = :assemblyId  "
  ) ,
@NamedQuery(
  name="findMonitorPointByBACIPropertyId",
  query="SELECT m FROM MonitorPoint m WHERE m.baciPropertyId = :baciPropertyId  "
  ),  
@NamedQuery(
  name="findMAXMonitorPointId",
  query="SELECT MAX(m.monitorPointId) FROM MonitorPoint m"
  ),
@NamedQuery(
  name="findMonitorPointNameGivenMonitorPointId",
  query="SELECT m.monitorPointName FROM MonitorPoint m WHERE m.monitorPointId= :monitorPointId"
  ),
@NamedQuery(
  name="findDatatypeGivenMonitorPointId",
  query="SELECT m.datatype FROM MonitorPoint m WHERE m.monitorPointId= :monitorPointId")
})
@Table(name = "MONITORPOINT")
public class MonitorPoint{
    @SequenceGenerator(name = "USER_MONITORPOINT_GENERATOR",
            sequenceName = "MonitorPoint_seq",
            allocationSize = 1)
  @Id 
    @GeneratedValue(strategy = GenerationType.SEQUENCE,
            generator = "USER_MONITORPOINT_GENERATOR")
  @Column(name="MONITORPOINTID", nullable=false)
  private Long monitorPointId;
  @Column(name="BACIPROPERTYID", nullable=false)
  private Long baciPropertyId;
  @Column(name="MONITORPOINTNAME", nullable=false)
  private String monitorPointName;
  @Column(name="ASSEMBLYID", nullable=false)
  private Long assemblyId;
  @Column(name="INDICE", nullable=false)
  private Integer index;
  @Column(name="DATATYPE", nullable=false)
  private String datatype;
  @Column(name="RCA", nullable=false)
  private String rca;
  @Column(name="TERELATED", nullable=false)
  private int teRelated;
  @Column(name="RAWDATATYPE", nullable=false)
  private String rawDatatype;
  @Column(name="WORLDDATATYPE", nullable=false)
  private String worldDatatype;
  @Column(name="UNITS", nullable=true)
  private String units;
  @Column(name="SCALE", nullable=true)
  private Double scale;
  @Column(name="OFFSET", nullable=true)
  private Double offset;
  @Column(name="MINRANGE", nullable=true)
  private String minRange;
  @Column(name="MAXRANGE", nullable=true)
  private String maxRange;
  @Column(name="DESCRIPTION", nullable=false)
  private String description;
  
    public MonitorPoint() {
    }
  
  public void  setMonitorPointId(Long monitorPointId){
    this.monitorPointId=monitorPointId;
    
  }
  public Long getMonitorPointId(){
    return this.monitorPointId;
    
  }
  
  public void  setBaciPropertyId(Long baciPropertyId){
    this.baciPropertyId=baciPropertyId;
    
  }
  public Long getBaciPropertyId(){
    return this.baciPropertyId;
    
  }
  
  public void setMonitorPointName(String monitorPointName){
    this.monitorPointName=monitorPointName;
  }
  
  public String getMonitorPointName(){
    return this.monitorPointName;
  }
  public void  setAssemblyId(Long assemblyId){
    this.assemblyId=assemblyId;
    
  }
  public Long getAssemblyId(){
    return this.assemblyId;
    
  }
  
  public void  setIndex(Integer index){
      this.index=index;
      
    }
      
    public Integer getIndex() {
        return this.index;

    }

  public void setDatatype(String datatype){
    this.datatype=datatype;
  }
  
  public String getDatatype(){
    return this.datatype;
  }
  
  public void setRCA(String rca){
    this.rca=rca;
  }
  
  public String getRCA(){
    return this.rca;
  }
  public void setTERelated(int teRelated){
    this.teRelated=teRelated;
  }
  
  public int getTERelated(){
    return this.teRelated;
  }
  
  public void setRawDatatype(String rawDatatype){
    this.rawDatatype=rawDatatype;
  }
  
  public String getRawDatatype(){
    return this.rawDatatype;
  }

  
  public void setWorldDatatype(String worldDatatype){
    this.worldDatatype=worldDatatype;
  }
  
  public String getWorldDatatype(){
    return this.worldDatatype;
  }
  
  public void setUnits(String units){
    this.units=units;
  }
  
  public String getUnits(){
    return this.units;
  }
  
  public void setScale(Double scale){
    this.scale=scale;
  }
  
  public Double getScale(){
    return this.scale;
  }
  
  
  public void setOffset(Double offset){
    this.offset=offset;
  }
  
  public Double getOffset(){
    return this.offset;
  }
  
  public void setMinRange(String minRange){
    this.minRange=minRange;
  }
  
  public String getMinRange(){
    return this.minRange;
  }
  public void setMaxRange(String maxRange){
    this.maxRange=maxRange;
  }
  
  public String getMaxRange(){
    return this.maxRange;
  }
  public void setDescription(String description){
    this.description=description;
  }
  
  public String getDescription(){
    return this.description;
  }
}