/**
 * This is pojo class that models the composite primary key
 * found in the DataModel (Table MonitorData)
 * @author Pablo Burgos
 * @version $Id: MonitorDataPK.java,v 1.1.2.1 2010/04/28 20:45:19 rtobar Exp $
 * @since ACS-8_0_0-B
 *
 *
 */
package alma.archive.tmcdb.Persistence.pojo;

import java.sql.Timestamp;
import java.io.Serializable;

public class MonitorDataPK implements Serializable{

	private static final long serialVersionUID = -2914313938392724706L;

	Long monitorPointId;
    Timestamp monitorTs;
    
    public MonitorDataPK() {}
    
    public boolean equals(Object other) {
        if (other instanceof MonitorDataPK) {
            final MonitorDataPK otherMonitorDataPK = (MonitorDataPK)other;
            return (otherMonitorDataPK.monitorPointId.equals(monitorPointId) &&
                otherMonitorDataPK.monitorTs.equals(monitorTs));
        }
        return false;
    }
    public int hashCode() {
        return super.hashCode();
    }

    public Long getMonitorPointId(){
        return this.monitorPointId;
    }
    public void setMonitorPointId(Long monitorPointId){
        this.monitorPointId=monitorPointId;

    }
    public Timestamp getMonitorTs(){
        return this.monitorTs;
    }
    public void setMonitorTs(Timestamp monitorTs){
        this.monitorTs=monitorTs;
    }
}


