/**
 * This is pojo class that models the MonitorData Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author Pablo Burgos
 * @version $Id: MonitorData.java,v 1.1.2.1 2010/04/28 20:45:19 rtobar Exp $
 * @since ACS-8_0_0-B
 *
 *
 */
package alma.archive.tmcdb.Persistence.pojo;


import java.sql.Timestamp;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@IdClass(MonitorDataPK.class)
@NamedQueries({
        @NamedQuery(
                name = "findMonitorDataByMonitorPointIdAndTimestampRange",
                query = "SELECT m FROM MonitorData m WHERE m.monitorPointId =:monitorPointId AND m.monitorTs> :startTimestamp AND m.monitorTs< :stopTimestamp"
        ),
        @NamedQuery(
                name = "getMaxRowResultsMonitorData",
                query = "SELECT COUNT(m.monitorPointId) FROM MonitorData m WHERE m.monitorPointId =:monitorPointId AND m.monitorTs> :startTimestamp AND m.monitorTs< :stopTimestamp"
        ),
        @NamedQuery(
                name = "getMaxSampleResultsMonitorData",
                query = "SELECT SUM(m.sampleSize) FROM MonitorData m WHERE m.monitorPointId =:monitorPointId AND m.monitorTs> :startTimestamp AND m.monitorTs< :stopTimestamp")
})
@Table(name = "MONITORDATA")
public class MonitorData {
    @Id
    @Column(name="MONITORPOINTID", nullable=false)
    protected Long monitorPointId;

    @Id
    @Column(name="MONITORTS", nullable=false)
    protected Timestamp monitorTs;


    @Column(name = "STARTTIME", nullable = false)
    protected Long startTime;

    @Column(name = "ENDTIME", nullable = false)
    protected Long endTime;

    @Column(name = "SAMPLESIZE", nullable = false)
    protected Integer sampleSize;

    @Column(name = "MONITORCLOB", nullable = false)
    @Lob
    @Basic(fetch = FetchType.LAZY)
    protected String monitorClob;

    @Column(name = "MINSTAT", nullable = true)
    protected Double minStat;

    @Column(name = "MAXSTAT", nullable = true)
    protected Double maxStat;

    @Column(name = "MEANSTAT", nullable = true)
    protected Double meanStat;

    @Column(name = "STDDEVSTAT", nullable = true)
    protected Double stdDevStat;


    public MonitorData() {
    }

    public Long getMonitorPointId() {
        return this.monitorPointId;
    }

    public void setMonitorPointId(Long monitorPointId) {
        this.monitorPointId = monitorPointId;

    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;

    }

    public Long getEndTime() {
        return this.endTime;

    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Timestamp getMonitorTs() {
        return this.monitorTs;
    }

    public void setMonitorTs(Timestamp monitorTs) {
        this.monitorTs = monitorTs;
    }

    public Integer getSampleSize() {
        return this.sampleSize;

    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getMonitorClob() {
        return this.monitorClob;
    }

    public void setMonitorClob(String monitorClob) {
        this.monitorClob = monitorClob;
    }

    public Double getMinStat() {
        return this.minStat;
    }

    public void setMinStat(Double minStat) {
        this.minStat = minStat;
    }

    public Double getMaxStat() {
        return this.maxStat;
    }

    public void setMaxStat(Double maxStat) {
        this.maxStat = maxStat;
    }

    public Double getMeanStat() {
        return this.meanStat;
    }

    public void setMeanStat(Double meanStat) {
        this.meanStat = meanStat;
    }

    public Double getStdDevStat() {
        return this.stdDevStat;
    }

    public void setStdDevStat(Double stdDevStat) {
        this.stdDevStat = stdDevStat;
    }
}
