/**
 * This is pojo class that models the LRUType Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;

import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;

@Entity
@Table(name = "LRUTYPE")
public class LRUType {
  @Id
  @Column(name = "LRUNAME", nullable = false)
  private String lruName;
  @Column(name = "FULLNAME", nullable = false)
  private String fullName;
  @Column(name = "ICD", nullable = false)
  private String icd;
  @Column(name = "ICDDATE", nullable = false)
  private Long icdDate;
  @Column(name = "DESCRIPTION", nullable = false)
  private String description;
  @Column(name = "NOTES", nullable = true)
  private String notes;

  public LRUType() {
  }

  public void setLRUName(String lruName) {
    this.lruName = lruName;
  }

  public String getLRUName() {
    return this.lruName;
  }

  public void setFullName(String fullName) {
    this.fullName = fullName;
  }

  public String getFullName() {
    return this.fullName;
  }
  
  public void setICD(String icd) {
    this.icd = icd;
  }

  public String getICD() {
    return this.icd;
  }
  
  public void setICDDate(Long icdDate){
    this.icdDate=icdDate;
    
  }
  public Long getICDDate(){
    return this.icdDate;
    
  }
  
  public void setDescription(String description){
    this.description=description;
  }
  public String getDescription(){
    return this.description;
  }
  
  public void setNotes(String notes){
    this.notes=notes;
  }
  public String getNotes(){
    return this.notes;
  }
}
