package alma.archive.tmcdb.Persistence.pojo;

/**
 * This is pojo class that models the HWConfiguration Table in TMC DB Schema
 * It uses EJB3 to implement Persistence.
 * @author Pablo Burgos
 * @version $Id: HWConfiguration.java,v 1.1.2.1 2010/04/28 20:45:19 rtobar Exp $
 *
 *
 */

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@NamedQuery(
		  name="findHwConfBySwConfigId",
		  query="SELECT c FROM HWConfiguration c WHERE c.swConfigurationId= :swConfigurationId")
@Table(name = "HWConfiguration")
public class HWConfiguration {
    @Id
    @Column(name = "CONFIGURATIONID", nullable = false)
    private Long configurationId;
    @Column(name = "SWCONFIGURATIONID", nullable = false)
    private Long swConfigurationId;

    public HWConfiguration() {
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public void setSWConfigurationId(Long swConfigurationId) {
        this.swConfigurationId = swConfigurationId;
    }

    public Long getSWConfigurationId() {
        return this.swConfigurationId;
    }


}
