/**
 * This is pojo class that models the DefaultMonitorPoint Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
 
@Entity
@NamedQueries({
@NamedQuery(
  name="findDefaultMonitorPointListByDefaultBACIPropId",
  query="SELECT m FROM DefaultMonitorPoint m WHERE m.defaultBaciPropertyId = :defaultBACIPropertyId AND m.index =:index"
  )
})
@Table(name = "DEFAULTMONITORPOINT")
public class DefaultMonitorPoint{
  @Id 
  @Column(name="DEFAULTMONITORPOINTID", nullable=false)
  private Long defaultMonitorPointId;
  @Column(name="DEFAULTBACIPROPERTYID", nullable=false)
  private Long defaultBaciPropertyId;
  @Column(name="MONITORPOINTNAME", nullable=false)
  private String monitorPointName;
  @Column(name="INDICE", nullable=false)
  private Integer index;
  @Column(name="DATATYPE", nullable=false)
  private String datatype;
  @Column(name="RCA", nullable=false)
  private String rca;
  @Column(name="TERELATED", nullable=false)
  private int teRelated;
  @Column(name="RAWDATATYPE", nullable=false)
  private String rawDatatype;
  @Column(name="WORLDDATATYPE", nullable=false)
  private String worldDatatype;
  @Column(name="UNITS", nullable=true)
  private String units;
  @Column(name="SCALE", nullable=true)
  private Double scale;
  @Column(name="OFFSET", nullable=true)
  private Double offset;
  @Column(name="MINRANGE", nullable=true)
  private String minRange;
  @Column(name="MAXRANGE", nullable=true)
  private String maxRange;
  @Column(name="DESCRIPTION", nullable=false)
  private String description;
  
  public DefaultMonitorPoint(){}
  
  public void  setMonitorPointId(Long defaultMonitorPointId){
    this.defaultMonitorPointId=defaultMonitorPointId;
    
  }
  public Long getDefaultMonitorPointId(){
    return this.defaultMonitorPointId;
    
  }
  
  public void  setDefaultBaciPropertyId(Long defaultBaciPropertyId){
    this.defaultBaciPropertyId=defaultBaciPropertyId;
    
  }
  public Long getDefaultBaciPropertyId(){
    return this.defaultBaciPropertyId;
    
  }
  
  public void setMonitorPointName(String monitorPointName){
    this.monitorPointName=monitorPointName;
  }
  
  public String getMonitorPointName(){
    return this.monitorPointName;
  }

  
  public void  setIndex(Integer index){
      this.index=index;
      
    }
  public Integer getIndex(){
      return this.index;
      
    }

  public void setDatatype(String datatype){
    this.datatype=datatype;
  }
  
  public String getDatatype(){
    return this.datatype;
  }
  
  public void setRCA(String rca){
    this.rca=rca;
  }
  
  public String getRCA(){
    return this.rca;
  }
  public void setTERelated(int teRelated){
    this.teRelated=teRelated;
  }
  
  public int getTERelated(){
    return this.teRelated;
  }
  
  public void setRawDatatype(String rawDatatype){
    this.rawDatatype=rawDatatype;
  }
  
  public String getRawDatatype(){
    return this.rawDatatype;
  }

  
  public void setWorldDatatype(String worldDatatype){
    this.worldDatatype=worldDatatype;
  }
  
  public String getWorldDatatype(){
    return this.worldDatatype;
  }
  
  public void setUnits(String units){
    this.units=units;
  }
  
  public String getUnits(){
    return this.units;
  }
  
  public void setScale(Double scale){
    this.scale=scale;
  }
  
  public Double getScale(){
    return this.scale;
  }
  
  
  public void setOffset(Double offset){
    this.offset=offset;
  }
  
  public Double getOffset(){
    return this.offset;
  }
  
  public void setMinRange(String minRange){
    this.minRange=minRange;
  }
  
  public String getMinRange(){
    return this.minRange;
  }
  public void setMaxRange(String maxRange){
    this.maxRange=maxRange;
  }
  
  public String getMaxRange(){
    return this.maxRange;
  }
  public void setDescription(String description){
    this.description=description;
  }
  
  public String getDescription(){
    return this.description;
  }
}
