/**
 * This is pojo class that models the DefaultComponent Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.FetchType;
import javax.persistence.Basic;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

@Entity
@NamedQueries({
@NamedQuery(
  name="findDefaultComponentByLikeAssemblyTypeName",
  query="SELECT c FROM DefaultComponent c WHERE c.assemblyTypeName like :assemblyTypeName"
  )

})

@Table(name = "DEFAULTCOMPONENT")
public class DefaultComponent{
  @Id
  @Column(name ="DEFAULTCOMPONENTID", nullable=false)
  private Long defaultComponentId;
  @Column(name = "COMPONENTTYPEID", nullable=false)
  private Long componentTypeId;
  @Column(name = "ASSEMBLYTYPENAME", nullable=false)
  private String assemblyTypeName;
  @Column (name="IMPLLANG", nullable=false)
  private String implLang;
  @Column (name="REALTIME", nullable=false)
  private Integer realTime;
  @Column (name="CODE", nullable=false)
  private String code;
  @Column (name="PATH", nullable=false)
  private String path;
  @Column (name="ISAUTOSTART", nullable=false)
  private Integer isAutoStart;
  @Column (name="ISDEFAULT", nullable=false)
  private Integer isDefault;
  @Column (name="ISSTANDALONEDEFINED", nullable=true)
  private Integer isStandaloneDefined;
  @Column (name="KEEPALIVETIME", nullable=false)
  private Integer keepAliveTime;
  @Column (name="MINLOGLEVEL", nullable=false)
  private Integer minLogLevel;
  @Column (name="MINLOGLEVELLOCAL", nullable=false)
  private Integer minLogLevelLocal;
  @Column (name="XMLDOC", nullable=true)
  @Lob
  @Basic(fetch=FetchType.LAZY)
  private String xmlDoc;

  
  public DefaultComponent(){}
 
  public void setDefaultComponentId(Long defaultComponentId){
    this.defaultComponentId=defaultComponentId;
  }
  public Long getDefaultComponentId(){
    return this.defaultComponentId;
  }
  public void  setComponentTypeId(Long componentTypeId){
    this.componentTypeId=componentTypeId;
    
  }
  public Long getComponentTypeId(){
    return this.componentTypeId;
    
  }
  
  public void setAssemblyName(String assemblyTypeName){
    this.assemblyTypeName=assemblyTypeName;
  }
  
  public String getAssemblyName(){
    return this.assemblyTypeName;
  }
  

  public void setImplLang(String implLang){
    this.implLang=implLang;
  }
  public String getImplLang(){
    return this.implLang;
  }
  
  public void setRealTime(Integer realTime){
    this.realTime=realTime;
  }
  
  public Integer getRealTime(){
    return this.realTime;
  }
  
  public void setCode(String code){
    this.code=code;
  }
  public String getCode(){
    return this.code;
  }

  public void setPath(String path){
    this.path=path;
  }
  public String getPath(){
    return this.path;
  }

  public void setIsAutoStart(Integer isAutoStart){
    this.isAutoStart=isAutoStart;
  }
  
  public Integer getIsAutoStart(){
    return this.isAutoStart;
  }
  public void setIsDefault(Integer isDefault){
    this.isDefault=isDefault;
  }
  
  public Integer getIsDefault(){
    return this.isDefault;
  }
  public void setIsStandaloneDefined(Integer isStandaloneDefined){
    this.isStandaloneDefined=isStandaloneDefined;
  }
  
  public Integer getIsStandaloneDefined(){
    return this.isStandaloneDefined;
  }

    public void setKeepAliveTime(Integer keepAliveTime){
      this.keepAliveTime=keepAliveTime;
    }
    
    public Integer getKeepAliveTime(){
      return this.keepAliveTime;
    }

    public void setMinLogLevel(Integer minLogLevel){
      this.minLogLevel=minLogLevel;
    }
    
    public Integer getMinLogLevel(){
      return this.minLogLevel;
    }

    public void setMinLogLevelLocal(Integer minLogLevelLocal){
      this.minLogLevelLocal=minLogLevelLocal;
    }
    
    public Integer getMinLogLevelLocal(){
      return this.minLogLevelLocal;
    }

    public void setXmlDoc(String xmlDoc){
      this.xmlDoc=xmlDoc;
    }

    public String getXmlDoc(){
      return this.xmlDoc;
    }
             
}