/**
 * This is pojo class that models the DefaultBACIProperty in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;


@Entity
@NamedQueries({
@NamedQuery(
  name="findDefaultBACIPropertyByDefaultComponentId",
  query="SELECT b FROM DefaultBACIProperty b WHERE b.defaultComponentId =:defaultComponentId AND b.propertyName =:propertyName"
  )
})
@Table(name = "DEFAULTBACIPROPERTY")
public class DefaultBACIProperty{
  @Id
  @Column(name ="DEFAULTBACIPROPID", nullable=false)
  private Long defaultBaciPropertyId;
  @Column(name="DEFAULTCOMPONENTID", nullable=false)
  private Long defaultComponentId;
  @Column(name="PROPERTYNAME", nullable=false)
  private String propertyName;
  @Column(name="DESCRIPTION", nullable=false)
  private String description;
  //@Column(name="ISSEQUENCE", nullable=false)
  //private Integer isSequence;
  @Column(name="FORMAT", nullable=false)
  private String format;
  @Column(name="UNITS", nullable=false)
  private String units;
  @Column(name="RESOLUTION", nullable=false)
  private Integer resolution;
  @Column(name="ARCHIVE_PRIORITY", nullable=false)
  private Integer archivePriority;
  @Column(name="ARCHIVE_MIN_INT", nullable=false)
  private Double archiveMinInt;
  @Column(name="ARCHIVE_MAX_INT", nullable=false)
  private Double archiveMaxInt;
  @Column(name="DEFAULT_TIMER_TRIG", nullable=false)
  private Double defaultTimerTrig;
  @Column(name="MIN_TIMER_TRIG", nullable=false)
  private Double minTimerTrig;
  @Column(name="INITIALIZE_DEVIO", nullable=false)
  private Integer initializeDEVIO;
  @Column(name="MIN_DELTA_TRIG", nullable=false)
  private Double minDeltaTrig;
  @Column(name="DEFAULT_VALUE", nullable=false)
  private String defaultValue;
  @Column(name="GRAPH_MIN", nullable=true)
  private Double graphMin;
  @Column(name="GRAPH_MAX", nullable=true)
  private Double graphMax;
  @Column(name="MIN_STEP", nullable=true)
  private Double minStep;
  @Column(name="ARCHIVE_DELTA", nullable=false)
  private Double archiveDelta;
  @Column(name="ALARM_HIGH_ON", nullable=true)
  private Double alarmHighOn;
  @Column(name="ALARM_LOW_ON", nullable=true)
  private Double alarmLowOn;
  @Column(name="ALARM_HIGH_OFF", nullable=true)
  private Double alarmHighOff;
  @Column(name="ALARM_LOW_OFF", nullable=true)
  private Double alarmLowOff;
  @Column(name="ALARM_TIMER_TRIG", nullable=true)
  private Double alarmTimerTrig;
  @Column(name="MIN_VALUE", nullable=true)
  private Double minValue;
  @Column(name="MAX_VALUE", nullable=true)
  private Double maxValue;
  @Column(name="BITDESCRIPTION", nullable=true)
  private String bitDescription;
  @Column(name="WHENSET", nullable=true)
  private String whenSet;
  @Column(name="WHENCLEARED", nullable=true)
  private String whenCleared;
  @Column(name="STATESDESCRIPTION", nullable=true)
  private String statesDescription;
  @Column(name="CONDITION", nullable=true)
  private String condition;
  @Column(name="ALARM_ON", nullable=true)
  private String alarmOn;
  @Column(name="ALARM_OFF", nullable=true)
  private String alarmOff;
  @Column(name="DATA", nullable=true)
  private String data;
  
  public DefaultBACIProperty(){}
  
  public void  setDefaultBACIPropertyId(Long defaultBaciPropertyId){
    this.defaultBaciPropertyId=defaultBaciPropertyId;
    
  }
  public Long getDefaultBACIPropertyId(){
    return this.defaultBaciPropertyId;
    
  }
  
  public void  setDefaultComponentId(Long defaultComponentId){
    this.defaultComponentId=defaultComponentId;
    
  }
  public Long getDefaultComponentId(){
    return this.defaultComponentId;
    
  }
  
  public void setPropertyName(String propertyName){
    this.propertyName=propertyName;
  }
  
  public String getPropertyName(){
    return this.propertyName;
  }
  
  public void setDescription(String description){
    this.description=description;
  }
  
  public String getDescription(){
    return this.description;
  }
 /* public void setIsSequence(Integer isSequence){
      this.isSequence=isSequence;
    }
    
  public Integer getIsSequence(){
     return this.isSequence;
   }
   */ 

  public void setFormat(String format){
    this.format=format;
  }
  
  public String getFormat(){
    return this.format;
  }
  public void setUnits(String units){
    this.units=units;
  }
  
  public String getUnits(){
    return this.units;
  }
  
  public void setResolution(Integer resolution){
    this.resolution=resolution;
  }
  
  public Integer getResolution(){
    return this.resolution;
  }
  
  public void setArchivePriority(Integer archivePriority){
    this.archivePriority=archivePriority;
  }
  
  public Integer getArchivePriority(){
    return this.archivePriority;
  }
  
  public void setArchiveMinInt(Double archiveMinInt){
    this.archiveMinInt=archiveMinInt;
  }
  
  public Double getArchiveMinInt(){
    return this.archiveMinInt;
  }
  
  public void setArchiveMaxInt(Double archiveMaxInt){
    this.archiveMaxInt=archiveMaxInt;
  }
  
  public Double getArchiveMaxInt(){
    return this.archiveMaxInt;
  }
  
  public void setDefaultTimerTrig(Double defaultTimerTrig){
    this.defaultTimerTrig=defaultTimerTrig;
  }
  
  public Double getDefaultTimerTrig(){
    return this.defaultTimerTrig;
  }
  
  
  public void setMinTimerTrig(Double minTimerTrig){
    this.minTimerTrig=minTimerTrig;
  }
  
  public Double getMinTimerTrig(){
    return this.minTimerTrig;
  }
  
  public void setInitializeDEVIO(Integer initializeDEVIO){
    this.initializeDEVIO=initializeDEVIO;
  }
  
  public Integer getInitializeDEVIO(){
    return this.initializeDEVIO;
  }
  
  public void setMinDeltaTrig(Double minDeltaTrig){
    this.minDeltaTrig=minDeltaTrig;
  }
  
  public Double getMinDeltaTrig(){
    return this.minDeltaTrig;
  }
  
  public String getDefaultValue(){
    return this.defaultValue;
  }
  public void setDefaultValue(String defaultValue){
    this.defaultValue=defaultValue;
  }
  
  public void setGraphMin(Double graphMin){
    this.graphMin=graphMin;
  }
  
  public Double getGraphMin(){
    return this.graphMin;
  }
  
  public void setGraphMax(Double graphMax){
    this.graphMax=graphMax;
  }
  
  public Double getGraphMax(){
    return this.graphMax;
  }
  
  public void setMinStep(Double minStep){
    this.minStep=minStep;
  }
  
  public Double getMinStep(){
    return this.minStep;
  }
  
  public void setArchiveDelta(Double archiveDelta){
    this.archiveDelta=archiveDelta;
  }
  
  public Double getArchiveDelta(){
    return this.archiveDelta;
  }
  
  public void setAlarmHighOn(Double alarmHighOn){
    this.alarmHighOn=alarmHighOn;
  }
  
  public Double getAlarmHighOn(){
    return this.alarmHighOn;
  }
  
  
  public void setAlarmLowOn(Double alarmLowOn){
    this.alarmLowOn=alarmLowOn;
  }
  
  public Double getAlarmLowOn(){
    return this.alarmLowOn;
  }
  public void setAlarmHighOff(Double alarmHighOff){
    this.alarmHighOff=alarmHighOff;
  }
  
  public Double getAlarmHighOff(){
    return this.alarmHighOff;
  }
  
  
  public void setAlarmLowOff(Double alarmLowOff){
    this.alarmLowOff=alarmLowOff;
  }
  
  public Double getAlarmLowOff(){
    return this.alarmLowOff;
  }
  public void setAlarmTimerTrig(Double alarmTimerTrig){
    this.alarmTimerTrig=alarmTimerTrig;
  }
  
  public Double getAlarmTimerTrig(){
    return this.alarmTimerTrig;
  }
  
  public void setMinValue(Double minValue){
    this.minValue=minValue;
  }
  
  public Double getMinValue(){
    return this.minValue;
  }
  
  public void setMaxValue(Double maxValue){
    this.maxValue=maxValue;
  }
  
  public Double getMaxValue(){
    return this.maxValue;
  }
  public void setBitDescription(String bitDescription){
    this.bitDescription=bitDescription;
  }
  
  public String getBitDescription(){
    return this.bitDescription;
  }
  
  
  public void setWhenSet(String whenSet){
    this.whenSet=whenSet;
  }
  
  public String getWhenSet(){
    return this.whenSet;
  }
  
  public void setWhenCleared(String whenCleared){
    this.whenCleared=whenCleared;
  }
  
  public String getWhenCleared(){
    return this.whenCleared;
  }
  
  public void setStatesDescription(String statesDescription){
    this.statesDescription=statesDescription;
  }
  
  public String getStatesDescription(){
    return this.statesDescription;
  }
  
  public void setCondition(String condition){
    this.condition=condition;
  }
  
  public String getCondition(){
    return this.condition;
  }
  
  public void setAlarmOn(String alarmOn){
    this.alarmOn=alarmOn;
  }
  
  public String getAlarmOn(){
    return this.alarmOn;
  }
  
  public void setAlarmOff(String alarmOff){
    this.alarmOff=alarmOff;
  }
  
  public String getAlarmOff(){
    return this.alarmOff;
  }
  public void setData(String data){
    this.data=data;
  }
  
  public String getData(){
    return this.data;
  }
  
  
}
