/**
 * This is pojo class that models the Configuration Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@NamedQuery(
  name="findConfigurationByName",
  query="SELECT conf FROM Configuration conf WHERE conf.configurationName= :configurationName")
@Table(name = "CONFIGURATION")
public class Configuration {
  @Id 
  @Column(name = "CONFIGURATIONID",nullable=false)
  private Long configurationId;
  @Column(name = "CONFIGURATIONNAME",nullable=false)
  private String configurationName;
  @Column(name = "FULLNAME",nullable=false)
  private String fullName;
  @Column(name = "ACTIVE",nullable=false)
  private Integer active;
  @Column(name = "CREATIONTIME",nullable=false)
  private Timestamp creationTime;
  @Column(name = "DESCRIPTION", nullable=false)
  private String description;
  
  //default constructor needed by hibernate
  //Hibernate use reflection on this constructor to instantiate objects
  public Configuration(){}
 
  public void setConfigurationId(Long configurationId){
    this.configurationId=configurationId;
  }
  public Long getConfigurationId(){
    return this.configurationId;
  }
  public void setConfigurationName(String configurationName){
    this.configurationName=configurationName;
  }
  public String getConfigurationName(){
    return configurationName;
    
  }
  public void setFullName(String fullName){
    this.fullName=fullName;
  }
  public String getFullName(){
    return this.fullName;
  }
  public void setActive(Integer active){
    this.active=active;
  }
  public Integer getActive(){
    return this.active;
  }
  public void setCreationTime(Timestamp creationTime){
    this.creationTime=creationTime;
    
  }
  public Timestamp getCreationTime(){
    return this.creationTime;
  }
  public void setDescription(String description){
    this.description=description;
  }
  public String getDescription(){
    return description;
  }
  
}
