/**
 * This is pojo class that models the ComponentType Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@NamedQueries({
@NamedQuery(
  name="findComponentTypeBylikeIDL",
  query="SELECT ct FROM ComponentType ct WHERE ct.idl like :idl"
  )  
})
@Table(name = "COMPONENTTYPE")
public class ComponentType {
  @Id 
  @Column(name="COMPONENTTYPEID", nullable=false)
  private Long componentTypeId;
  @Column(name="IDL", nullable=false)
  private String idl;
  @Column(name="URN", nullable=true)
  private String urn;

  public ComponentType() {
  }
  
  public void setComponentTypeId(Long componentTypeId){
    this.componentTypeId=componentTypeId;
    
  }
  public Long getComponentTypeId(){
    return this.componentTypeId;
    
  }
  public void setIdl(String idl){
    this.idl=idl;
  }
  public String getIdl(){
    return this.idl;
  }
  public void setUrn(String urn){
    this.urn=urn;
  }
  public String getUrn(){
    return this.urn;
  }
//  //Additional methods
//  public Schemas getSchema(){
//    return this.schema;
//  }
}
