/**
 * This is pojo class that models the Component Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 *
 *
 */

package alma.archive.tmcdb.Persistence.pojo;

import alma.hibernate.util.HibernateXmlType;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

@Entity
@NamedQueries({
        @NamedQuery(
                name = "findComponentByComponentName",
                query = "SELECT c FROM Component c WHERE c.componentName =:componentName AND c.path =:path AND c.configurationId=:configurationId"
        ),

        @NamedQuery(
                name = "findAllComponentsByConfigurationId",
                query = "SELECT c FROM Component c WHERE c.configurationId=:configurationId"
        ),
        @NamedQuery(
                name = "findComponentByComponentId",
                query = "SELECT c FROM Component c WHERE c.componentId=:componentId"
        ),
        @NamedQuery(
                name = "findMAXComponentId",
                query = "SELECT MAX(c.componentId) FROM Component c"
        )

})

@Table(name = "COMPONENT")
@TypeDef(name="xmltype", typeClass=HibernateXmlType.class)
public class Component {
    @SequenceGenerator(name = "USER_COMPONENT_GENERATOR",
            sequenceName = "Component_seq",
            allocationSize = 1)
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE,
            generator = "USER_COMPONENT_GENERATOR")
    @Column(name = "COMPONENTID", nullable = false)
    private Long componentId;
    @Column(name = "COMPONENTTYPEID", nullable = false)
    private Long componentTypeId;
    @Column(name = "COMPONENTNAME", nullable = false)
    private String componentName;
    @Column(name = "CONFIGURATIONID", nullable = false)
    private Long configurationId;
    @Column(name = "CONTAINERID", nullable = true)
    private Long containerId;
    @Column(name = "IMPLLANG", nullable = false)
    private String implLang;
    @Column(name = "REALTIME", nullable = false)
    private Integer realTime;
    @Column(name = "CODE", nullable = false)
    private String code;
    @Column(name = "PATH", nullable = false)
    private String path;
    @Column(name = "ISAUTOSTART", nullable = false)
    private Integer isAutoStart;
    @Column(name = "ISDEFAULT", nullable = false)
    private Integer isDefault;
    @Column(name = "ISSTANDALONEDEFINED", nullable = true)
    private Integer isStandaloneDefined;
    @Column(name = "KEEPALIVETIME", nullable = false)
    private Integer keepAliveTime;
    @Column(name = "ISCONTROL", nullable = false)
    private Integer isControl;
    @Column(name = "MINLOGLEVEL", nullable = false)
    private Integer minLogLevel;
    @Column(name = "MINLOGLEVELLOCAL", nullable = false)
    private Integer minLogLevelLocal;
    @Column(name = "XMLDOC", nullable = true)
    @Basic(fetch = FetchType.LAZY)
    @Type(type="xmltype")
    private String xmlDoc;

    public Component() {
    }


    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public Long getComponentId() {
        return this.componentId;
    }

    public void setComponentTypeId(Long componentTypeId) {
        this.componentTypeId = componentTypeId;

    }

    public Long getComponentTypeId() {
        return this.componentTypeId;

    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public void setContainerId(Long containerId) {
        this.containerId = containerId;
    }

    public Long getContainerId() {
        return this.containerId;
    }

    public void setImplLang(String implLang) {
        this.implLang = implLang;
    }

    public String getImplLang() {
        return this.implLang;
    }

    public void setRealTime(Integer realTime) {
        this.realTime = realTime;
    }

    public Integer getRealTime() {
        return this.realTime;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setIsAutoStart(Integer isAutoStart) {
        this.isAutoStart = isAutoStart;
    }

    public Integer getIsAutoStart() {
        return this.isAutoStart;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public Integer getIsDefault() {
        return this.isDefault;
    }

    public void setIsStandaloneDefined(Integer isStandaloneDefined) {
        this.isStandaloneDefined = isStandaloneDefined;
    }

    public Integer getIsStandaloneDefined() {
        return this.isStandaloneDefined;
    }
    public void setIsControl(Integer isControl) {
        this.isControl = isControl;
    }

    public Integer getIsControl() {
        return this.isControl;
    }


    public void setKeepAliveTime(Integer keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Integer getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setMinLogLevel(Integer minLogLevel) {
        this.minLogLevel = minLogLevel;
    }

    public Integer getMinLogLevel() {
        return this.minLogLevel;
    }

    public void setMinLogLevelLocal(Integer minLogLevelLocal) {
        this.minLogLevelLocal = minLogLevelLocal;
    }

    public Integer getMinLogLevelLocal() {
        return this.minLogLevelLocal;
    }

    public void setXmlDoc(String xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    public String getXmlDoc() {
        return this.xmlDoc;
    }
    

}
