/**
 * This is pojo class that models the AssemblyType Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author  Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 * 
 *
 */
package alma.archive.tmcdb.Persistence.pojo;

import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Lob;
import javax.persistence.Basic;
import javax.persistence.FetchType;

@Entity
@NamedQueries({
@NamedQuery(
  name="findAssemblyTypeByLikeAssemblyCode",
  query="SELECT c FROM AssemblyType c WHERE c.assemblyTypeName like :assemblyTypeName"
  )
})
@Table(name = "ASSEMBLYTYPE")
public class AssemblyType {
  @Id
  @Column(name = "ASSEMBLYTYPENAME", nullable = false)
  private String assemblyTypeName;
  @Column(name = "BASEELEMENTTYPE", nullable = false)
  private String baseElementType;
  @Column(name = "LRUNAME", nullable = false)
  private String lruName;
  @Column(name = "FULLNAME", nullable = false)
  private String fullname;
  @Column(name = "DESCRIPTION", nullable = false)
  private String description;
  @Column(name = "NOTES", nullable = false)
  private String notes;
  @Column(name = "COMPONENTTYPEID", nullable= true)
  private Long componentTypeId;
  
  public AssemblyType() {
  }

  public void setAssemblyTypeName(String assemblyTypeName) {
    this.assemblyTypeName = assemblyTypeName;
  }

  public String getAssemblyTypeName() {
    return this.assemblyTypeName;
  }

  public void setBaseElementType(String baseElementType) {
    this.baseElementType = baseElementType;
  }

  public String getBaseElementType() {
    return this.baseElementType;
  }


  public void setLRUName(String lruName) {
    this.lruName = lruName;
  }

  public String getLRUName() {
    return this.lruName;
  }


  public void setFullName(String fullname) {
    this.fullname = fullname;
  }

  public String getFullName() {
    return this.fullname;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getDescription() {
    return this.description;
  }

  public void setNotes(String notes) {
    this.notes = notes;
  }

  public String getNotes() {
    return this.notes;
  }
  public void setComponentTypeId(Long componentTypeId){
    this.componentTypeId=componentTypeId;
    
  }
  public Long getComponentTypeId(){
    return this.componentTypeId;
    
  }

}
