/**
 * This is pojo class that models the Assembly Table in TMC DB Schema
 * It uses Hibernate to implement Persistence.
 * @author Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 *
 *
 */
package alma.archive.tmcdb.Persistence.pojo;

import javax.persistence.Table;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.Basic;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.SequenceGenerator;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;

import alma.hibernate.util.HibernateXmlType;



@Entity
@NamedQueries({
        @NamedQuery(
                name = "findAssemblyBySerialNumberAndConfigurationId",
                query = "SELECT a FROM Assembly a WHERE UPPER(a.serialNumber) = :serialNumber AND a.configurationId= :configurationId"
        ),
        @NamedQuery(
                name = "findAssemblyByAssemblyIdAndConfigurationId",
                query = "SELECT a FROM Assembly a WHERE a.assemblyId = :assemblyId AND a.configurationId= :configurationId"
        ),
        @NamedQuery(
                name = "findAssemblyByConfigurationId",
                query = "SELECT a FROM Assembly a WHERE a.configurationId= :configurationId"
        ),
        @NamedQuery(
                name = "findMAXAssemblyId",
                query = "SELECT MAX(a.assemblyId) FROM Assembly a"
        )

})
@Table(name = "ASSEMBLY")
@TypeDef(name="xmltype", typeClass=HibernateXmlType.class)
public class Assembly {
    @SequenceGenerator(name = "USER_ASSEMBLY_GENERATOR",
            sequenceName = "Assembly_seq",
             allocationSize = 1)
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE,
            generator = "USER_ASSEMBLY_GENERATOR")
    @Column(name = "ASSEMBLYID", nullable = false)
    private Long assemblyId;
    @Column(name = "ASSEMBLYTYPENAME", nullable = false)
    private String assemblyTypeName;
    @Column(name = "CONFIGURATIONID", nullable = false)
    private Long configurationId;
    @Column(name = "SERIALNUMBER", nullable = false)
    private String serialNumber;
    @Column(name = "DATA", nullable = true)
    @Basic(fetch = FetchType.LAZY)
    @Type(type="xmltype")
    private String data;

    public Assembly() {
    }

    public void setAssemblyId(Long assemblyId) {
        this.assemblyId = assemblyId;

    }

    public Long getAssemblyId() {
        return this.assemblyId;

    }

    public void setAssemblyTypeName(String assemblyTypeName) {
        this.assemblyTypeName = assemblyTypeName;
    }

    public String getAssemblyTypeName() {
        return this.assemblyTypeName;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public void setSerialNumber(String serialNumber) {
        //serial numbers are stored in uppercase
        this.serialNumber = serialNumber.toUpperCase();
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

}