/**
 * This is helper class selects the EntityManager factory on runtime,
 * according to information retrieved from dbConfig.properties files.
 * Supported databases are HSQLDB and ORACLE.
 * @author Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 *
 *
 */
package alma.archive.tmcdb.Persistence.Util;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class TMCDBPersistence {

	private static EntityManagerFactory entityManagerFactory = null;

    public TMCDBPersistence() {
        entityManagerFactory = getEntityManagerFactory();
    }

    public EntityManager getEntityManager() {
        return entityManagerFactory.createEntityManager();
    }

    public void close() {
        if (entityManagerFactory != null) {
            entityManagerFactory.close();
        }
    }


    private EntityManagerFactory getEntityManagerFactory() {

        TMCDBConfig config = TMCDBConfig.getInstance();

        Map<String, String> properties = new HashMap<String, String>();
        // TODO Encrypt password on dbconfig.properties with Jasypt
        properties.put("hibernate.connection.username", config.getDbUser());
        properties.put("hibernate.connection.password", config.getDbPassword());
        properties.put("hibernate.connection.url", config.getDbUrl());

        if (config.getDbType() == TMCDBConfig.DBType.ORACLE) {
            return Persistence.createEntityManagerFactory(
                    "TMCDBOwlDaemonOracle", properties);

        } else {
            // If it's not oracle, assume we are using HSQLDB as backend
            return Persistence.createEntityManagerFactory(
                    "TMCDBOwlDaemonHSQLDB", properties);
        }
    }
}
