/**
 * This is a helper class that is in charge of reading the configuration file (archiveConfig.properties)
 * Information about schema name, username, database url, etc. is located in this file.
 * 
 * @author Pablo Burgos
 * @version %I%,%G%
 * @since ACS-8_0_0-B
 *
 */
package alma.archive.tmcdb.Persistence.Util;

import java.util.logging.Logger;

import alma.archive.database.helpers.DBConfiguration;

public class TMCDBConfig {

    private static TMCDBConfig instance = null;

    public static enum DBType {
        ORACLE, HSQLDB;
    }

    private static DBType dbType;
    private static String dbUser;
    private static String dbPassword;
    private static String dbUrl;
    private static String confName;
    private static String dbConnectionEnabled="true";
    private static String monitoringOnlyEnabled="false";

    private TMCDBConfig() {
        fetchConfiguration();
    }

    public static TMCDBConfig getInstance() {
    	if (instance == null) {
            synchronized (TMCDBConfig.class) {
                if (instance == null) {
                    instance = new TMCDBConfig();
                }
            }
        }
        return instance;
    }

    public String getDbUser() {
        return dbUser;
    }
    
    public String getDbPassword() {
        return dbPassword;
    }

    public String getDbUrl() {
        return dbUrl;

    }

    public DBType getDbType() {
        return dbType;
    }

    public String getConfigurationName() {
        return confName;
    }

    public boolean isDBConnectionEnabled(){
        if (dbConnectionEnabled.equalsIgnoreCase("false")) {
            return false;
        } else {
            return true;
        }
    }
    public boolean isMonitoringOnlyEnabled(){
        if (monitoringOnlyEnabled.equalsIgnoreCase("false")) {
            return false;
        } else {
            return true;
        }
    }


    private void fetchConfiguration() {

    	DBConfiguration dbConfig = null;
    	
    	try {
    		dbConfig = DBConfiguration.instance(Logger.getAnonymousLogger());
    	} catch(Exception e) {
    		throw new RuntimeException("Cannot start TMCDBConfig: ", e);
    	}

		String mode = dbConfig.get("archive.db.mode");
		if( mode.equals("operational") )
			dbType = DBType.ORACLE;
		else if( mode.equals("test") )
			dbType = DBType.HSQLDB;
		else
			throw new RuntimeException("Cannot start TMCDBConfig, invalid 'archive.db.mode' value: " + mode);

		dbUser     = dbConfig.get("archive.tmcdb.user");
		dbPassword = dbConfig.get("archive.tmcdb.passwd");
		dbUrl      = dbConfig.get("archive.tmcdb.connection");

		// RTO: Maybe the property is useless and the only mechanism should be the env variable?
		String envConfiguration = System.getenv("TMCDB_CONFIGURATION_NAME");
		if( envConfiguration != null && envConfiguration.length() > 0 )
			confName = envConfiguration;
		else
			confName = dbConfig.get("archive.tmcdb.configuration");

               dbConnectionEnabled = dbConfig.get("archive.tmcdb.monitoring.enabled");
               if (dbConnectionEnabled==null) dbConnectionEnabled="true";
               monitoringOnlyEnabled = dbConfig.get("archive.tmcdb.monitoring.only");
               if (monitoringOnlyEnabled==null) monitoringOnlyEnabled="false";


    }

}
