package alma.acs.tmcdb;
// Generated Jun 28, 2010 4:49:06 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * NotificationServiceMapping generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="NOTIFICATIONSERVICEMAPPING"
    , uniqueConstraints = @UniqueConstraint(columnNames="CONFIGURATIONID") 
)
public class NotificationServiceMapping extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer notificationServiceMappingId;
     protected Configuration configuration;
     protected String defaultNotificationService;
     private Set<DomainsMapping> domainsMappings = new HashSet<DomainsMapping>(0);
     private Set<ChannelMapping> channelMappings = new HashSet<ChannelMapping>(0);

    public NotificationServiceMapping() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="NotifiSM_seq")}
	)

    
    @Column(name="NOTIFICATIONSERVICEMAPPINGID", unique=true, nullable=false)
    public Integer getNotificationServiceMappingId() {
        return this.notificationServiceMappingId;
    }
    
    public void setNotificationServiceMappingId(Integer notificationServiceMappingId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("notificationServiceMappingId", this.notificationServiceMappingId, this.notificationServiceMappingId = notificationServiceMappingId);
        else
            this.notificationServiceMappingId = notificationServiceMappingId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONFIGURATIONID", unique=true, nullable=false)
    public Configuration getConfiguration() {
        return this.configuration;
    }
    
    public void setConfiguration(Configuration configuration) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("configuration", this.configuration, this.configuration = configuration);
        else
            this.configuration = configuration;
    }


    
    @Column(name="DEFAULTNOTIFICATIONSERVICE", nullable=false, length=256)
    public String getDefaultNotificationService() {
        return this.defaultNotificationService;
    }
    
    public void setDefaultNotificationService(String defaultNotificationService) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("defaultNotificationService", this.defaultNotificationService, this.defaultNotificationService = defaultNotificationService);
        else
            this.defaultNotificationService = defaultNotificationService;
    }


@OneToMany(cascade=CascadeType.PERSIST, fetch=FetchType.LAZY, mappedBy="notificationServiceMapping")
    @Cascade( {org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK} )
    public Set<DomainsMapping> getDomainsMappings() {
        return this.domainsMappings;
    }
    
    public void setDomainsMappings(Set<DomainsMapping> domainsMappings) {    
    	this.domainsMappings = domainsMappings;
    }

	public void addDomainsMappings(Set<DomainsMapping> elements) {
		if( this.domainsMappings != null )
			for(Iterator<DomainsMapping> it = elements.iterator(); it.hasNext(); )
				addDomainsMappingToDomainsMappings((DomainsMapping)it.next());
	}

	public void addDomainsMappingToDomainsMappings(DomainsMapping element) {
		if( !this.domainsMappings.contains(element) ) {
			this.domainsMappings.add(element);
		}
	}


@OneToMany(cascade=CascadeType.PERSIST, fetch=FetchType.LAZY, mappedBy="notificationServiceMapping")
    @Cascade( {org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK} )
    public Set<ChannelMapping> getChannelMappings() {
        return this.channelMappings;
    }
    
    public void setChannelMappings(Set<ChannelMapping> channelMappings) {    
    	this.channelMappings = channelMappings;
    }

	public void addChannelMappings(Set<ChannelMapping> elements) {
		if( this.channelMappings != null )
			for(Iterator<ChannelMapping> it = elements.iterator(); it.hasNext(); )
				addChannelMappingToChannelMappings((ChannelMapping)it.next());
	}

	public void addChannelMappingToChannelMappings(ChannelMapping element) {
		if( !this.channelMappings.contains(element) ) {
			this.channelMappings.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof NotificationServiceMapping) ) return false;
		 NotificationServiceMapping castOther = ( NotificationServiceMapping ) other; 
         
		 return ( (this.getConfiguration()==castOther.getConfiguration()) || ( this.getConfiguration()!=null && castOther.getConfiguration()!=null && this.getConfiguration().equals(castOther.getConfiguration()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getConfiguration() == null ? 0 : this.getConfiguration().hashCode() );
         
         
         
         return result;
   }   


}


