package alma.acs.tmcdb;
// Generated Jun 28, 2010 4:49:06 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * Location generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="LOCATION"
    , uniqueConstraints = @UniqueConstraint(columnNames={"BUILDING", "FLOOR", "ROOM", "MNEMONIC", "LOCATIONPOSITION"}) 
)
public class Location extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer locationId;
     protected String building;
     protected String floor;
     protected String room;
     protected String mnemonic;
     protected String locationPosition;
     private Set<FaultMember> faultMembers = new HashSet<FaultMember>(0);
     private Set<DefaultMember> defaultMembers = new HashSet<DefaultMember>(0);

    public Location() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="Location_seq")}
	)

    
    @Column(name="LOCATIONID", unique=true, nullable=false)
    public Integer getLocationId() {
        return this.locationId;
    }
    
    public void setLocationId(Integer locationId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("locationId", this.locationId, this.locationId = locationId);
        else
            this.locationId = locationId;
    }


    
    @Column(name="BUILDING", length=256)
    public String getBuilding() {
        return this.building;
    }
    
    public void setBuilding(String building) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("building", this.building, this.building = building);
        else
            this.building = building;
    }


    
    @Column(name="FLOOR", length=128)
    public String getFloor() {
        return this.floor;
    }
    
    public void setFloor(String floor) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("floor", this.floor, this.floor = floor);
        else
            this.floor = floor;
    }


    
    @Column(name="ROOM", length=256)
    public String getRoom() {
        return this.room;
    }
    
    public void setRoom(String room) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("room", this.room, this.room = room);
        else
            this.room = room;
    }


    
    @Column(name="MNEMONIC", length=256)
    public String getMnemonic() {
        return this.mnemonic;
    }
    
    public void setMnemonic(String mnemonic) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("mnemonic", this.mnemonic, this.mnemonic = mnemonic);
        else
            this.mnemonic = mnemonic;
    }


    
    @Column(name="LOCATIONPOSITION", length=256)
    public String getLocationPosition() {
        return this.locationPosition;
    }
    
    public void setLocationPosition(String locationPosition) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("locationPosition", this.locationPosition, this.locationPosition = locationPosition);
        else
            this.locationPosition = locationPosition;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="location")
    public Set<FaultMember> getFaultMembers() {
        return this.faultMembers;
    }
    
    public void setFaultMembers(Set<FaultMember> faultMembers) {    
    	this.faultMembers = faultMembers;
    }

	public void addFaultMembers(Set<FaultMember> elements) {
		if( this.faultMembers != null )
			for(Iterator<FaultMember> it = elements.iterator(); it.hasNext(); )
				addFaultMemberToFaultMembers((FaultMember)it.next());
	}

	public void addFaultMemberToFaultMembers(FaultMember element) {
		if( !this.faultMembers.contains(element) ) {
			this.faultMembers.add(element);
		}
	}


@OneToMany(fetch=FetchType.LAZY, mappedBy="location")
    public Set<DefaultMember> getDefaultMembers() {
        return this.defaultMembers;
    }
    
    public void setDefaultMembers(Set<DefaultMember> defaultMembers) {    
    	this.defaultMembers = defaultMembers;
    }

	public void addDefaultMembers(Set<DefaultMember> elements) {
		if( this.defaultMembers != null )
			for(Iterator<DefaultMember> it = elements.iterator(); it.hasNext(); )
				addDefaultMemberToDefaultMembers((DefaultMember)it.next());
	}

	public void addDefaultMemberToDefaultMembers(DefaultMember element) {
		if( !this.defaultMembers.contains(element) ) {
			this.defaultMembers.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof Location) ) return false;
		 Location castOther = ( Location ) other; 
         
		 return ( (this.getBuilding()==castOther.getBuilding()) || ( this.getBuilding()!=null && castOther.getBuilding()!=null && this.getBuilding().equals(castOther.getBuilding()) ) )
 && ( (this.getFloor()==castOther.getFloor()) || ( this.getFloor()!=null && castOther.getFloor()!=null && this.getFloor().equals(castOther.getFloor()) ) )
 && ( (this.getRoom()==castOther.getRoom()) || ( this.getRoom()!=null && castOther.getRoom()!=null && this.getRoom().equals(castOther.getRoom()) ) )
 && ( (this.getMnemonic()==castOther.getMnemonic()) || ( this.getMnemonic()!=null && castOther.getMnemonic()!=null && this.getMnemonic().equals(castOther.getMnemonic()) ) )
 && ( (this.getLocationPosition()==castOther.getLocationPosition()) || ( this.getLocationPosition()!=null && castOther.getLocationPosition()!=null && this.getLocationPosition().equals(castOther.getLocationPosition()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getBuilding() == null ? 0 : this.getBuilding().hashCode() );
         result = 37 * result + ( getFloor() == null ? 0 : this.getFloor().hashCode() );
         result = 37 * result + ( getRoom() == null ? 0 : this.getRoom().hashCode() );
         result = 37 * result + ( getMnemonic() == null ? 0 : this.getMnemonic().hashCode() );
         result = 37 * result + ( getLocationPosition() == null ? 0 : this.getLocationPosition().hashCode() );
         
         
         return result;
   }   


}


