package alma.acs.tmcdb;
// Generated Jun 28, 2010 4:49:06 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * FaultMember generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="FAULTMEMBER"
    , uniqueConstraints = @UniqueConstraint(columnNames={"MEMBERNAME", "FAULTFAMILYID"}) 
)
public class FaultMember extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer faultMemberId;
     protected FaultFamily faultFamily;
     protected Location location;
     protected String memberName;
     private Set<AlarmDefinition> alarmDefinitions = new HashSet<AlarmDefinition>(0);

    public FaultMember() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="FaultMember_seq")}
	)

    
    @Column(name="FAULTMEMBERID", unique=true, nullable=false)
    public Integer getFaultMemberId() {
        return this.faultMemberId;
    }
    
    public void setFaultMemberId(Integer faultMemberId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("faultMemberId", this.faultMemberId, this.faultMemberId = faultMemberId);
        else
            this.faultMemberId = faultMemberId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FAULTFAMILYID", nullable=false)
    public FaultFamily getFaultFamily() {
        return this.faultFamily;
    }
    
    public void setFaultFamily(FaultFamily faultFamily) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("faultFamily", this.faultFamily, this.faultFamily = faultFamily);
        else
            this.faultFamily = faultFamily;
    }


@ManyToOne(cascade=CascadeType.PERSIST, fetch=FetchType.LAZY)@Cascade( {org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.LOCK} )
    @JoinColumn(name="LOCATIONID")
    public Location getLocation() {
        return this.location;
    }
    
    public void setLocation(Location location) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("location", this.location, this.location = location);
        else
            this.location = location;
    }


    
    @Column(name="MEMBERNAME", nullable=false, length=256)
    public String getMemberName() {
        return this.memberName;
    }
    
    public void setMemberName(String memberName) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("memberName", this.memberName, this.memberName = memberName);
        else
            this.memberName = memberName;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="faultMember")
    public Set<AlarmDefinition> getAlarmDefinitions() {
        return this.alarmDefinitions;
    }
    
    public void setAlarmDefinitions(Set<AlarmDefinition> alarmDefinitions) {    
    	this.alarmDefinitions = alarmDefinitions;
    }

	public void addAlarmDefinitions(Set<AlarmDefinition> elements) {
		if( this.alarmDefinitions != null )
			for(Iterator<AlarmDefinition> it = elements.iterator(); it.hasNext(); )
				addAlarmDefinitionToAlarmDefinitions((AlarmDefinition)it.next());
	}

	public void addAlarmDefinitionToAlarmDefinitions(AlarmDefinition element) {
		if( !this.alarmDefinitions.contains(element) ) {
			this.alarmDefinitions.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof FaultMember) ) return false;
		 FaultMember castOther = ( FaultMember ) other; 
         
		 return ( (this.getFaultFamily()==castOther.getFaultFamily()) || ( this.getFaultFamily()!=null && castOther.getFaultFamily()!=null && this.getFaultFamily().equals(castOther.getFaultFamily()) ) )
 && ( (this.getMemberName()==castOther.getMemberName()) || ( this.getMemberName()!=null && castOther.getMemberName()!=null && this.getMemberName().equals(castOther.getMemberName()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getFaultFamily() == null ? 0 : this.getFaultFamily().hashCode() );
         
         result = 37 * result + ( getMemberName() == null ? 0 : this.getMemberName().hashCode() );
         
         return result;
   }   


}


