package alma.acs.tmcdb;
// Generated Jun 28, 2010 4:49:06 PM by Hibernate Tools 3.2.4.GA


import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

/**
 * FaultCode generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity
@Table(name="FAULTCODE"
    , uniqueConstraints = @UniqueConstraint(columnNames={"FAULTFAMILYID", "CODEVALUE"}) 
)
public class FaultCode extends alma.acs.tmcdb.translator.TmcdbObject implements java.io.Serializable {


     protected Integer faultCodeId;
     protected FaultFamily faultFamily;
     protected Integer codeValue;
     protected Integer priority;
     protected String cause;
     protected String action;
     protected String consequence;
     protected String problemDescription;
     protected Boolean isInstant;
     private Set<AlarmDefinition> alarmDefinitions = new HashSet<AlarmDefinition>(0);

    public FaultCode() {
    }
   
     @Id 
    @GeneratedValue(generator="generator")
    @GenericGenerator(name="generator", strategy="native",
       parameters = {@Parameter(name="sequence", value="FaultCode_seq")}
	)

    
    @Column(name="FAULTCODEID", unique=true, nullable=false)
    public Integer getFaultCodeId() {
        return this.faultCodeId;
    }
    
    public void setFaultCodeId(Integer faultCodeId) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("faultCodeId", this.faultCodeId, this.faultCodeId = faultCodeId);
        else
            this.faultCodeId = faultCodeId;
    }


@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FAULTFAMILYID", nullable=false)
    public FaultFamily getFaultFamily() {
        return this.faultFamily;
    }
    
    public void setFaultFamily(FaultFamily faultFamily) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("faultFamily", this.faultFamily, this.faultFamily = faultFamily);
        else
            this.faultFamily = faultFamily;
    }


    
    @Column(name="CODEVALUE", nullable=false)
    public Integer getCodeValue() {
        return this.codeValue;
    }
    
    public void setCodeValue(Integer codeValue) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("codeValue", this.codeValue, this.codeValue = codeValue);
        else
            this.codeValue = codeValue;
    }


    
    @Column(name="PRIORITY", nullable=false)
    public Integer getPriority() {
        return this.priority;
    }
    
    public void setPriority(Integer priority) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("priority", this.priority, this.priority = priority);
        else
            this.priority = priority;
    }


    
    @Column(name="CAUSE", length=256)
    public String getCause() {
        return this.cause;
    }
    
    public void setCause(String cause) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("cause", this.cause, this.cause = cause);
        else
            this.cause = cause;
    }


    
    @Column(name="ACTION", length=0)
    public String getAction() {
        return this.action;
    }
    
    public void setAction(String action) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("action", this.action, this.action = action);
        else
            this.action = action;
    }


    
    @Column(name="CONSEQUENCE", length=0)
    public String getConsequence() {
        return this.consequence;
    }
    
    public void setConsequence(String consequence) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("consequence", this.consequence, this.consequence = consequence);
        else
            this.consequence = consequence;
    }


    
    @Column(name="PROBLEMDESCRIPTION", nullable=false, length=0)
    public String getProblemDescription() {
        return this.problemDescription;
    }
    
    public void setProblemDescription(String problemDescription) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("problemDescription", this.problemDescription, this.problemDescription = problemDescription);
        else
            this.problemDescription = problemDescription;
    }


    
    @Column(name="ISINSTANT", nullable=false)
    public Boolean getIsInstant() {
        return this.isInstant;
    }
    
    public void setIsInstant(Boolean isInstant) {    
        if( propertyChangeSupport != null )
            propertyChangeSupport.firePropertyChange("isInstant", this.isInstant, this.isInstant = isInstant);
        else
            this.isInstant = isInstant;
    }


@OneToMany(fetch=FetchType.LAZY, mappedBy="faultCode")
    public Set<AlarmDefinition> getAlarmDefinitions() {
        return this.alarmDefinitions;
    }
    
    public void setAlarmDefinitions(Set<AlarmDefinition> alarmDefinitions) {    
    	this.alarmDefinitions = alarmDefinitions;
    }

	public void addAlarmDefinitions(Set<AlarmDefinition> elements) {
		if( this.alarmDefinitions != null )
			for(Iterator<AlarmDefinition> it = elements.iterator(); it.hasNext(); )
				addAlarmDefinitionToAlarmDefinitions((AlarmDefinition)it.next());
	}

	public void addAlarmDefinitionToAlarmDefinitions(AlarmDefinition element) {
		if( !this.alarmDefinitions.contains(element) ) {
			this.alarmDefinitions.add(element);
		}
	}



   public boolean equalsContent(Object other) {
         if ( (this == other ) ) return true;
		 if ( (other == null ) ) return false;
		 if ( !(other instanceof FaultCode) ) return false;
		 FaultCode castOther = ( FaultCode ) other; 
         
		 return ( (this.getFaultFamily()==castOther.getFaultFamily()) || ( this.getFaultFamily()!=null && castOther.getFaultFamily()!=null && this.getFaultFamily().equals(castOther.getFaultFamily()) ) )
 && ( (this.getCodeValue()==castOther.getCodeValue()) || ( this.getCodeValue()!=null && castOther.getCodeValue()!=null && this.getCodeValue().equals(castOther.getCodeValue()) ) );
   }

   public int hashCodeContent() {
         int result = 17;
         
         
         result = 37 * result + ( getFaultFamily() == null ? 0 : this.getFaultFamily().hashCode() );
         result = 37 * result + ( getCodeValue() == null ? 0 : this.getCodeValue().hashCode() );
         
         
         
         
         
         
         
         return result;
   }   


}


